
#line 3 "dagcat_rule_file_parser.c"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define yy_create_buffer dagcat_parse_create_buffer
#define yy_delete_buffer dagcat_parse_delete_buffer
#define yy_flex_debug dagcat_parse_flex_debug
#define yy_init_buffer dagcat_parse_init_buffer
#define yy_flush_buffer dagcat_parse_flush_buffer
#define yy_load_buffer_state dagcat_parse_load_buffer_state
#define yy_switch_to_buffer dagcat_parse_switch_to_buffer
#define yyin dagcat_parsein
#define yyleng dagcat_parseleng
#define yylex dagcat_parselex
#define yylineno dagcat_parselineno
#define yyout dagcat_parseout
#define yyrestart dagcat_parserestart
#define yytext dagcat_parsetext
#define yywrap dagcat_parsewrap
#define yyalloc dagcat_parsealloc
#define yyrealloc dagcat_parserealloc
#define yyfree dagcat_parsefree

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 5
#define YY_FLEX_SUBMINOR_VERSION 35
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#endif /* ! C99 */

#endif /* ! FLEXINT_H */

#ifdef __cplusplus

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

/* C99 requires __STDC__ to be defined as 1. */
#if defined (__STDC__)

#define YY_USE_CONST

#endif	/* defined (__STDC__) */
#endif	/* ! __cplusplus */

#ifdef YY_USE_CONST
#define yyconst const
#else
#define yyconst
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (yy_start) = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START (((yy_start) - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE dagcat_parserestart(dagcat_parsein  )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#define YY_BUF_SIZE 16384
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

extern int dagcat_parseleng;

extern FILE *dagcat_parsein, *dagcat_parseout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

    /* Note: We specifically omit the test for yy_rule_can_match_eol because it requires
     *       access to the local variable yy_act. Since yyless() is a macro, it would break
     *       existing scanners that call yyless() from OUTSIDE dagcat_parselex. 
     *       One obvious solution it to make yy_act a global. I tried that, and saw
     *       a 5% performance hit in a non-dagcat_parselineno scanner, because yy_act is
     *       normally declared as a register variable-- so it is not worth it.
     */
    #define  YY_LESS_LINENO(n) \
            do { \
                int yyl;\
                for ( yyl = n; yyl < dagcat_parseleng; ++yyl )\
                    if ( dagcat_parsetext[yyl] == '\n' )\
                        --dagcat_parselineno;\
            }while(0)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up dagcat_parsetext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = (yy_hold_char); \
		YY_RESTORE_YY_MORE_OFFSET \
		(yy_c_buf_p) = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up dagcat_parsetext again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, (yytext_ptr)  )

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t yy_size_t;
#endif

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	yy_size_t yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */
    
	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via dagcat_parserestart()), so that the user can continue scanning by
	 * just pointing dagcat_parsein at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* Stack of input buffers. */
static size_t yy_buffer_stack_top = 0; /**< index of top of stack. */
static size_t yy_buffer_stack_max = 0; /**< capacity of stack. */
static YY_BUFFER_STATE * yy_buffer_stack = 0; /**< Stack as an array. */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( (yy_buffer_stack) \
                          ? (yy_buffer_stack)[(yy_buffer_stack_top)] \
                          : NULL)

/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE (yy_buffer_stack)[(yy_buffer_stack_top)]

/* yy_hold_char holds the character lost when dagcat_parsetext is formed. */
static char yy_hold_char;
static int yy_n_chars;		/* number of characters read into yy_ch_buf */
int dagcat_parseleng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = (char *) 0;
static int yy_init = 0;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow dagcat_parsewrap()'s to do buffer switches
 * instead of setting up a fresh dagcat_parsein.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

void dagcat_parserestart (FILE *input_file  );
void dagcat_parse_switch_to_buffer (YY_BUFFER_STATE new_buffer  );
YY_BUFFER_STATE dagcat_parse_create_buffer (FILE *file,int size  );
void dagcat_parse_delete_buffer (YY_BUFFER_STATE b  );
void dagcat_parse_flush_buffer (YY_BUFFER_STATE b  );
void dagcat_parsepush_buffer_state (YY_BUFFER_STATE new_buffer  );
void dagcat_parsepop_buffer_state (void );

static void dagcat_parseensure_buffer_stack (void );
static void dagcat_parse_load_buffer_state (void );
static void dagcat_parse_init_buffer (YY_BUFFER_STATE b,FILE *file  );

#define YY_FLUSH_BUFFER dagcat_parse_flush_buffer(YY_CURRENT_BUFFER )

YY_BUFFER_STATE dagcat_parse_scan_buffer (char *base,yy_size_t size  );
YY_BUFFER_STATE dagcat_parse_scan_string (yyconst char *yy_str  );
YY_BUFFER_STATE dagcat_parse_scan_bytes (yyconst char *bytes,int len  );

void *dagcat_parsealloc (yy_size_t  );
void *dagcat_parserealloc (void *,yy_size_t  );
void dagcat_parsefree (void *  );

#define yy_new_buffer dagcat_parse_create_buffer

#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        dagcat_parseensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            dagcat_parse_create_buffer(dagcat_parsein,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}

#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        dagcat_parseensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            dagcat_parse_create_buffer(dagcat_parsein,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */

#define dagcat_parsewrap(n) 1
#define YY_SKIP_YYWRAP

typedef unsigned char YY_CHAR;

FILE *dagcat_parsein = (FILE *) 0, *dagcat_parseout = (FILE *) 0;

typedef int yy_state_type;

extern int dagcat_parselineno;

int dagcat_parselineno = 1;

extern char *dagcat_parsetext;
#define yytext_ptr dagcat_parsetext

static yy_state_type yy_get_previous_state (void );
static yy_state_type yy_try_NUL_trans (yy_state_type current_state  );
static int yy_get_next_buffer (void );
static void yy_fatal_error (yyconst char msg[]  );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up dagcat_parsetext.
 */
#define YY_DO_BEFORE_ACTION \
	(yytext_ptr) = yy_bp; \
	dagcat_parseleng = (size_t) (yy_cp - yy_bp); \
	(yy_hold_char) = *yy_cp; \
	*yy_cp = '\0'; \
	(yy_c_buf_p) = yy_cp;

#define YY_NUM_RULES 30
#define YY_END_OF_BUFFER 31
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static yyconst flex_int16_t yy_acclist[161] =
    {   0,
        1,    1,16386,    1,    1,    1,    1,    1,    1,    1,
       25,    1,   25,    1,    1,   31,   27,   30,    1,   27,
       30,   28,   30,   27,   30,   27,   30,    1,   27,   30,
    16386,   27,   30,   27,   30,   27,   30,   27,   30,   27,
       30,    6,   27,   30,    1,    6,   27,   30,    7,   30,
        6,   27,   30,    6,   27,   30,    6,   27,   30,   11,
       27,   30,    1,   11,   27,   30,   12,   30,   11,   27,
       30,   11,   27,   30,   11,   27,   30,   16,   27,   30,
        1,   16,   27,   30,   17,   30,   16,   27,   30,   16,
       27,   30,   16,   27,   30,   25,   27,   30,    1,   25,

       27,   30,   24,   25,   30,   22,   27,   30,   25,   27,
       30,   25,   27,   30,   29,   30,   27,   30,   27,   30,
       27,   30,   27,   30,   27,   30,    1,   21,   26,    1,
    16386,   25,    1,   25,   23,   25,   25,   25,   26,   20,
     8194,   25,   20,   25,   19,    9,   19,    5,   10,   15,
        4,    9,    8,   14,    4,    3,   14,   13,   18,   18
    } ;

static yyconst flex_int16_t yy_accept[144] =
    {   0,
        1,    2,    4,    5,    6,    7,    8,    9,   10,   12,
       14,   15,   16,   17,   19,   22,   24,   26,   28,   32,
       34,   36,   38,   40,   42,   45,   49,   51,   54,   57,
       60,   63,   67,   69,   72,   75,   78,   81,   85,   87,
       90,   93,   96,   99,  103,  106,  109,  112,  115,  117,
      119,  121,  123,  125,  127,  128,  129,  129,  129,  130,
      132,  132,  132,  132,  132,  132,  132,  132,  132,  132,
      132,  132,  132,  132,  132,  132,  132,  133,  135,  136,
      137,  138,  140,  140,  140,  140,  140,  140,  140,  141,
      141,  141,  141,  142,  142,  142,  142,  142,  142,  142,

      142,  143,  145,  145,  145,  145,  146,  146,  146,  146,
      146,  146,  146,  146,  146,  146,  146,  146,  147,  147,
      148,  148,  148,  148,  149,  149,  150,  150,  151,  152,
      153,  154,  155,  155,  156,  157,  158,  159,  159,  159,
      160,  161,  161
    } ;

static yyconst flex_int32_t yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    4,    1,    5,    6,    1,    7,    8,    8,    8,
        8,    8,    8,    8,    8,    8,    8,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        9,   10,   11,    1,    1,    1,   12,    1,   13,    1,

       14,   15,    1,   16,   17,    1,    1,   18,   19,   20,
       21,    1,    1,   22,   23,   24,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static yyconst flex_int32_t yy_meta[25] =
    {   0,
        1,    1,    1,    2,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1
    } ;

static yyconst flex_int16_t yy_base[151] =
    {   0,
        0,    9,   31,   40,   49,   58,   67,   76,   85,   94,
      103,    0,  243,  244,  240,  244,    1,   11,  125,  220,
      228,  224,  217,  213,  244,  234,  244,    2,   13,   15,
      244,  233,  244,   16,   22,   25,  244,  232,  244,   32,
       29,   42,    0,  231,    0,  225,   50,   60,  244,  210,
      218,  214,  207,  203,  224,  244,  222,   69,  244,    0,
      203,  211,  207,  200,  196,  201,  195,  205,  192,  193,
       73,  101,   82,  106,   91,  109,    0,  212,  244,  118,
      122,    0,  195,  189,  199,  186,  187,  205,  244,  186,
      190,  192,  244,  190,  126,   92,  127,  128,  129,  132,

      140,    0,  166,  168,  165,  160,  140,  128,  125,  125,
      144,  145,  147,  149,  156,  157,   96,  159,   99,  108,
       90,   61,   44,  244,   62,  244,   80,  244,  161,  164,
       58,  168,   34,  169,   40,  171,   27,  172,  173,  180,
      181,  244,  189,  191,  193,  195,  197,    0,  199,  201
    } ;

static yyconst flex_int16_t yy_def[151] =
    {   0,
      143,  143,  144,  144,  145,  145,  146,  146,  147,  147,
        2,   11,  142,  142,  142,  142,  142,  142,  142,  142,
      142,  142,  142,  142,  142,  142,  142,  142,  142,  142,
      142,  142,  142,  142,  142,  142,  142,  142,  142,  142,
      142,  142,  148,  148,  148,  142,  148,  148,  142,  142,
      142,  142,  142,  142,  142,  142,  149,  142,  142,   19,
      142,  142,  142,  142,  142,  142,  142,  142,  142,  142,
      142,  142,  142,  142,  142,  142,  148,  148,  142,  150,
      148,  148,  142,  142,  142,  142,  142,  149,  142,  142,
      142,  142,  142,  142,  142,  142,  142,  142,  142,  142,

      150,  148,  142,  142,  142,  142,  142,  142,  142,  142,
      142,  142,  142,  142,  142,  142,  142,  142,  142,  142,
      142,  142,  142,  142,  142,  142,  142,  142,  142,  142,
      142,  142,  142,  142,  142,  142,  142,  142,  142,  142,
      142,    0,  142,  142,  142,  142,  142,  142,  142,  142
    } ;

static yyconst flex_int16_t yy_nxt[269] =
    {   0,
       77,   15,   16,  142,   56,   56,   17,   57,   57,   18,
       19,   16,   58,   59,   71,   17,   58,   59,   18,   56,
       72,   20,   57,   73,   21,   22,   58,   59,   23,   74,
       75,   24,   26,   27,  137,   56,   76,   28,   57,   29,
       30,   26,   27,   58,   59,  123,   28,  135,   29,   30,
       32,   33,  138,   56,  124,   34,   80,   35,   36,   32,
       33,   81,   82,  125,   34,  131,   35,   36,   38,   39,
       58,   59,  126,   40,   71,   41,   42,   38,   39,   93,
       72,  127,   40,   73,   41,   42,   44,   45,   46,   74,
      128,   47,   75,  111,   48,   44,   45,   46,   76,  112,

       47,  133,   95,   48,   15,   49,   96,   97,   72,  120,
       99,   98,  132,   74,  100,   50,   76,  129,   51,   52,
      102,   88,   53,   81,   82,   54,   60,   95,   97,  113,
       99,   96,   98,  115,  100,  114,  122,   61,   93,  116,
       62,   63,  102,   88,   64,  111,  123,   65,  113,   93,
      125,  112,  112,  121,  114,  124,  114,  115,  127,  126,
      130,  120,  134,  116,  116,  130,  131,  128,  135,  136,
      134,  131,  136,  139,  139,  137,  135,  119,  137,  140,
      140,  141,  141,  118,  141,  141,  117,  141,  141,   14,
       14,   25,   25,   31,   31,   37,   37,   43,   43,   88,

       88,  101,  101,  110,  109,   93,  108,   89,  107,  106,
      105,  104,  103,   78,   94,   93,   92,   91,   90,   70,
       69,   68,   67,   66,   89,   55,   87,   86,   85,   84,
       83,   79,   78,   55,   55,   55,   70,   69,   68,   67,
       66,   55,  142,   13,  142,  142,  142,  142,  142,  142,
      142,  142,  142,  142,  142,  142,  142,  142,  142,  142,
      142,  142,  142,  142,  142,  142,  142,  142
    } ;

static yyconst flex_int16_t yy_chk[269] =
    {   0,
      148,    1,    1,    0,   17,   28,    1,   17,   28,    1,
        2,    2,   18,   18,   29,    2,   30,   30,    2,   34,
       29,    2,   34,   35,    2,    2,   36,   36,    2,   35,
       41,    2,    3,    3,  137,   40,   41,    3,   40,    3,
        3,    4,    4,   42,   42,  123,    4,  135,    4,    4,
        5,    5,  133,   47,  123,    5,   47,    5,    5,    6,
        6,   48,   48,  125,    6,  131,    6,    6,    7,    7,
       58,   58,  125,    7,   71,    7,    7,    8,    8,  122,
       71,  127,    8,   73,    8,    8,    9,    9,    9,   73,
      127,    9,   75,   96,    9,   10,   10,   10,   75,   96,

       10,  121,   72,   10,   11,   11,   72,   74,   72,  120,
       76,   74,  119,   74,   76,   11,   76,  117,   11,   11,
       80,   80,   11,   81,   81,   11,   19,   95,   97,   98,
       99,   95,   97,  100,   99,   98,  110,   19,  109,  100,
       19,   19,  101,  101,   19,  111,  112,   19,  113,  108,
      114,  111,  112,  107,  113,  112,  114,  115,  116,  114,
      118,  106,  129,  115,  116,  130,  118,  116,  129,  132,
      134,  130,  136,  138,  139,  132,  134,  105,  136,  138,
      139,  140,  141,  104,  140,  141,  103,  140,  141,  143,
      143,  144,  144,  145,  145,  146,  146,  147,  147,  149,

      149,  150,  150,   94,   92,   91,   90,   88,   87,   86,
       85,   84,   83,   78,   70,   69,   68,   67,   66,   65,
       64,   63,   62,   61,   57,   55,   54,   53,   52,   51,
       50,   46,   44,   38,   32,   26,   24,   23,   22,   21,
       20,   15,   13,  142,  142,  142,  142,  142,  142,  142,
      142,  142,  142,  142,  142,  142,  142,  142,  142,  142,
      142,  142,  142,  142,  142,  142,  142,  142
    } ;

/* Table of booleans, true if rule could match eol. */
static yyconst flex_int32_t yy_rule_can_match_eol[31] =
    {   0,
0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 
    1, 0, 0, 0, 1, 1, 1, 0, 1, 1, 0,     };

extern int dagcat_parse_flex_debug;
int dagcat_parse_flex_debug = 0;

static yy_state_type *yy_state_buf=0, *yy_state_ptr=0;
static char *yy_full_match;
static int yy_lp;
static int yy_looking_for_trail_begin = 0;
static int yy_full_lp;
static int *yy_full_state;
#define YY_TRAILING_MASK 0x2000
#define YY_TRAILING_HEAD_MASK 0x4000
#define REJECT \
{ \
*yy_cp = (yy_hold_char); /* undo effects of setting up dagcat_parsetext */ \
yy_cp = (yy_full_match); /* restore poss. backed-over text */ \
(yy_lp) = (yy_full_lp); /* restore orig. accepting pos. */ \
(yy_state_ptr) = (yy_full_state); /* restore orig. state */ \
yy_current_state = *(yy_state_ptr); /* restore curr. state */ \
++(yy_lp); \
goto find_rule; \
}

#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *dagcat_parsetext;
#line 1 "dagcat_rule_file_parser.l"
/*
 * Copyright (c) 2003 Endace Technology Ltd, Hamilton, New Zealand.
 * All rights reserved.
 *
 * This source code is proprietary to Endace Technology Ltd and no part
 * of it may be redistributed, published or disclosed except as outlined
 * in the written contract supplied with this product.
 *
 * $Id: dagcat_rule_file_parser.c 11397 2009-06-18 10:26:30Z jomi $
 * This file defines the key words which could be used to configure the CAT Module
 */

#line 27 "dagcat_rule_file_parser.l"
#include <stdio.h>
#include <stdlib.h>
#include "dagcat_includes.h"

static FILE *out;

	/*
	 * Debugging the gramer defines and general output 
	 * DAG_CAT_RULE_PRINT: will output the actual recognized rules with out extra lines and comments 
	 * DAG_CATLEX_DEBUG: Used for intial of the rule and print out of the result 
	 * DAG_CATLEX_DEBUG_R: used for the actual rules and individual states 
	 * DAG_CATLEX_DEBUG_COMMENT : used for comments debbuging and empty lines 
	*/
#define DAG_CAT_RULE_PRINT 0
#define DAG_CATLEX_DEBUG 0
#define DAG_CATLEX_DEBUG_R 0
#define DAG_CATLEX_DEBUG_COMMENT 0

//this is done so multipl parsers to be able to be used in the same application 
//each pareser just have to change this define and the prefix in the option 

#define yy_filter_rule dagcat_config_rule

dagcat_config_rule_t yy_filter_rule;
static uint8_t is_value_inverted = 0;
//#define S_dagcat_rule INITIAL
/* supporting fuunction to be moved to some part of the library  */
#line 57 "dagcat_rule_file_parser.l"
int resolve_range_values(const char *text, uint32_t* ptr_from, uint32_t* ptr_to)
{
    /* expects [<int_from>-<int_to>] format */
    char *end_ptr = NULL; // for strtol functions
    uint32_t    temp_from = 0;
    uint32_t    temp_to = 0;
    const char *parse_string = text;
    
    if ( ( NULL == ptr_from ) || ( NULL == ptr_to ))
    {
        fprintf(out,"\n Null pointers\t");
        return -1;
    }
    /* text shud contain [ first */
    if ( '[' != *parse_string )
    {
        fprintf(out,"\nError in Range:Missing [\t");
        return -1;
    }
    /* skip past [ */
    parse_string++;
    /* get the from value */
    errno = 0;
    temp_from = strtoul ( parse_string, &end_ptr, 10 );
    if ( (errno != 0) || ( end_ptr == parse_string) )
    {
        fprintf(out,"\nError in Range:in <from> value\t");
        return -1;
    }
    parse_string = end_ptr;
    /* skip any space after from value */
    while (isspace(*parse_string))
    {
        parse_string++;
    }
    /* now we expect a '-' */
    if ( '-' != *parse_string )
    {
        fprintf(out,"\nError in Range:Missing -:\t");
        return -1;
    }
    /* skip past - */
    parse_string++;
    /* get the to value */
    errno = 0;
    temp_to = strtoul ( parse_string, &end_ptr, 10 );
    if ( (errno != 0) || ( end_ptr == parse_string) )
    {
        fprintf(out,"\nError in Range:in <to> value.\t");
        return -1;
    }
    parse_string = end_ptr;
     /* skip any space after from value */
    while (isspace(*parse_string))
    {
        parse_string++;
    }
    /* text shud contain ] next */
    if ( ']' != *parse_string )
    {
        fprintf(out,"\nError in Range:Missing ]");
        return -1;
    }
    if ( temp_from > temp_to )
    {
        fprintf(out,"\nError:From value greater than To value of Range. \t");
        return -1;
    }
    *ptr_from = temp_from;
    *ptr_to   = temp_to;
    return 0;
}
int resolve_stream_list(const char *text, uint64_t* ptr_stream)
{
    char *end_ptr = NULL; // for strtol functions
    uint32_t    temp= 0;
    uint64_t    ret_val = 0;
    const char *parse_string = text;
    
    if ( NULL == ptr_stream)
    {
        fprintf(out,"\n Null pointers\n");
        return -1;
    }
    while( *parse_string != '\0')
    {
        if (isspace(*parse_string))
        {
        parse_string++;
        continue;
        }
        temp = strtoul ( parse_string, &end_ptr, 10 );
        if ( (errno != 0) || ( end_ptr == parse_string) )
        {
            fprintf(out,"\nError in streamlist value:unknown character: %c",*parse_string);
            return -1;
        }
        /* check whether they are indeed recv streams */
        if ( 1 == (temp % 2) ) 
        {
            fprintf(out,"\nError in streamlist value:%d is not receive stream",temp);
            return -1;
        }
        ret_val |= ( (uint64_t) 1 << (temp >> 1));
        parse_string = end_ptr;
        /* skip any space after from value */
        while (isspace(*parse_string))
        {
            parse_string++;
        }
        if ( *parse_string == ',')parse_string++;
    }
    *ptr_stream = ret_val;
    return 0;
}
#line 783 "dagcat_rule_file_parser.c"

#define INITIAL 0
#define S_color_range 1
#define S_hash_range 2
#define S_iface_range 3
#define S_comment 4
#define S_dagcat_rule 5

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

static int yy_init_globals (void );

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int dagcat_parselex_destroy (void );

int dagcat_parseget_debug (void );

void dagcat_parseset_debug (int debug_flag  );

YY_EXTRA_TYPE dagcat_parseget_extra (void );

void dagcat_parseset_extra (YY_EXTRA_TYPE user_defined  );

FILE *dagcat_parseget_in (void );

void dagcat_parseset_in  (FILE * in_str  );

FILE *dagcat_parseget_out (void );

void dagcat_parseset_out  (FILE * out_str  );

int dagcat_parseget_leng (void );

char *dagcat_parseget_text (void );

int dagcat_parseget_lineno (void );

void dagcat_parseset_lineno (int line_number  );

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int dagcat_parsewrap (void );
#else
extern int dagcat_parsewrap (void );
#endif
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy (char *,yyconst char *,int );
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * );
#endif

#ifndef YY_NO_INPUT

#ifdef __cplusplus
static int yyinput (void );
#else
static int input (void );
#endif

#endif

        static int yy_start_stack_ptr = 0;
        static int yy_start_stack_depth = 0;
        static int *yy_start_stack = NULL;
    
    static void yy_push_state (int new_state );
    
    static void yy_pop_state (void );
    
    static int yy_top_state (void );
    
/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#define YY_READ_BUF_SIZE 8192
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO fwrite( dagcat_parsetext, dagcat_parseleng, 1, dagcat_parseout )
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		size_t n; \
		for ( n = 0; n < max_size && \
			     (c = getc( dagcat_parsein )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( dagcat_parsein ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = fread(buf, 1, max_size, dagcat_parsein))==0 && ferror(dagcat_parsein)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(dagcat_parsein); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int dagcat_parselex (void);

#define YY_DECL int dagcat_parselex (void)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after dagcat_parsetext and dagcat_parseleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK break;
#endif

#define YY_RULE_SETUP \
	if ( dagcat_parseleng > 0 ) \
		YY_CURRENT_BUFFER_LVALUE->yy_at_bol = \
				(dagcat_parsetext[dagcat_parseleng - 1] == '\n'); \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	register yy_state_type yy_current_state;
	register char *yy_cp, *yy_bp;
	register int yy_act;
    
#line 174 "dagcat_rule_file_parser.l"

#line 983 "dagcat_rule_file_parser.c"

	if ( !(yy_init) )
		{
		(yy_init) = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

        /* Create the reject buffer large enough to save one state per allowed character. */
        if ( ! (yy_state_buf) )
            (yy_state_buf) = (yy_state_type *)dagcat_parsealloc(YY_STATE_BUF_SIZE  );
            if ( ! (yy_state_buf) )
                YY_FATAL_ERROR( "out of dynamic memory in dagcat_parselex()" );

		if ( ! (yy_start) )
			(yy_start) = 1;	/* first start state */

		if ( ! dagcat_parsein )
			dagcat_parsein = stdin;

		if ( ! dagcat_parseout )
			dagcat_parseout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			dagcat_parseensure_buffer_stack ();
			YY_CURRENT_BUFFER_LVALUE =
				dagcat_parse_create_buffer(dagcat_parsein,YY_BUF_SIZE );
		}

		dagcat_parse_load_buffer_state( );
		}

	while ( 1 )		/* loops until end-of-file is reached */
		{
		yy_cp = (yy_c_buf_p);

		/* Support of dagcat_parsetext. */
		*yy_cp = (yy_hold_char);

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = (yy_start);
		yy_current_state += YY_AT_BOL();

		(yy_state_ptr) = (yy_state_buf);
		*(yy_state_ptr)++ = yy_current_state;

yy_match:
		do
			{
			register YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)];
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 143 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			*(yy_state_ptr)++ = yy_current_state;
			++yy_cp;
			}
		while ( yy_base[yy_current_state] != 244 );

yy_find_action:
		yy_current_state = *--(yy_state_ptr);
		(yy_lp) = yy_accept[yy_current_state];
find_rule: /* we branch to this label when backing up */
		for ( ; ; ) /* until we find what rule we matched */
			{
			if ( (yy_lp) && (yy_lp) < yy_accept[yy_current_state + 1] )
				{
				yy_act = yy_acclist[(yy_lp)];
				if ( yy_act & YY_TRAILING_HEAD_MASK ||
				     (yy_looking_for_trail_begin) )
					{
					if ( yy_act == (yy_looking_for_trail_begin) )
						{
						(yy_looking_for_trail_begin) = 0;
						yy_act &= ~YY_TRAILING_HEAD_MASK;
						break;
						}
					}
				else if ( yy_act & YY_TRAILING_MASK )
					{
					(yy_looking_for_trail_begin) = yy_act & ~YY_TRAILING_MASK;
					(yy_looking_for_trail_begin) |= YY_TRAILING_HEAD_MASK;
					}
				else
					{
					(yy_full_match) = yy_cp;
					(yy_full_state) = (yy_state_ptr);
					(yy_full_lp) = (yy_lp);
					break;
					}
				++(yy_lp);
				goto find_rule;
				}
			--yy_cp;
			yy_current_state = *--(yy_state_ptr);
			(yy_lp) = yy_accept[yy_current_state];
			}

		YY_DO_BEFORE_ACTION;

		if ( yy_act != YY_END_OF_BUFFER && yy_rule_can_match_eol[yy_act] )
			{
			int yyl;
			for ( yyl = 0; yyl < dagcat_parseleng; ++yyl )
				if ( dagcat_parsetext[yyl] == '\n' )
					   
    dagcat_parselineno++;
;
			}

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
case 1:
YY_RULE_SETUP
#line 175 "dagcat_rule_file_parser.l"
;
	YY_BREAK
/* Start of rule and a TAG recognition */
case 2:
YY_RULE_SETUP
#line 179 "dagcat_rule_file_parser.l"
{
			//clear the current rule to all zero
			//memset(&yy_filter_rule,0,sizeof(yy_filter_rule));
	 		BEGIN(S_dagcat_rule);
	#if DAG_CATLEX_DEBUG
	 		fprintf(out,"START RULE:  line_no: %d %s",dagcat_parselineno,dagcat_parsetext );
	 		fprintf(out, "\n");
	#endif 
		}
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 189 "dagcat_rule_file_parser.l"
{
        yy_filter_rule.color_from   = atoi(&dagcat_parsetext[5]);
        yy_filter_rule.color_to     = yy_filter_rule.color_from;
        /* if it was an inverted value */
        yy_filter_rule.is_color_inverted = is_value_inverted;
        /* for next parsing ,reset it to zero */
        is_value_inverted = 0;
        #if DAG_CAT_RULE_PRINT
		fprintf( out, "Color ,%u - %u  line_no: %d\n",yy_filter_rule.color_from, yy_filter_rule.color_to, dagcat_parselineno );
		#endif 
		}
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 200 "dagcat_rule_file_parser.l"
{ 	
			BEGIN(S_color_range); 
			#if DAG_CATLEX_DEBUG_R
			ECHO; //example for debugging 
			fprintf( out, "->RECOGNIZED line_no: %d\n",dagcat_parselineno );
			#endif 	  
		}
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 208 "dagcat_rule_file_parser.l"
{ 
		#if DAG_CATLEX_DEBUG_R
		//example for debugging the expressions after the main key word is recognised
		ECHO;
		fprintf( out, "->RECOGNIZED line_no: %d\n",dagcat_parselineno ); 
		#endif 
		
		if (-1 == resolve_range_values( dagcat_parsetext, 
			&yy_filter_rule.color_from, 
			&yy_filter_rule.color_to) )
		{	
			fprintf(out, "ERROR: Bad color parameter line_no: %d\n",dagcat_parselineno );
			return T_ERROR;
		};
        /* if it was an inverted value */
        yy_filter_rule.is_color_inverted = is_value_inverted;
        /* for next parsing ,reset it to zero */
        is_value_inverted = 0;
		#if DAG_CAT_RULE_PRINT
		fprintf( out, "Color ,%u - %u  line_no: %d\n",yy_filter_rule.color_from, yy_filter_rule.color_to, dagcat_parselineno );
		#endif 
		BEGIN(S_dagcat_rule);
	}
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 233 "dagcat_rule_file_parser.l"
{
			fprintf( out,"ERROR: wrong format starting with %s on line: %d after color  '[]' expected! \n",dagcat_parsetext, dagcat_parselineno);
			return T_ERROR;
	}	
	YY_BREAK
case 7:
/* rule 7 can match eol */
YY_RULE_SETUP
#line 237 "dagcat_rule_file_parser.l"
{
			fprintf(out,"ERROR: unexpected end of line on line: %d ! \n", dagcat_parselineno-1);
			return T_ERROR;
	}		
	YY_BREAK
case 8:
YY_RULE_SETUP
#line 242 "dagcat_rule_file_parser.l"
{
            yy_filter_rule.hash_from   = atoi(&dagcat_parsetext[4]);
            yy_filter_rule.hash_to     = yy_filter_rule.hash_from;
            /* if it was an inverted value */
            yy_filter_rule.is_hash_inverted = is_value_inverted;
            /* for next parsing ,reset it to zero */
            is_value_inverted = 0;
            #if DAG_CAT_RULE_PRINT
            fprintf( out, "Hash ,%u - %u  line_no: %d\n",yy_filter_rule.hash_from, yy_filter_rule.hash_to, dagcat_parselineno );
             #endif 
		}
	YY_BREAK
case 9:
YY_RULE_SETUP
#line 253 "dagcat_rule_file_parser.l"
{ 	
			BEGIN(S_hash_range); 
			#if DAG_CATLEX_DEBUG_R
			ECHO; //example for debugging 
			fprintf( out, "->RECOGNIZED line_no: %d\n",dagcat_parselineno );
			#endif 	  
		}
	YY_BREAK
case 10:
YY_RULE_SETUP
#line 261 "dagcat_rule_file_parser.l"
{ 
		#if DAG_CATLEX_DEBUG_R
		//example for debugging the expressions after the main key word is recognised
		ECHO;
		fprintf( out, "->RECOGNIZED line_no: %d\n",dagcat_parselineno ); 
		#endif 
		
		if (-1 == resolve_range_values( dagcat_parsetext, 
			&yy_filter_rule.hash_from, 
			&yy_filter_rule.hash_to) )
		{	
			fprintf(out, "ERROR: Bad hash parameter line_no: %d\n",dagcat_parselineno );
			return T_ERROR;
		};
        /* if it was an inverted value */
        yy_filter_rule.is_hash_inverted = is_value_inverted;
        /* for next parsing ,reset it to zero */
        is_value_inverted = 0;
		#if DAG_CAT_RULE_PRINT
		fprintf( out, "Hash ,%u - %u  line_no: %d\n",yy_filter_rule.hash_from, yy_filter_rule.hash_to, dagcat_parselineno );
		#endif 
		BEGIN(S_dagcat_rule);
	}
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 286 "dagcat_rule_file_parser.l"
{
			fprintf( out,"ERROR: wrong format starting with %s on line: %d after hash  '[]' expected! \n",dagcat_parsetext, dagcat_parselineno);
			return T_ERROR;
	}	
	YY_BREAK
case 12:
/* rule 12 can match eol */
YY_RULE_SETUP
#line 290 "dagcat_rule_file_parser.l"
{
			fprintf(out,"ERROR: unexpected end of line on line: %d ! \n", dagcat_parselineno-1);
			return T_ERROR;
	}		
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 295 "dagcat_rule_file_parser.l"
{
            yy_filter_rule.iface_from   = atoi(&dagcat_parsetext[5]);
            yy_filter_rule.iface_to     = yy_filter_rule.iface_from;
            /* if it was an inverted value */
            yy_filter_rule.is_iface_inverted = is_value_inverted;
            /* for next parsing ,reset it to zero */
            is_value_inverted = 0;
            #if DAG_CAT_RULE_PRINT
                fprintf( out, "Iface ,%u - %u  line_no: %d\n",yy_filter_rule.iface_from, yy_filter_rule.iface_to, dagcat_parselineno );
            #endif 
		}
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 306 "dagcat_rule_file_parser.l"
{ 	
			BEGIN(S_iface_range); 
			#if DAG_CATLEX_DEBUG_R
			ECHO; //example for debugging 
			fprintf( out, "->RECOGNIZED line_no: %d\n",dagcat_parselineno );
			#endif 	  
		}
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 314 "dagcat_rule_file_parser.l"
{ 
		#if DAG_CATLEX_DEBUG_R
		//example for debugging the expressions after the main key word is recognised
		ECHO;
		fprintf( out, "->RECOGNIZED line_no: %d\n",dagcat_parselineno ); 
		#endif 
		
		if (-1 == resolve_range_values( dagcat_parsetext, 
			&yy_filter_rule.iface_from, 
			&yy_filter_rule.iface_to) )
		{	
			fprintf(out, "ERROR: Bad iface parameter line_no: %d\n",dagcat_parselineno );
			return T_ERROR;
		};
        /* if it was an inverted value */
        yy_filter_rule.is_iface_inverted = is_value_inverted;
        /* for next parsing ,reset it to zero */
        is_value_inverted = 0;
		#if DAG_CAT_RULE_PRINT
		fprintf( out, "Iface ,%u - %u  line_no: %d\n",yy_filter_rule.iface_from, yy_filter_rule.iface_to, dagcat_parselineno );
		#endif 
		BEGIN(S_dagcat_rule);
	}
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 338 "dagcat_rule_file_parser.l"
{
			fprintf( out,"ERROR: wrong format starting with %s on line: %d after iface  '[]' expected! \n",dagcat_parsetext, dagcat_parselineno);
			return T_ERROR;
	}	
	YY_BREAK
case 17:
/* rule 17 can match eol */
YY_RULE_SETUP
#line 342 "dagcat_rule_file_parser.l"
{
			fprintf(out,"ERROR: unexpected end of line on line: %d ! \n", dagcat_parselineno-1);
			return T_ERROR;
	}
	YY_BREAK
case 18:
YY_RULE_SETUP
#line 347 "dagcat_rule_file_parser.l"
{
          if ( is_value_inverted )
          {
            fprintf(out, "ERROR: Can not use 'not' with stream: line_no: %d\n",dagcat_parselineno );
			return T_ERROR;
          }
          if (-1 == resolve_stream_list( &dagcat_parsetext[6], 
			&yy_filter_rule.stream_value) )
		{	
			fprintf(out, "ERROR: Bad stream  parameter line_no: %d\n",dagcat_parselineno );
			return T_ERROR;
		};
        is_value_inverted = 0;
        //yy_filter_rule.stream_value   = atoi(&dagcat_parsetext[6]);
		}
	YY_BREAK
/* Implementation for adding comments in the rules 
	 *  single line commnet // to the end of the line 
	 * multiline comment from / * to the * / at any place multiple lines 
	 * and the status is at the point of begining of comment
	 */
case 19:
YY_RULE_SETUP
#line 368 "dagcat_rule_file_parser.l"
{	 
        is_value_inverted = 1;
        BEGIN(S_dagcat_rule);
}
	YY_BREAK
case 20:
/* rule 20 can match eol */
YY_RULE_SETUP
#line 372 "dagcat_rule_file_parser.l"
{	
	#if DAG_CATLEX_DEBUG_COMMENT
			fprintf( out, "Single line Comment lineno:%d ", dagcat_parselineno-1); 
			ECHO;
			fprintf( out,"\n");
	#endif
		}	
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 379 "dagcat_rule_file_parser.l"
{
			yy_push_state(S_comment);
	#if DAG_CATLEX_DEBUG_COMMENT
			fprintf( out, "SATRT Multi line Commentlineno:%d\n", dagcat_parselineno); 
	#endif 
		}
	YY_BREAK
/* warning there is a rule which may overight this one <*>.  */				
case 22:
YY_RULE_SETUP
#line 386 "dagcat_rule_file_parser.l"
; 
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 387 "dagcat_rule_file_parser.l"
{
			yy_pop_state();
	#if DAG_CATLEX_DEBUG_COMMENT
			fprintf( out, "FINISH Multi line Commentlineno:%d\n", dagcat_parselineno); 
	#endif
  
		}
	YY_BREAK
case 24:
/* rule 24 can match eol */
YY_RULE_SETUP
#line 394 "dagcat_rule_file_parser.l"
; 
	YY_BREAK
case 25:
/* rule 25 can match eol */
YY_RULE_SETUP
#line 395 "dagcat_rule_file_parser.l"
; 
	YY_BREAK
/* Common things like:
	* A. concatenate multiple lines for one rule \ \n 
	* B. unrecognized charecters any 
	* C. new line and new rule \n,
	*/
case 26:
/* rule 26 can match eol */
YY_RULE_SETUP
#line 403 "dagcat_rule_file_parser.l"
{
			#if DAG_CATLEX_DEBUG_COMMENT
			fprintf( out, "RULE continue to a new lineno:%d\n", dagcat_parselineno ); 
			#endif 
			}
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 408 "dagcat_rule_file_parser.l"
{
			fprintf( out, "\nUnrecognized character: %s lineno:%d\n", dagcat_parsetext, dagcat_parselineno ); 
			return T_ERROR;
	}
	YY_BREAK
case 28:
/* rule 28 can match eol */
YY_RULE_SETUP
#line 413 "dagcat_rule_file_parser.l"
{
	#if DAG_CATLEX_DEBUG_COMMENT
		fprintf( out,"Empty line just skip:%d\n",dagcat_parselineno-1);
	#endif 
	}
	YY_BREAK
case 29:
/* rule 29 can match eol */
YY_RULE_SETUP
#line 419 "dagcat_rule_file_parser.l"
{

		BEGIN(INITIAL);
		/* 
		 * This can be used to change the default behavior 
		 * if you disable the return will retutn at the end of the file or error 
		 * usfull for debugging to be set to 0 or in case we change the sacnner to return set instead of a single rule
		 */
		#if 1
        is_value_inverted = 0;
		 return T_RULE_DONE;
		#endif 
	}
	YY_BREAK
case YY_STATE_EOF(S_dagcat_rule):
#line 433 "dagcat_rule_file_parser.l"
{

		BEGIN(INITIAL);

		/* 
         *   Adding the end of file rules so that it accepts the last rule in a file if there 
         *   is no  new line 
		 */
		return T_RULE_DONE;
	}
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 444 "dagcat_rule_file_parser.l"
ECHO;
	YY_BREAK
#line 1487 "dagcat_rule_file_parser.c"
			case YY_STATE_EOF(INITIAL):
			case YY_STATE_EOF(S_color_range):
			case YY_STATE_EOF(S_hash_range):
			case YY_STATE_EOF(S_iface_range):
			case YY_STATE_EOF(S_comment):
				yyterminate();

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - (yytext_ptr)) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = (yy_hold_char);
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed dagcat_parsein at a new source and called
			 * dagcat_parselex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = dagcat_parsein;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (yy_c_buf_p) <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			(yy_c_buf_p) = (yytext_ptr) + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = (yytext_ptr) + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++(yy_c_buf_p);
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = (yy_c_buf_p);
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(yy_did_buffer_switch_on_eof) = 0;

				if ( dagcat_parsewrap( ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * dagcat_parsetext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					(yy_c_buf_p) = (yytext_ptr) + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(yy_c_buf_p) =
					(yytext_ptr) + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				(yy_c_buf_p) =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)];

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
} /* end of dagcat_parselex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (void)
{
    	register char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	register char *source = (yytext_ptr);
	register int number_to_move, i;
	int ret_val;

	if ( (yy_c_buf_p) > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (yy_c_buf_p) - (yytext_ptr) - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) ((yy_c_buf_p) - (yytext_ptr)) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars) = 0;

	else
		{
			int num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			YY_FATAL_ERROR(
"input buffer overflow, can't enlarge buffer because scanner uses REJECT" );

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			(yy_n_chars), (size_t) num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	if ( (yy_n_chars) == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			dagcat_parserestart(dagcat_parsein  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if ((yy_size_t) ((yy_n_chars) + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		yy_size_t new_size = (yy_n_chars) + number_to_move + ((yy_n_chars) >> 1);
		YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *) dagcat_parserealloc((void *) YY_CURRENT_BUFFER_LVALUE->yy_ch_buf,new_size  );
		if ( ! YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in yy_get_next_buffer()" );
	}

	(yy_n_chars) += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] = YY_END_OF_BUFFER_CHAR;

	(yytext_ptr) = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (void)
{
	register yy_state_type yy_current_state;
	register char *yy_cp;
    
	yy_current_state = (yy_start);
	yy_current_state += YY_AT_BOL();

	(yy_state_ptr) = (yy_state_buf);
	*(yy_state_ptr)++ = yy_current_state;

	for ( yy_cp = (yytext_ptr) + YY_MORE_ADJ; yy_cp < (yy_c_buf_p); ++yy_cp )
		{
		register YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 143 )
				yy_c = yy_meta[(unsigned int) yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
		*(yy_state_ptr)++ = yy_current_state;
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state )
{
	register int yy_is_jam;
    
	register YY_CHAR yy_c = 1;
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 143 )
			yy_c = yy_meta[(unsigned int) yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
	yy_is_jam = (yy_current_state == 142);
	if ( ! yy_is_jam )
		*(yy_state_ptr)++ = yy_current_state;

	return yy_is_jam ? 0 : yy_current_state;
}

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (void)
#else
    static int input  (void)
#endif

{
	int c;
    
	*(yy_c_buf_p) = (yy_hold_char);

	if ( *(yy_c_buf_p) == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( (yy_c_buf_p) < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			/* This was really a NUL. */
			*(yy_c_buf_p) = '\0';

		else
			{ /* need more input */
			int offset = (yy_c_buf_p) - (yytext_ptr);
			++(yy_c_buf_p);

			switch ( yy_get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					dagcat_parserestart(dagcat_parsein );

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( dagcat_parsewrap( ) )
						return EOF;

					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(yy_c_buf_p) = (yytext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (yy_c_buf_p);	/* cast for 8-bit char's */
	*(yy_c_buf_p) = '\0';	/* preserve dagcat_parsetext */
	(yy_hold_char) = *++(yy_c_buf_p);

	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = (c == '\n');
	if ( YY_CURRENT_BUFFER_LVALUE->yy_at_bol )
		   
    dagcat_parselineno++;
;

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * 
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void dagcat_parserestart  (FILE * input_file )
{
    
	if ( ! YY_CURRENT_BUFFER ){
        dagcat_parseensure_buffer_stack ();
		YY_CURRENT_BUFFER_LVALUE =
            dagcat_parse_create_buffer(dagcat_parsein,YY_BUF_SIZE );
	}

	dagcat_parse_init_buffer(YY_CURRENT_BUFFER,input_file );
	dagcat_parse_load_buffer_state( );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * 
 */
    void dagcat_parse_switch_to_buffer  (YY_BUFFER_STATE  new_buffer )
{
    
	/* TODO. We should be able to replace this entire function body
	 * with
	 *		dagcat_parsepop_buffer_state();
	 *		dagcat_parsepush_buffer_state(new_buffer);
     */
	dagcat_parseensure_buffer_stack ();
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	dagcat_parse_load_buffer_state( );

	/* We don't actually know whether we did this switch during
	 * EOF (dagcat_parsewrap()) processing, but the only time this flag
	 * is looked at is after dagcat_parsewrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(yy_did_buffer_switch_on_eof) = 1;
}

static void dagcat_parse_load_buffer_state  (void)
{
    	(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	(yytext_ptr) = (yy_c_buf_p) = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	dagcat_parsein = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	(yy_hold_char) = *(yy_c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * 
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE dagcat_parse_create_buffer  (FILE * file, int  size )
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) dagcat_parsealloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in dagcat_parse_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) dagcat_parsealloc(b->yy_buf_size + 2  );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in dagcat_parse_create_buffer()" );

	b->yy_is_our_buffer = 1;

	dagcat_parse_init_buffer(b,file );

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with dagcat_parse_create_buffer()
 * 
 */
    void dagcat_parse_delete_buffer (YY_BUFFER_STATE  b )
{
    
	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		dagcat_parsefree((void *) b->yy_ch_buf  );

	dagcat_parsefree((void *) b  );
}

#ifndef __cplusplus
extern int isatty (int );
#endif /* __cplusplus */
    
/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a dagcat_parserestart() or at EOF.
 */
    static void dagcat_parse_init_buffer  (YY_BUFFER_STATE  b, FILE * file )

{
	int oerrno = errno;
    
	dagcat_parse_flush_buffer(b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then dagcat_parse_init_buffer was _probably_
     * called from dagcat_parserestart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * 
 */
    void dagcat_parse_flush_buffer (YY_BUFFER_STATE  b )
{
    	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		dagcat_parse_load_buffer_state( );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  
 */
void dagcat_parsepush_buffer_state (YY_BUFFER_STATE new_buffer )
{
    	if (new_buffer == NULL)
		return;

	dagcat_parseensure_buffer_stack();

	/* This block is copied from dagcat_parse_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		(yy_buffer_stack_top)++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from dagcat_parse_switch_to_buffer. */
	dagcat_parse_load_buffer_state( );
	(yy_did_buffer_switch_on_eof) = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  
 */
void dagcat_parsepop_buffer_state (void)
{
    	if (!YY_CURRENT_BUFFER)
		return;

	dagcat_parse_delete_buffer(YY_CURRENT_BUFFER );
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if ((yy_buffer_stack_top) > 0)
		--(yy_buffer_stack_top);

	if (YY_CURRENT_BUFFER) {
		dagcat_parse_load_buffer_state( );
		(yy_did_buffer_switch_on_eof) = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void dagcat_parseensure_buffer_stack (void)
{
	int num_to_alloc;
    
	if (!(yy_buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
		num_to_alloc = 1;
		(yy_buffer_stack) = (struct yy_buffer_state**)dagcat_parsealloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in dagcat_parseensure_buffer_stack()" );
								  
		memset((yy_buffer_stack), 0, num_to_alloc * sizeof(struct yy_buffer_state*));
				
		(yy_buffer_stack_max) = num_to_alloc;
		(yy_buffer_stack_top) = 0;
		return;
	}

	if ((yy_buffer_stack_top) >= ((yy_buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		int grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (yy_buffer_stack_max) + grow_size;
		(yy_buffer_stack) = (struct yy_buffer_state**)dagcat_parserealloc
								((yy_buffer_stack),
								num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in dagcat_parseensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset((yy_buffer_stack) + (yy_buffer_stack_max), 0, grow_size * sizeof(struct yy_buffer_state*));
		(yy_buffer_stack_max) = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * 
 * @return the newly allocated buffer state object. 
 */
YY_BUFFER_STATE dagcat_parse_scan_buffer  (char * base, yy_size_t  size )
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) dagcat_parsealloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in dagcat_parse_scan_buffer()" );

	b->yy_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = 0;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	dagcat_parse_switch_to_buffer(b  );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to dagcat_parselex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 * 
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       dagcat_parse_scan_bytes() instead.
 */
YY_BUFFER_STATE dagcat_parse_scan_string (yyconst char * yystr )
{
    
	return dagcat_parse_scan_bytes(yystr,strlen(yystr) );
}

/** Setup the input buffer state to scan the given bytes. The next call to dagcat_parselex() will
 * scan from a @e copy of @a bytes.
 * @param bytes the byte buffer to scan
 * @param len the number of bytes in the buffer pointed to by @a bytes.
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE dagcat_parse_scan_bytes  (yyconst char * yybytes, int  _yybytes_len )
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = _yybytes_len + 2;
	buf = (char *) dagcat_parsealloc(n  );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in dagcat_parse_scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = dagcat_parse_scan_buffer(buf,n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in dagcat_parse_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}

    static void yy_push_state (int  new_state )
{
    	if ( (yy_start_stack_ptr) >= (yy_start_stack_depth) )
		{
		yy_size_t new_size;

		(yy_start_stack_depth) += YY_START_STACK_INCR;
		new_size = (yy_start_stack_depth) * sizeof( int );

		if ( ! (yy_start_stack) )
			(yy_start_stack) = (int *) dagcat_parsealloc(new_size  );

		else
			(yy_start_stack) = (int *) dagcat_parserealloc((void *) (yy_start_stack),new_size  );

		if ( ! (yy_start_stack) )
			YY_FATAL_ERROR( "out of memory expanding start-condition stack" );
		}

	(yy_start_stack)[(yy_start_stack_ptr)++] = YY_START;

	BEGIN(new_state);
}

    static void yy_pop_state  (void)
{
    	if ( --(yy_start_stack_ptr) < 0 )
		YY_FATAL_ERROR( "start-condition stack underflow" );

	BEGIN((yy_start_stack)[(yy_start_stack_ptr)]);
}

    static int yy_top_state  (void)
{
    	return (yy_start_stack)[(yy_start_stack_ptr) - 1];
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yy_fatal_error (yyconst char* msg )
{
    	(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up dagcat_parsetext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		dagcat_parsetext[dagcat_parseleng] = (yy_hold_char); \
		(yy_c_buf_p) = dagcat_parsetext + yyless_macro_arg; \
		(yy_hold_char) = *(yy_c_buf_p); \
		*(yy_c_buf_p) = '\0'; \
		dagcat_parseleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the current line number.
 * 
 */
int dagcat_parseget_lineno  (void)
{
        
    return dagcat_parselineno;
}

/** Get the input stream.
 * 
 */
FILE *dagcat_parseget_in  (void)
{
        return dagcat_parsein;
}

/** Get the output stream.
 * 
 */
FILE *dagcat_parseget_out  (void)
{
        return dagcat_parseout;
}

/** Get the length of the current token.
 * 
 */
int dagcat_parseget_leng  (void)
{
        return dagcat_parseleng;
}

/** Get the current token.
 * 
 */

char *dagcat_parseget_text  (void)
{
        return dagcat_parsetext;
}

/** Set the current line number.
 * @param line_number
 * 
 */
void dagcat_parseset_lineno (int  line_number )
{
    
    dagcat_parselineno = line_number;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param in_str A readable stream.
 * 
 * @see dagcat_parse_switch_to_buffer
 */
void dagcat_parseset_in (FILE *  in_str )
{
        dagcat_parsein = in_str ;
}

void dagcat_parseset_out (FILE *  out_str )
{
        dagcat_parseout = out_str ;
}

int dagcat_parseget_debug  (void)
{
        return dagcat_parse_flex_debug;
}

void dagcat_parseset_debug (int  bdebug )
{
        dagcat_parse_flex_debug = bdebug ;
}

static int yy_init_globals (void)
{
        /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from dagcat_parselex_destroy(), so don't allocate here.
     */

    /* We do not touch dagcat_parselineno unless the option is enabled. */
    dagcat_parselineno =  1;
    
    (yy_buffer_stack) = 0;
    (yy_buffer_stack_top) = 0;
    (yy_buffer_stack_max) = 0;
    (yy_c_buf_p) = (char *) 0;
    (yy_init) = 0;
    (yy_start) = 0;

    (yy_start_stack_ptr) = 0;
    (yy_start_stack_depth) = 0;
    (yy_start_stack) =  NULL;

    (yy_state_buf) = 0;
    (yy_state_ptr) = 0;
    (yy_full_match) = 0;
    (yy_lp) = 0;

/* Defined in main.c */
#ifdef YY_STDINIT
    dagcat_parsein = stdin;
    dagcat_parseout = stdout;
#else
    dagcat_parsein = (FILE *) 0;
    dagcat_parseout = (FILE *) 0;
#endif

    /* For future reference: Set errno on error, since we are called by
     * dagcat_parselex_init()
     */
    return 0;
}

/* dagcat_parselex_destroy is for both reentrant and non-reentrant scanners. */
int dagcat_parselex_destroy  (void)
{
    
    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		dagcat_parse_delete_buffer(YY_CURRENT_BUFFER  );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		dagcat_parsepop_buffer_state();
	}

	/* Destroy the stack itself. */
	dagcat_parsefree((yy_buffer_stack) );
	(yy_buffer_stack) = NULL;

    /* Destroy the start condition stack. */
        dagcat_parsefree((yy_start_stack)  );
        (yy_start_stack) = NULL;

    dagcat_parsefree ( (yy_state_buf) );
    (yy_state_buf)  = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * dagcat_parselex() is called, initialization will occur. */
    yy_init_globals( );

    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, yyconst char * s2, int n )
{
	register int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * s )
{
	register int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *dagcat_parsealloc (yy_size_t  size )
{
	return (void *) malloc( size );
}

void *dagcat_parserealloc  (void * ptr, yy_size_t  size )
{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
}

void dagcat_parsefree (void * ptr )
{
	free( (char *) ptr );	/* see dagcat_parserealloc() for (char *) cast */
}

#define YYTABLES_NAME "yytables"

#line 444 "dagcat_rule_file_parser.l"


			
int dagcat_scanner_set_stdout(FILE *scanner_out) {
		out = scanner_out;
		return 0;
}
int scanner_set_topstate(void) {
	return yy_top_state();
}
int dagcat_get_current_line_number()
{
    return dagcat_parselineno;
}
		


