/*
 * Copyright (c) 2002-2007 Endace Technology Ltd, Hamilton, New Zealand.
 * All rights reserved.
 *
 * This source code is proprietary to Endace Technology Limited and no part
 * of it may be redistributed, published or disclosed except as outlined in
 * the written contract supplied with this product.
 *
 * $Id: dagbits_plugin.h 15597 2012-03-28 22:21:32Z jomi.gregory $
 */

#ifndef DAGBITS_PLUGIN_H
#define DAGBITS_PLUGIN_H

#define TEST_HELP     (1)
#define TEST_PASS     (0)
#define TEST_FAIL     (-1)
#define TEST_WARNING  (-2)
#define TEST_IGNORE   (-3)

#define MAX_STR_LEN (512)
#define MAX_IFC_CNT (16)

typedef struct global_params
{
	int verbose;
	int cap_stream;
	int ifc_cnt;
	char dagname[DAGNAME_BUFSIZE];
} global_params_t;

typedef struct struct_protocol
{
#ifdef _WIN32
	int dummy;		// NOTE: A dummy variable to prevent compile errors on Windows. To be removed when proper structure members are added.
#endif
} struct_protocol_t;

typedef int (*test_printf)(char *format, ...);
typedef int (*test_init)(char *params[], int param_cnt, global_params_t *global_params, test_printf f);
typedef int (*test_run)(char *rec, int len, char* lastpkt, struct_protocol_t prot, uint64_t rec_cnt);
typedef int (*test_err_msg)(char *buf, int size);
typedef int (*test_final_msg)(char *buf, int size);
typedef int (*test_cleanup)();

#endif
