#!/bin/sh
# Read command-line arguments.
if [ $# -ne "3" ]; then
        echo "ERROR (script_CAT_setup.sh): not enough args."
        echo "ABOUT: Configures the card in dup3, z4, z8, dup2, z3, z2, z3monitor"
            echo "usage: script_CAT_setup.sh dag(-d0/-d1) mode link(pos4chdlc/ethernet/pos4ppp)"
                exit 1
            fi

DAG=$1
LINK=$3
MODE=$2
if [ "$LINK" != "pos4chdlc" -a "$LINK" != "ethernet" -a "$LINK" != "pos4ppp" ]; then
        echo "Error link shud be pos4chdlc/ethernet/pos4ppp"
        echo "usage: script_CAT_setup.sh dag(-d0/ -d1) mode  link(pos4chdlc/ethernet/pos4ppp)"
        exit 1
   fi

dagconfig $DAG  default
#create teh tmp all pass rule file
echo "0 accept red all src-ip {--------------------------------} src-port {----------------} dst-ip {--------------------------------} dst-port {----------------}" >tmp_capture_all.rule

# enable ipf and load pass all rules
filter_loader $DAG  -v --initialize --drop --init-ports 1 --init-rulesets 2 --iface 0 -l $LINK -m colour -i tmp_capture_all.rule
#configure HLB - initialize the banks and enable HLB encoding in the color
dagconfig $DAG -S hat_range=0-90:90-160:160-200:200-250:250-310:310-370:370-430:430-500:500-560:560-620:620-680:680-750:750-810:810-870:870-940:940-1000
dagconfig $DAG  -S hash_encoding_from_ipf=on
dagconfig $DAG  -S n_tuple_select=2

#configure in   mode  
dagcat-setup $DAG -v -m $MODE

#take out fo CAT by-pass mode
dagconfig $DAG -S by_pass=off

#remove the tmp file created
rm -f tmp_capture_all.rule
