#!/bin/bash
## Endace support usage only
## written by: Global Support Engineer @ 22nd July 2008
## $Id: dag-stats.sh 15687 2012-05-17 01:52:58Z sfd $

DATE_STR=$(date '+%Y-%m-%d %H:%M:%S')
DATE_STR_FILE=$(echo ${DATE_STR} | sed 's/-//g' | sed 's/://g' | sed 's/ /-/g')
LOG=DAGdump-${DATE_STR_FILE}.log

echo " "
echo This script is NOT intended for Windows, it will collect
echo information about the system '('like the kernel name, release,
echo packages installed, log messages, running processes '('dag related')',
echo and machine hardware name - 32 or 64 bit platform')'
echo
echo The output of dag-stats.sh is saved in a file called $LOG
echo Endace recommends you have a look at log file and remove
echo any confidential information, before sending it to us.
echo
echo Running, please wait...
echo

if ( command -v perl >/dev/null 2>&1 ) ; then
    daginf -V | perl -ne '/.*\((.*)\).*/; print "Software version: ", $1, "\n\n"' >> $LOG
fi

NUMBER=$(lspci | grep "Endace" -c)
echo "Number of Endace cards in the server:" $NUMBER >> $LOG
echo >> $LOG

DAG=0
DAG=$(lsmod | grep dag -c)
i=0

##check whether the DAG drivers are loaded properly

if [ $i = $DAG ]
then
    echo "DAG drivers not loaded." >> $LOG
    echo >> $LOG

    echo "DAG drivers not loaded. Please check the DAG software Installation Guide"
    echo "for details on how to load the drivers."
    echo "For any further assistance please email support@endace.com"
    echo
else
    echo "DAG drivers are loaded correctly." >> $LOG
    echo >> $LOG

    echo "DAG drivers are loaded correctly."
    echo --------

    NUMBER=$(dagdetect -c)
    echo "Number of DAG cards found by driver:" $NUMBER >> $LOG
    echo " " >> $LOG

    echo "=========DAG card info========"  >> $LOG
    
    daginf | grep "model"  >> $LOG
    echo "-------"  >> $LOG
    
    dagdetect -v >> $LOG 2>&1
    echo "-------"  >> $LOG
    
    until [ $i -ge $NUMBER ]
    do
	echo Processing dag$i ...

	echo >> $LOG
	echo "Card dag$i" >> $LOG
	echo "---------" >> $LOG
	daginf -d$i -vv  >> $LOG 2>&1
	echo "-------"  >> $LOG
        echo "dagconfig -d"$i  >> $LOG
	dagconfig -d$i  >> $LOG 2>&1
        echo "-------"  >> $LOG
        echo "dagconfig -d"$i" -s"  >> $LOG
	dagconfig -d$i -s  >> $LOG 2>&1
        dagconfig -d$i -s  >> $LOG 2>&1
        echo "-------"  >> $LOG
        echo "dagconfig -d"$i" -u"  >> $LOG
        dagconfig -d$i -u  >> $LOG 2>&1
	sleep 1
        dagconfig -d$i -u  >> $LOG 2>&1
        echo "-------"  >> $LOG
        echo "dagconfig -d"$i" -C" >> $LOG
        dagconfig -d$i -C  >> $LOG 2>&1
	sleep 1
        dagconfig -d$i -C  >> $LOG 2>&1
        echo "-------"  >> $LOG
        echo "dagconfig -d"$i" -e"  >> $LOG
        dagconfig -d$i -e  >> $LOG 2>&1
	sleep 1
        dagconfig -d$i -e  >> $LOG 2>&1
        echo "-------"  >> $LOG
        echo "dagrom -d"$i" -x"  >> $LOG
	dagrom -d$i -x  >> $LOG 2>&1
        echo "-------"  >> $LOG 2>&1
        echo "dagclock -d"$i >> $LOG
	dagclock -d$i  >> $LOG 2>&1
        echo "-------"  >> $LOG
        echo "dag_irigb -v -d"$i >> $LOG
	dag_irigb -v -d$i  >> $LOG 2>&1
        echo "-------"  >> $LOG
	if ( command -v tcpdump >/dev/null 2>&1 ) ; then
            echo "tcpdump -i dag${i} -L" >> $LOG
	    tcpdump -i dag$i -L >> $LOG 2>&1
            echo "-------"  >> $LOG
	fi
        echo "dagconfig -d"$i" -T"  >> $LOG
        dagconfig -d$i -T  >> $LOG 2>&1
	echo "-------"  >> $LOG
	sleep 2;

	let "i += 1"
    done
    
    echo >> $LOG
    echo "=========Tcpdump info========"  >> $LOG
    if ( command -v tcpdump >/dev/null 2>&1 ) ; then
	tcpdump -V >> $LOG 2>&1
	echo "-------"  >> $LOG
	tcpdump -D >> $LOG 2>&1
	echo >> $LOG
    fi
    
fi

# collect some system related information into LOG file

echo "=======System Info========="  >> $LOG 2>&1
echo Date/Time ${DATE_STR} >> $LOG
echo "-------"  >> $LOG
if ( command -v hostname >/dev/null 2>&1 ) ; then
    echo "hostname -f" >> $LOG
    hostname -f  >> $LOG 2>&1
    echo "-------"  >> $LOG
fi
if ( command -v lsb_release >/dev/null 2>&1 ) ; then
    echo "lsb_release -a" >> $LOG
    lsb_release -a  >> $LOG 2>&1
    echo "-------"  >> $LOG
fi
echo "uname -a" >> $LOG
uname -a  >> $LOG 2>&1
echo "-------"  >> $LOG
echo "df -Pka" >> $LOG
df -Pka  >> $LOG 2>&1
echo "-------"  >> $LOG
echo "uptime" >> $LOG
uptime >> $LOG 2>&1
echo "-------"  >> $LOG
echo "free -m" >> $LOG
free -m  >> $LOG 2>&1
echo "-------"  >> $LOG
if ( command -v lspci >/dev/null 2>&1 ) ; then
    echo "lspci -vt" >> $LOG
    lspci -vt  >> $LOG 2>&1
    echo "-------"  >> $LOG
    echo "lspci -deace: -vvv" >> $LOG
    lspci -deace: -vvv  >> $LOG 2>&1
    echo "-------"  >> $LOG
fi
echo "cat /proc/interrupts" >> $LOG
cat /proc/interrupts >> $LOG 2>&1
echo "-------"  >> $LOG
if ( command -v rpm >/dev/null 2>&1 ) ; then
    echo "rpm -qa" >> $LOG
    rpm -qa  >> $LOG 2>&1
    echo "-------"  >> $LOG
fi
echo "tail -200 /var/log/messages" >> $LOG
tail -200 /var/log/messages  >> $LOG 2>&1
echo "-------"  >> $LOG
echo "ps aux" >> $LOG
ps aux  >> $LOG 2>&1
echo "-------"  >> $LOG

echo Done

#exit 0
