/*
 * Copyright (c) 2005 Endace Technology Ltd, Hamilton, New Zealand.
 * All rights reserved.
 *
 * This source code is proprietary to Endace Technology Limited and no part
 * of it may be redistributed, published or disclosed except as outlined in
 * the written contract supplied with this product.
 *
 */


#ifndef DAG4_CONSTANTS_H
#define DAG4_CONSTANTS_H

/**
 * 4.3GE
 */
typedef enum pmc3386 {
	P3386_RESET_CTRL	= 0x002,

	P3386_EGMAC_GMACC1_L_A  = 0x302,
	P3386_EGMAC_GMACC1_H_A	= 0x303,
	P3386_EGMAC_GPCSC_L_A	= 0x306,
    P3386_EGMAC_STATION_ADDR_A = 0x308,
	P3386_EGMAC_RX_MAXFR_A	= 0x310,
	P3386_EGMAC_ANCTL_A	= 0x318,
	P3386_EGMAC_ANSTT_A	= 0x31A,

	P3386_EGMAC_TX_MAXFR_A	= 0x336,
	P3386_EGMAC_RX_FIFO_A	= 0x337,
    
    P3386_EGMAC_ADDR_FILTER_CTRL2_A = 0x35F,

	P3386_EGMAC_GMACC1_L_B  = 0x402,
	P3386_EGMAC_GMACC1_H_B	= 0x403,
	P3386_EGMAC_GPCSC_L_B	= 0x406,
    P3386_EGMAC_STATION_ADDR_B = 0x408,
	P3386_EGMAC_RX_MAXFR_B	= 0x410,
	P3386_EGMAC_ANCTL_B	= 0x418,
	P3386_EGMAC_ANSTT_B	= 0x41A,
	
	P3386_EGMAC_TX_MAXFR_B	= 0x436,
	P3386_EGMAC_RX_FIFO_B	= 0x437,

    P3386_EGMAC_ADDR_FILTER_CTRL2_B = 0x45F,

	P3386_MSTAT_CTRL_A	= 0x500,
	P3386_MSTAT_FRAMES_OK_A	= 0x510,
	P3386_MSTAT_OCTETS_OK_A	= 0x514,
	P3386_MSTAT_FCS_ERR_A	= 0x538,
	P3386_MSTAT_SYMB_ERR_A	= 0x540,
	
	P3386_MSTAT_TX_FRAMES_OK_A = 0x590,
	P3386_MSTAT_TX_OCTETS_OK_A = 0x594,
	P3386_MSTAT_TX_INTERR_A    = 0x59c,
	P3386_MSTAT_TX_SYSERR_A    = 0x5a0,
	
	P3386_MSTAT_CTRL_B	= 0x600,
	P3386_MSTAT_FRAMES_OK_B	= 0x610,
	P3386_MSTAT_OCTETS_OK_B	= 0x614,
	P3386_MSTAT_FCS_ERR_B	= 0x638,
	P3386_MSTAT_SYMB_ERR_B	= 0x640,

	P3386_MSTAT_TX_FRAMES_OK_B = 0x690,
	P3386_MSTAT_TX_OCTETS_OK_B = 0x694,
	P3386_MSTAT_TX_INTERR_B    = 0x69c,
	P3386_MSTAT_TX_SYSERR_B    = 0x6a0,
	
	P3386_SERDES_PORT_CONF_A	= 0x703,

	P3386_SERDES_PORT_CONF_B	= 0x713
} pmc3386_t;

/**
 *  4.3S 
 */
typedef enum pmc5381 {
    P5381_SU2488_IDENTITY_GPMU    = 0x000,
    P5381_SU2488_MASTER_RESET     = 0x001,
    P5381_SU2488_DIAGNOSTICS      = 0x00E,
    P5381_RX2488_ANALOG_INT_STAT  = 0x010,
    P5381_RX2488_ANALOG_CTRL      = 0x012,
    P5381_RX2488_ANALOG_CLK       = 0x013,
    P5381_TX2488_ANALOG_CTRL      = 0x020,
    P5381_TX2488_ABC_CTRL         = 0x021,
    P5381_STLI_CLK_CONFIG         = 0x038,
    P5381_RRMP_STATUS             = 0x041,
    P5381_RRMP_AIS_ENB            = 0x046,
    P5381_RRMP_AUX2_AIS_ENB       = 0x056,
    P5381_RRMP_AUX3_AIS_ENB       = 0x066,
    P5381_RRMP_AUX4_AIS_ENB       = 0x076,
    P5381_TRMP_CONFIG             = 0x080,
    P5381_TRMP_AUX2_CONFIG        = 0x0A0,
    P5381_TRMP_AUX3_CONFIG        = 0x0C0,
    P5381_TRMP_AUX4_CONFIG        = 0x0E0,
    P5381_RHPP_IND_ADDR           = 0x200,
    P5381_RHPP_IND_DATA           = 0x201,
    P5381_RHPP_PTR_INT_STA_2      = 0x210,
    P5381_SARC_PATH_REG_ENB       = 0x720,
    P5381_SARC_PATH_CONFIG        = 0x728,
    P5381_SARC_PATH_RPAISINS_ENB  = 0x72A,
    P5381_SARC_LOP_PTR_STAT       = 0x730,
    P5381_RCFP_CONFIG             = 0x740,
    P5381_RCFP_INT_ENB_STAT       = 0x741,
    P5381_RCFP_MIN_PKT_LEN        = 0x743,
    P5381_RCFP_MAX_PKT_LEN        = 0x744,
    P5381_RCFP_RXBYTE_IDLE_L      = 0x747,
    P5381_RCFP_RXPKT_CELL_CNT_L   = 0x74A,
    P5381_RCFP_RXFCS_HEC_CNT      = 0x74C,
    P5381_RCFP_RXPOS_ABORT_CNT    = 0x74D,
    P5381_RCFP_RXPOS_SHORT_CNT    = 0x74E,
    P5381_RCFP_RXPOS_LONG_CNT     = 0x74F,
    P5381_TCFP_CONFIG             = 0x750,
    P5381_TCFP_TXPKT_CELL_CNT_L   = 0x754,
    P5381_TCFP_TXBYTE_L           = 0x756,
    P5381_TCFP_TXPOS_ABORT_CNT    = 0x759,
    P5381_RXSDQ_RESET             = 0x760,
    P5381_RXSDQ_IND_ADDR          = 0x768,
    P5381_RXSDQ_IND_CONFIG        = 0x769,
    P5381_RXSDQ_IND_DATA_AV_THRSH = 0x76A,
    P5381_RXSDQ_DROP_CNT          = 0x76E,
    P5381_TXSDQ_RESET             = 0x770,
    P5381_TXSDQ_IND_ADDR          = 0x778,
    P5381_TXSDQ_IND_CONFIG        = 0x779,
    P5381_TXSDQ_DROP_CNT          = 0x77E,
    P5381_RXPHY_CONFIG            = 0x780,
    P5381_RXPHY_IND_BURST_SIZE    = 0x783,
    P5381_TXPHY_CONFIG            = 0x788,
    P5381_SIRP_CONFIG_TIMESLOT    = 0x790,
    P5381_SIRP_CONFIG             = 0x79c,
    P5381_R8TD_APS1_ANALOG_CTRL1  = 0x843,
    P5381_R8TD_APS2_ANALOG_CTRL1  = 0x84B,
    P5381_R8TD_APS3_ANALOG_CTRL1  = 0x853,
    P5381_R8TD_APS4_ANALOG_CTRL1  = 0x85B,
    P5381_T8TD_APS1_ANALOG_CTRL   = 0x865,
    P5381_T8TD_APS2_ANALOG_CTRL   = 0x86D,
    P5381_T8TD_APS3_ANALOG_CTRL   = 0x875,
    P5381_T8TD_APS4_ANALOG_CTRL   = 0x87D,
    P5381_CSTR_CTRL               = 0x888
} pmc5381_t;


#endif

