/*
 * Copyright (c) 2005 Endace Technology Ltd, Hamilton, New Zealand.
 * All rights reserved.
 *
 * This source code is proprietary to Endace Technology Limited and no part
 * of it may be redistributed, published or disclosed except as outlined
 * in the written contract supplied with this product.
 *
 * $Id: dagname.h 12374 2010-01-20 01:19:09Z jomi.gregory $
 */

#ifndef DAGNAME_H
#define DAGNAME_H

#ifndef _WIN32
# include	<inttypes.h>
#else
# include	<wintypedefs.h>
#endif /* _WIN32 */


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

typedef enum efb_id_list {
    EFB_ID_PADDING = 0x00,
    EFB_ID_VERSION = 0x01,
    EFB_ID_BLKSIZE = 0x02,
    EFB_ID_IMGSTRT = 0x03,
    EFB_ID_CRC     = 0x04,
    EFB_ID_AUTHOR  = 0x05,
    EFB_ID_RSVD06  = 0x06,
    EFB_ID_RSVD07  = 0x07,
    EFB_ID_REASON  = 0x08,
    EFB_ID_COMMENT = 0x09,
    EFB_ID_AREC    = 0x0a, // A-Record
    EFB_ID_FPGA    = 0x0b, // B-Record
    EFB_ID_DATE    = 0x0c, // C-Record
    EFB_ID_TIME    = 0x0d, // D-Record
    EFB_ID_IMAGE   = 0x0e, // E-Record, sorta
    EFB_ID_RSVD0F  = 0x0f,
    EFB_ID_PLAT    = 0x10,
    EFB_ID_PREFIX  = 0x11,
    EFB_ID_CONFIG  = 0x12,
    EFB_ID_FPGANUM = 0x13,
    EFB_ID_STAMP   = 0x14,
    EFB_ID_ENCRYPT = 0x15,
    EFB_ID_MAX     = 0x16 // placeholder for end of list
} efb_id_list_t;
char **dag_xrev_parse(uint8_t *xrev, uint32_t xlen, char *argv[5]);

/*
 * This routine will partially destroy the contents of xrev by
 * writing '\0' markers into the buffer and letting argv point
 * into the buffer.
 */
char *dag_xrev_name(uint8_t *xrev, uint32_t xlen);

#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* DAGNAME_H */
