/* ------------------------------------------------------------------------------
 adt_disposal from Koryn's Units.

 Type definition for a memory-disposing routine, used by hash tables when they
 need to dispose of an item.

 Copyright (c) 2000-2003, Koryn Grant.
 All rights reserved.

 Redistribution and use in source and binary forms, with or without modification,
 are permitted provided that the following conditions are met:

 *	Redistributions of source code must retain the above copyright notice,
	this list of conditions and the following disclaimer.
 *	Redistributions in binary form must reproduce the above copyright notice,
	this list of conditions and the following disclaimer in the documentation
	and/or other materials provided with the distribution.
 *	Neither the name of the author nor the names of other contributors
	may be used to endorse or promote products derived from this software without
	specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 POSSIBILITY OF SUCH DAMAGE.
------------------------------------------------------------------------------ */

#ifndef ADT_DISPOSAL_H
#define ADT_DISPOSAL_H

/* Koryn's Units. */
#include "adt_types.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


/* Prototype for a disposal function. */
typedef void (*DisposeRoutine)(AdtPtr data);


/* Standard disposer that calls adt_dispose_ptr() on the item. */
void adt_std_disposer(AdtPtr data);

/* Empty disposer for data structures that should be thrown away without freeing items (e.g. all items are references). */
void adt_null_disposer(AdtPtr data);


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* ADT_DISPOSAL_H */
