%{
/*
 * Copyright (c) 2004-2005 Endace Technology Ltd, Hamilton, New Zealand.
 * All rights reserved.
 *
 * This source code is proprietary to Endace Technology Limited and no part
 * of it may be redistributed, published or disclosed except as outlined in
 * the written contract supplied with this product.
 *
 * $Id: scanner.l 12693 2010-04-01 02:33:09Z wilson.zhu $
 */
#if defined (__linux__) || defined (__FreeBSD__) || (defined(__APPLE__) && defined(__ppc__))
/* POSIX headers. */
#include <unistd.h>
#endif

/* C Standard Library headers. */
#include <stdio.h>
#include <string.h>

/* Project headers. */
#include "parser.h"

#define TOKEN_BUFFER_BYTES 1024
static char uTokenBuffer[TOKEN_BUFFER_BYTES];
static int uSavedNumber;

//int yywrap(void);

%}

%option nounput
%option noinput

quote               ['"]
digit               [0-9]
number              {digit}+
letter              [a-zA-Z]
alphanum            [a-zA-Z0-9_]
word                {letter}{alphanum}*
identifier          {word}
whitespace          [ \t]+
comment             [#%]
newline             [\n\r]
hostname            {number}[.]{number}[.]{number}[.]{number}
netname2            {number}[.]{number}
netname3            {number}[.]{number}[.]{number}
netlen              {number}[.]{number}[.]{number}[.]{number}[/]{number}

%%
"&"                 return TOK_AMPERSAND;
"="                 return TOK_EQUALS;
"!="                return TOK_NOT_EQUALS;
"tcp[13]"           return TOK_TCP_FLAGS;
"icmp"              return TOK_ICMP;
"igrp"              return TOK_IGRP;
"ip"                return TOK_IP;
"tcp"               return TOK_TCP;
"udp"               return TOK_UDP;

"and"               return TOK_AND;
"or"                return TOK_OR;
"src"               return TOK_SRC;
"dst"               return TOK_DST;
"not"               return TOK_NOT;
"host"              return TOK_HOST;
"port"              return TOK_PORT;
"net"               return TOK_NET;

"["                 return TOK_LEFT_SQUARE;
"]"                 return TOK_RIGHT_SQUARE;
"("                 return TOK_LEFT_PAREN;
")"                 return TOK_RIGHT_PAREN;

{hostname}          strncpy(uTokenBuffer, yytext, TOKEN_BUFFER_BYTES); return TOK_HOSTNAME;
{netname2}          strncpy(uTokenBuffer, yytext, TOKEN_BUFFER_BYTES); return TOK_NETNAME2;
{netname3}          strncpy(uTokenBuffer, yytext, TOKEN_BUFFER_BYTES); return TOK_NETNAME3;
{netlen}            strncpy(uTokenBuffer, yytext, TOKEN_BUFFER_BYTES); return TOK_NETLEN;
{number}            uSavedNumber = atoi(yytext); return TOK_NUMBER;
{whitespace}        /* Skip whitespace. */;
{comment}.*{newline}        strncpy(uTokenBuffer, yytext, TOKEN_BUFFER_BYTES); return TOK_COMMENT;
{newline}           return 0;
.                   strncpy(uTokenBuffer, yytext, TOKEN_BUFFER_BYTES); return TOK_ERROR;
<<EOF>>             yyterminate();
%%


int
yywrap(void)
{
	return 1;
}


unsigned int
get_token_string_buflen(void)
{
    return strlen(uTokenBuffer);
}


void
get_token_string_contents(char* buffer, unsigned int buflen)
{
    buffer[0] = '\0';
	if (uTokenBuffer[0] != '\0')
	{
		strncpy(buffer, uTokenBuffer, buflen);
	}
}


const char*
get_token_string(void)
{
	if (uTokenBuffer[0] != '\0')
	{
        return strdup(uTokenBuffer);
	}

    return NULL;
}


int
get_token_number(void)
{
	return uSavedNumber;
}
