%{
/*
 * Copyright (c) 2004-2005 Endace Technology Ltd, Hamilton, New Zealand.
 * All rights reserved.
 *
 * This source code is proprietary to Endace Technology Limited and no part
 * of it may be redistributed, published or disclosed except as outlined in
 * the written contract supplied with this product.
 *
 * $Id: scanner.l 12691 2010-04-01 02:13:24Z wilson.zhu $
 */

#if defined (__linux__) || defined (__FreeBSD__) || (defined(__APPLE__) && defined(__ppc__))
/* POSIX headers. */
#include <unistd.h>
#endif

/* C Standard Library headers. */
#include <stdio.h>
#include <string.h>

/* Project headers. */
#include "parser.h"

#define TOKEN_BUFFER_BYTES 1024
static char uTokenBuffer[TOKEN_BUFFER_BYTES];
static long uSavedNumber;

//int yywrap(void);

%}

%option nounput
%option noinput

quote               ['"]
digit               [0-9]
number              {digit}+
letter              [a-zA-Z]
alphanum            [a-zA-Z0-9_]
word                {letter}{alphanum}*
identifier          {word}
whitespace          [ \t]+
newline             [\n\r]
hostname            {number}[.]{number}[.]{number}[.]{number}


%%
"accept"        return ACTION_ACCEPT;
"reject"        return ACTION_REJECT;

"icmp"          return PROTOCOL_ICMP;
"ip"            return PROTOCOL_IP;
"tcp"           return PROTOCOL_TCP;
"udp"           return PROTOCOL_UDP;

"any"           return TOKEN_ANY;
"var"           return TOKEN_VAR;

"->"            return UNIDIRECTIONAL;
"<>"            return BIDIRECTIONAL;

"."             return TOKEN_PERIOD;
","             return TOKEN_COMMA;
":"             return TOKEN_COLON;
"$"             return TOKEN_DOLLAR;
"/"             return TOKEN_FORWARD_SLASH;
"!"             return TOKEN_NEGATE;
"["             return TOKEN_LEFT_SQUARE;
"]"             return TOKEN_RIGHT_SQUARE;

{hostname}        strncpy(uTokenBuffer, yytext, TOKEN_BUFFER_BYTES); return TOKEN_HOSTNAME;
[(].*[)]          strncpy(uTokenBuffer, yytext, TOKEN_BUFFER_BYTES); return TOKEN_BODY;
{identifier}      strncpy(uTokenBuffer, yytext, TOKEN_BUFFER_BYTES); return TOKEN_VARIABLE;
{number}          uSavedNumber = atoi(yytext); return TOKEN_NUMBER;
{whitespace}      /* Skip whitespace */;
[#].*{newline}?   strncpy(uTokenBuffer, yytext, TOKEN_BUFFER_BYTES); return TOKEN_COMMENT;
{newline}         return 0;
.                 strncpy(uTokenBuffer, yytext, TOKEN_BUFFER_BYTES); return TOKEN_ERROR;
<<EOF>>           yyterminate();
%%


int
yywrap(void)
{
	return 1;
}


const char*
get_token_string(void)
{
	if (uTokenBuffer[0] != '\0')
	{
		return strdup(uTokenBuffer);
	}

	return NULL;
}

long
get_token_number(void)
{
	return uSavedNumber;
}
