/*
 * Copyright (c) 2004-2005 Endace Technology Ltd, Hamilton, New Zealand.
 * All rights reserved.
 *
 * This source code is proprietary to Endace Technology Limited and no part
 * of it may be redistributed, published or disclosed except as outlined in
 * the written contract supplied with this product.
 *
 * $Id: rule_lib.h 6856 2007-05-20 23:55:04Z andras $
 */

#ifndef RULE_LIB_H
#define RULE_LIB_H

/* Project headers. */
#include "filter_rule_types.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

typedef struct variable variable_t;

struct variable
{
	const char* name;
	uint8_t inverse;
	list_node_t* addr_list;
	ipf_port_t ports;
	variable_t* next;
};

variable_t* get_address_variable(const char* name);
void add_address_variable(const char* name, list_node_t* addresses);
variable_t* get_port_variable(const char* name);
void add_port_variable(const char* name, ipf_port_t* port_spec);


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* RULE_LIB_H */
