/*
 * Copyright (c) 2004-2007 Endace Technology Ltd, Hamilton, New Zealand.
 * All rights reserved.
 *
 * This source code is proprietary to Endace Technology Limited and no part
 * of it may be redistributed, published or disclosed except as outlined in
 * the written contract supplied with this product.
 *
 * $Id: dagpf_snort.h 6998 2007-06-18 04:22:11Z vladimir $
 */


#ifndef DAGPF_SNORT_H
#define DAGPF_SNORT_H

#include <stdio.h>

#define DAGPF_SNORT_REJECT_ALL  0x40 /**< reject all packets by default */


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/**
 * Convert Snort rules
 *
 * Read rules from 'infile' given in Snort-like format. Classify
 * rules and save to per-protocol files. Convert Snort rules into
 * Endace rules, expand address/port lists and write resulting rules
 * to 'outfile'.
 *
 * This function is non-reentrant.
 *
 * \param infile   file containing Snort rules 
 * \param outfile  file for resulting Endace rules 
 * \param flags    rule obfuscation and protocol rejection flags
 *
 * \return non-zero in case of errors, zero otherwise
 */
int dagpf_snort_to_endace(FILE* infile, FILE* outfile, uint32_t flags);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* DAGPF_SNORT_H */
