/*
 * Copyright (c) 2004-2005 Endace Technology Ltd, Hamilton, New Zealand.
 * All rights reserved.
 *
 * This source code is proprietary to Endace Technology Limited and no part
 * of it may be redistributed, published or disclosed except as outlined in
 * the written contract supplied with this product.
 *
 * $Id: filter_rule_types.h 11723 2009-08-06 05:35:20Z wilson.zhu $
 */
/** \defgroup PFAPI Packet Filtering API
 */
/*@{*/

/**
 * \brief High-level filter rule data type(Endace rules)
 *
 * Data types representing the high-level filter rules, as opposed to
 * CAM entries, which are essentially the low-level format of a filter
 * rule.
 *
 */

/** \defgroup PFHLF High-level filter rule data type
 */
/*@{*/

#ifndef FILTER_RULE_TYPES_H
#define FILTER_RULE_TYPES_H

/* Common headers. */
#include "dagpf.h" /* CAM entries */

/**
 * Linked-list of IP addresses
 */ 
typedef struct list_node list_node_t;
struct list_node {
	 ip_address_t* address;
	 list_node_t* next;
};

/**
 * Range of (layer 4) port numbers
 */
typedef struct ipf_port
{
	uint16_t first;   /**< network byte order */
	uint16_t last;    /**< network byte order */
	uint8_t any;      /**< boolean */
	uint8_t inverse;  /**< boolean */
} ipf_port_t;

/**
 * Data structure describing a filter rule.
 *
 * It is created as a result of reading in a single "rule". It still
 * contains IP address lists and port ranges that have not been broken
 * down sufficiently to be put into the CAM.
 */
typedef struct filter_rule
{
	uint16_t exact_colour; /**< colour of the packet */
	/* uint16_t potential_colour; Obsolete. */
	filter_action_t action; /**< reject or accept */
	protocol_t protocol; /**< transport (layer 4) protocol (TCP, UDP) */
	list_node_t* source; /**< source IP address range */
	uint8_t src_inverse; /**< indicates source address inversion */
	list_node_t* dest; /**< destination IP address range */
	uint8_t dest_inverse; /**< indicates address inversion */
	uint8_t bidirectional;
	ipf_port_t src_port; /**< source port range (layer4) */
	ipf_port_t dest_port; /**< destination port range (layer4) */
	tcp_flags_t tcp_flags; /**< TCP flags (SYN, ACK, FIN, etc.) */
} filter_rule_t;


#endif /* FILTER_RULE_TYPES_H */
/*@}*/
/*@}*/
