/* Endace headers. */
#include "dagapi.h"
#include "dag_platform.h"
void handle_packet(dag_record_t  *record, int len)
{
    printf("Handling records here Length %d\n",len);
}


int main ()
{

    int dagfd ;
    int dagstream = 0; /* dagstream shud be 0,2,4 (even numbers) upto the number of receive strms available */
    dag_record_t  *rec=NULL;
	uint8_t continue_run = 1;
    int len = 0;
    int captured_recs = 0;
    char *dagname = "/dev/dag0";

	if ((dagfd = dag_open(dagname)) < 0)
    {
		printf("dag_open falild %s: %s\n", dagname, strerror(errno));
        return -1;
    }
    /* dagstream should  be even numbers for receive operations*/	
	if (dag_attach_stream(dagfd, dagstream, 0, 0) < 0)
    {
	   printf("dag_attach_stream %s:%u: %s\n", dagname, dagstream, strerror(errno));
       return -1;
    }
	if (dag_start_stream(dagfd, dagstream) < 0)
    {
		printf("dag_start_stream %s:%u: %s\n", dagname, dagstream, strerror(errno));
        return -1;
    }
   
    
    while (continue_run)
    {
        /* this API gets One ERF record at a time we could use dag_advance_stream() as well*/
        rec = (dag_record_t*)dag_rx_stream_next_record(dagfd, dagstream);
        if ( NULL == rec )
        {
            printf("Got NULL record, continuing \n");
            continue;
        }
        /* get the length */
       if ( 0 == ((dag_record_t *)rec)->type )
	   {
		  printf("Not ERF type \n");
          continue;
	   }
       /* It is an ERF format. Calculate its lenth*/
		len = ntohs(((dag_record_t *)rec)->rlen);
        captured_recs++;
        handle_packet( rec, len);
    }
    dag_stop_stream(dagfd, dagstream);
	dag_detach_stream(dagfd, dagstream);
	dag_close(dagfd);
}

