/* Endace headers. */
#include "dagapi.h"
#include "dag_platform.h"
#define TEST_MAX_PACKET_SIZE 2048
#define NUMBER_OF_RECORDS_TOBE_PROCESSED 100000
static int dagrxstream = 0; 
static int dagtxstream = 1;
static int dagfd;
static unsigned char user_packet_buffer[TEST_MAX_PACKET_SIZE];
static char *dagname = "/dev/dag0";

dag_record_t* get_modified_erf(dag_record_t  *in_rec, int *len )
{
    int record_len = 0;
    dag_record_t *ret_rec = NULL;
    
    ret_rec = (dag_record_t*) user_packet_buffer;
    record_len = ntohs(((dag_record_t *)in_rec)->rlen); 
    memcpy((void*)ret_rec,(void*) in_rec, record_len);
    /* process the packet on the user buffer here */

    *len = record_len;
    return ret_rec;
}
int  initialize_streams()
{
     /* dagrxstream should  be even numbers for receive operations*/
    if (dag_attach_stream(dagfd, dagrxstream, 0, 0) < 0)
    {
        printf("dag_attach_stream %s:%u: %s\n", dagname, dagrxstream, strerror(errno));
        return -1;
    }
    if (dag_start_stream(dagfd, dagrxstream) < 0)
    {
        printf("dag_start_stream %s:%u: %s\n", dagname, dagrxstream, strerror(errno));
        return -1;
    }

    if (dag_attach_stream(dagfd, dagtxstream, 0, 0) < 0)
    {
	   printf("dag_attach_stream %s:%u: %s\n", dagname, dagtxstream, strerror(errno));
       return -1;
    }
	if (dag_start_stream(dagfd, dagtxstream) < 0)
    {
		printf("dag_start_stream %s:%u: %s\n", dagname, dagtxstream, strerror(errno));
        return -1;
    }
    return 0;
}
void close_streams()
{
    dag_stop_stream(dagfd, dagtxstream);
    dag_detach_stream(dagfd, dagtxstream);
    dag_stop_stream(dagfd, dagrxstream);
    dag_detach_stream(dagfd, dagrxstream);
}
int main ()
{
    dag_record_t  *captured_rec=NULL;
    dag_record_t  *transmit_rec =NULL;
    uint8_t continue_run = 1;
    int captured_len = 0;
    int transmit_len = 0;
    int captured_recs = 0;
    

    if ((dagfd = dag_open(dagname)) < 0)
    {
        printf("dag_open falild %s: %s\n", dagname, strerror(errno));
        return -1;
    }
   
    if ( -1 == initialize_streams() )
    {
        printf("initialize_streams() failed \n");
        return -1;
    }

    
    while (continue_run)
    {
        /* this API gets One ERF record at a time. we could use dag_advance_stream() as well*/
        captured_rec = (dag_record_t*)dag_rx_stream_next_record(dagfd, dagrxstream);
        if ( captured_rec == NULL )
        {
            printf("Null Record\n");
            continue;
        }
        captured_recs++;
        if ( 0 == ((dag_record_t *)captured_rec)->type )
        {
             printf("Not ERF type \n");
             continue;
        }
        transmit_rec = get_modified_erf(captured_rec, &transmit_len);
        if ( (NULL == transmit_rec) || (0 == transmit_len ) )
        {
            printf("Invalid record \n");
            continue;
        }
        
        if ( dag_tx_stream_copy_bytes(dagfd, dagtxstream, (uint8_t*)transmit_rec, transmit_len) !=  transmit_len)
	       printf("dag_tx_stream_copy_bytes %u: %s\n", dagtxstream, strerror(errno));
 
        if ( captured_recs >= NUMBER_OF_RECORDS_TOBE_PROCESSED)
            break;
    }
    printf("processed %d records \n",captured_recs);
    close_streams();
    dag_close(dagfd);

    return 0;
}
