/*
 * Copyright (c) 2007 Endace Technology Ltd, Hamilton, New Zealand.
 * All rights reserved.
 *
 * This source code is proprietary to Endace Technology Limited and no part
 * of it may be redistributed, published or disclosed except as outlined in
 * the written contract supplied with this product.
 *
 * $Id: open_setup_card1.c 7293 2007-09-04 23:46:18Z vladimir $
 */

/* Endace headers */
#include "dag_config_api.h"
#include "dag_platform.h"
#include "dag_romutil.h"

/* Project headers. */


#define LINE_SIZE 1024

/* CVS Header. */
static const char* const kCvsHeader __attribute__ ((unused)) = "$Id: open_setup_card1.c 7293 2007-09-04 23:46:18Z vladimir $";
static const char* const kRevisionString = "$Revision: 7293 $";



int main(int argc, char* argv[])
{
char dagname[]="dag0";
//char dagname[]="dag0:0"
char * cardtypestring;
dag_card_t cardtype;
romtab_t *rp;
dag_card_ref_t card_ref;
int dagfd;
dag_component_t root_component = 0;
dag_component_t port_component = 0;
attr_uuid_t attrib = 0;

		
	/* Init config and status api */
	card_ref = dag_config_init(dagname);
	if (card_ref == NULL)
	{
		printf("No card\n");
		return EXIT_FAILURE;
	}
	
	/* 
	* get card type as a enumaration type dag_card_t
	* if your software is dependednt on some card specific features you can use this type 
	* and the constants decleared in the header files like kDag71S  or what ever 
	*/
	cardtype = dag_config_get_card_type(card_ref);
	/* get the card type(name) as string and prints it out
	 * you can use this for information on what card the software is running for logging  
	 */
	cardtypestring = dag_config_get_card_type_as_string(card_ref);
	printf("CARD NAME: %s\n",cardtypestring);

	
	/*SWITCH TO THE CURRENT(user) HALF 
	* Note this is equivalent to 'dagrom -p'
	* We must close the config and status api and reopen it again after this operation
	* in case the features or firmware is changed 
	*/
	dagfd = dag_config_get_card_fd(card_ref);
	/* // alternatevly if not using config and status api initialized card_ref
	 dagfd = dag_open(dagname) 
	  // Note that dagname has to be in the systtem device name not just 'dag0'
	  // there is a function for parsing which is OS independent look at example simpleopen.c
	*/
	rp = dagrom_init(dagfd,0,0);
	dagrom_loadcurrent(dagfd,rp);
	/*
	 // Alternatevly 
	 dag_close(dagfd);
	*/
	
	/* close the card and reopen */
	dag_config_dispose(card_ref);

	/* Init config and status api again after the swithc images*/
	card_ref = dag_config_init(dagname);
	if (card_ref == NULL)
	{
		printf("No card\n");
		return EXIT_FAILURE;
	}
	
	/* 
	* get card type as a enumaration type dag_card_t
	* if your software is dependednt on some card specific features you can use this type 
	* and the constants decleared in the header files like kDag71S  or what ever 
	*/
	cardtype = dag_config_get_card_type(card_ref);
	/*get the card type(name) as string and prints it out
	 * you can use this for information on what card the software is running for logging  
	 */
	cardtypestring = dag_config_get_card_type_as_string(card_ref);
	printf("CARD NAME: %s\n",cardtypestring);


	/*********************************************************************/
	/* set the port in FCL mode                                          */
	/* assumption that card_ref has been initialized via dag_config_init */
	/*********************************************************************/
	
	/*get root component of the card
	* used to access most other components 
	*/
	root_component = dag_config_get_root_component(card_ref);
	/* verify that the opration is done */
	if(! root_component)
	{
		/*simple error handling code 
		* this will be happened only if card)ref is not initialized or something really wrong
		*/
		printf("This is a fatal error for config and status api\n");
		exit(1);
	}
	
	/* Finds the port 0 component to be able to operate */
	port_component = dag_component_get_subcomponent(root_component, kComponentPort, 0);
	if(! port_component)
	{
		/* simple error handling code for component find
		*  this will happened if port component is missing for example if you try to setup port 3 instead of 0 and not presented on the card
		*  Other possible reason if you try to access a component code which on  card with specific firmwareis missing 
		*  kComponentPort is at leas one copy on almost all Endace cards and firmware revisions
		*/
		printf("This is a non fatal error for config and status api in some cases can be a fatal\n");
		exit(1);
	}
	
	/* acuaring the attribute from the component which we want to operate on (read or modify) 
	* in this case it is the FCL
	* there are two types of attributes:
	* * config (which are read,write) for some reasons the write can be disabled on some type of cards and firmware images,  you still will be able to use the write method but this will not change the value  
	* * status attributes (read) thsi is status of the line, card, counters - note the write method of the status attributes can be used for a specific reasons like latch and clear or some other if so it will be mentioned for the specifc attribute
	*/
        attrib = dag_component_get_attribute_uuid(port_component, kBooleanAttributeFacilityLoopback);
	if( attrib == kAttributeInvalid )
	{
		/* simple verification if the attribute exists 
		* not all attributes will be supported on all cards or firmware images 
		* the fcl attribute is supported on most Endace cards and firmware images
		*/
		printf("This is a non fatal error for config and status api \n");
		exit(1);
	}
	
//	dag_config_set_boolean_attribute();
        //if (dag_config_get_boolean_attribute(card_ref, attr) == kSonetTypeChannelized)
        //{
         //    attr = dag_component_get_attribute_uuid(demapper, kNullAttributeClearConnections);
        //     dag_config_set_null_attribute(card_ref, attr);
//	}

	
    return EXIT_SUCCESS;
}

