/*
 * Copyright (c) 2006-2006 Endace Technology Ltd, Hamilton, New Zealand.
 * All rights reserved.
 *
 * This source code is proprietary to Endace Technology Limited and no part
 * of it may be redistributed, published or disclosed except as outlined in
 * the written contract supplied with this product.
 *
 * $Id: dagsnap_model.h 9888 2008-09-05 02:39:47Z karthik $
 */

#ifndef DAGSNAP_MODEL_H
#define DAGSNAP_MODEL_H

/* dagsnap headers. */
#include "dagsnap_config.h"

/* Endace headers. */
#include "dag_platform.h"


typedef struct Dagsnap_ Dagsnap_;
typedef Dagsnap_ * DagsnapPtr; /* Opaque type-safe pointer. */


/* Information passed to clients for display purposes. */
typedef struct dagsnap_info_t
{
	int64_t file_offset;
	uint64_t diff;
	int64_t lastoff;
	int state;

} dagsnap_info_t, * DagsnapInfoPtr;


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


/**
Create a dagsnap object.
@param config The configuration options to apply to the capture session.  The config object is owned by the dagsnap object after this call, and will be disposed in the call to dagsnap_dispose.
@return A reference to a new dagsnap object.
*/
DagsnapPtr dagsnap_create(DagsnapConfigPtr config);

/**
Dispose of a dagsnap object.
@param snapper A reference to the dagsnap object.
*/
void dagsnap_dispose(DagsnapPtr snapper);

/**
Retrieve the status of a dagsnap capture session.
@param snapper A reference to a dagsnap object.
@param info A pointer to a dagsnap_info_t struct.  On return the fields in this object will have been updated with the state of the capture session at the time the routine was called.
*/
void dagsnap_get_status(DagsnapPtr snapper, DagsnapInfoPtr info);

/**
Start the capture session.
@param snapper A reference to a dagsnap object.
@return 1 on success, 0 otherwise.
*/
int dagsnap_capture(DagsnapPtr snapper);

/**
Stop a capture session.
@param snapper A reference to a dagsnap object.
*/
void dagsnap_stop(DagsnapPtr snapper);


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* DAGSNAP_MODEL_H */
