/*
 * Copyright (c) 2006-2006 Endace Technology Ltd, Hamilton, New Zealand.
 * All rights reserved.
 *
 * This source code is proprietary to Endace Technology Limited and no part
 * of it may be redistributed, published or disclosed except as outlined in
 * the written contract supplied with this product.
 *
 * $Id: dagflood_config.h 9889 2008-09-05 02:54:11Z karthik $
 */

#ifndef DAGFLOOD_CONFIG_H
#define DAGFLOOD_CONFIG_H

/* Endace headers. */
#include "dag_platform.h"

typedef struct DagfloodConfig_ DagfloodConfig_;
typedef DagfloodConfig_ * DagfloodConfigPtr; /* Opaque type-safe pointer. */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


/* Allocation and disposal. */
DagfloodConfigPtr dagflood_config_init(void);
DagfloodConfigPtr dagflood_config_dispose(DagfloodConfigPtr bean);

/* Getters and Setters for properties. */
const char* dagflood_config_get_device(DagfloodConfigPtr bean);
void dagflood_config_set_device(DagfloodConfigPtr bean, const char* value);
const char* dagflood_config_get_infile_name(DagfloodConfigPtr bean);
void dagflood_config_set_infile_name(DagfloodConfigPtr bean, const char* value);
int32_t dagflood_config_get_dagstream(DagfloodConfigPtr bean);
void dagflood_config_set_dagstream(DagfloodConfigPtr bean, int32_t value);
uint32_t dagflood_config_get_burst_max(DagfloodConfigPtr bean);
void dagflood_config_set_burst_max(DagfloodConfigPtr bean, uint32_t value);
uint32_t dagflood_config_get_inter_burst_microseconds(DagfloodConfigPtr bean);
void dagflood_config_set_inter_burst_microseconds(DagfloodConfigPtr bean, uint32_t value);
uint32_t dagflood_config_get_repetitions(DagfloodConfigPtr bean);
void dagflood_config_set_repetitions(DagfloodConfigPtr bean, uint32_t value);
uint32_t dagflood_config_get_run_seconds(DagfloodConfigPtr bean);
void dagflood_config_set_run_seconds(DagfloodConfigPtr bean, uint32_t value);
uint8_t dagflood_config_get_api(DagfloodConfigPtr bean);
void dagflood_config_set_api(DagfloodConfigPtr bean, uint8_t value);
uint8_t dagflood_config_get_run_mode(DagfloodConfigPtr bean);
void dagflood_config_set_run_mode(DagfloodConfigPtr bean, uint8_t value);
uint8_t dagflood_config_get_verbosity(DagfloodConfigPtr bean);
void dagflood_config_set_verbosity(DagfloodConfigPtr bean, uint8_t value);
uint8_t dagflood_config_get_flush_tx_buffer(DagfloodConfigPtr bean);
void dagflood_config_set_flush_tx_buffer(DagfloodConfigPtr bean, uint8_t value);


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* DAGFLOOD_CONFIG_H */
