#include "common.h"
void duckread(dag_card_ref_t card_ref,dag_component_t duck)
{
    
    attr_uuid_t attr = 0;
    uint64_t val_uint64;
    uint32_t val_uint32;
    int32_t val_int32;
    bool val_bool;
    /*Reading Input Configuration*/
    printf("muxin   ");
    attr = dag_component_get_attribute_uuid(duck,kBooleanAttributeDUCKRS422Input);
    if(attr != kAttributeInvalid)
    {
          val_bool = (uint8_t)dag_config_get_boolean_attribute(card_ref,attr);
          printf("%s", val_bool ? "rs422 ":"");

    }
    attr = dag_component_get_attribute_uuid(duck,kBooleanAttributeDUCKHostInput);
    if(attr != kAttributeInvalid)
    {
          val_bool = (uint8_t)dag_config_get_boolean_attribute(card_ref,attr);
          printf("%s", val_bool ? "host ":"");
    }
    attr = dag_component_get_attribute_uuid(duck,kBooleanAttributeDUCKOverInput );
    if(attr != kAttributeInvalid)
    {
          val_bool = (uint8_t)dag_config_get_boolean_attribute(card_ref,attr);
          printf("%s", val_bool ? "over ":"");
    }
    attr = dag_component_get_attribute_uuid(duck, kBooleanAttributeDUCKAuxInput );
    if (attr != kAttributeInvalid)
    {
          val_bool = (uint8_t)dag_config_get_boolean_attribute(card_ref,attr);
          printf("%s", val_bool ? "aux":"");

    }
    /*Reading the output Configuration*/
    printf("\nmuxout  ");
    attr = dag_component_get_attribute_uuid(duck,kBooleanAttributeDUCKRS422Output );
    if (attr != kAttributeInvalid)
    {
            val_bool = (uint8_t)dag_config_get_boolean_attribute(card_ref,attr);
            printf("%s", val_bool ? "rs422 ":"");
    }
    attr = dag_component_get_attribute_uuid(duck,kBooleanAttributeDUCKLoop);
    if(attr != kAttributeInvalid)
    {
          val_bool = (uint8_t)dag_config_get_boolean_attribute(card_ref,attr);
          printf("%s", val_bool ? "loop":""); 
    }
    attr = dag_component_get_attribute_uuid(duck,kBooleanAttributeDUCKHostOutput);
    if (attr != kAttributeInvalid)
    {
            val_bool = (uint8_t)dag_config_get_boolean_attribute(card_ref,attr);
            printf("%s", val_bool ? "host ":"");
    }
    attr = dag_component_get_attribute_uuid(duck,kBooleanAttributeDUCKOverOutput );
    if (attr != kAttributeInvalid)
    {
            val_bool = (uint8_t)dag_config_get_boolean_attribute(card_ref,attr);
            printf("%s", val_bool ? "over ":"");
    }
    /*Reading Status Configuration*/
    printf("\nstatus  ");
    attr = dag_component_get_attribute_uuid(duck,kBooleanAttributeDUCKSynchronized);
    if(attr != kAttributeInvalid)
    {
          val_bool = (uint8_t)dag_config_get_boolean_attribute(card_ref,attr);
          printf("%sSynchronized ",val_bool ?"":"Not ");
    }
    attr = dag_component_get_attribute_uuid(duck,kUint32AttributeDUCKThreshold );
    if (attr != kAttributeInvalid)
    {
          val_uint32 = (uint32_t)dag_config_get_uint32_attribute(card_ref,attr);
          printf("Threshold %.0fns ",val_uint32/(0x100000000ll/1000000000.0));
    }
    attr = dag_component_get_attribute_uuid(duck,kUint32AttributeDUCKFailures);
    if(attr != kAttributeInvalid)
    {
           val_uint32 = (uint32_t)dag_config_get_uint32_attribute(card_ref,attr);
           printf("Failures %u ",val_uint32);
    }
    attr = dag_component_get_attribute_uuid(duck,kUint32AttributeDUCKResyncs);
    if(attr != kAttributeInvalid)
    {
            val_uint32 = (uint32_t) dag_config_get_uint32_attribute(card_ref,attr);
            printf("Resyncs %u ",val_uint32);
    }
    /*Reading Error Configuration*/
    printf("\nerror   ");
    attr = dag_component_get_attribute_uuid(duck,kInt32AttributeDUCKFrequencyError);
    if (attr != kAttributeInvalid)
    {
            val_int32 = (int32_t) dag_config_get_int32_attribute(card_ref,attr);
            printf("Freq %.0fppb ",val_int32/(0x100000000ll/1000000000.0));
    }
    attr = dag_component_get_attribute_uuid(duck,kInt32AttributeDUCKPhaseError);
    if (attr != kAttributeInvalid)
    {
          val_int32 = (int32_t) dag_config_get_int32_attribute(card_ref,attr);
          printf("Phase %.0fns ",val_int32/(0x100000000ll/1000000000.0));
    }
    attr = dag_component_get_attribute_uuid(duck,kUint32AttributeDUCKWorstFrequencyError);
    if (attr != kAttributeInvalid)
    {
          val_uint32 = (uint32_t)dag_config_get_uint32_attribute(card_ref,attr);
          printf("Worst Freq %.0fppb ",val_uint32/(0x100000000ll/1000000000.0));
    }
    attr = dag_component_get_attribute_uuid(duck,kUint32AttributeDUCKWorstPhaseError );
    if (attr != kAttributeInvalid)
    {
           val_uint32 = (uint32_t)dag_config_get_uint32_attribute(card_ref,attr);
           printf("Worst Phase %.0fns ",val_uint32/(0x100000000ll/1000000000.0));
    }
    /*Reading Crystal Configuration*/
    printf("\ncrystal ");
    attr = dag_component_get_attribute_uuid(duck,kUint32AttributeDUCKCrystalFrequency);
    if (attr != kAttributeInvalid)
    {
          val_uint32 = (uint32_t)dag_config_get_uint32_attribute(card_ref,attr);
          printf("Actual %dHz ",val_uint32);
    }
    attr = dag_component_get_attribute_uuid(duck,kUint32AttributeDUCKSynthFrequency);
    if (attr != kAttributeInvalid)
    {
          val_uint32 = (uint32_t)dag_config_get_uint32_attribute(card_ref,attr);
          printf("Synthesized %dHz ",val_uint32);
    }
    /*Reading Input Pulses Statastics*/
    printf("\ninput   ");
    attr = dag_component_get_attribute_uuid(duck,kUint32AttributeDUCKPulses);
    if (attr != kAttributeInvalid)
    {
          val_uint32 = (uint32_t)dag_config_get_uint32_attribute(card_ref,attr);
          printf("Total %d ",val_uint32);
    }
    attr = dag_component_get_attribute_uuid(duck,kUint32AttributeDUCKResyncs);
    if(attr != kAttributeInvalid)
    {
            val_uint32 = (uint32_t) dag_config_get_uint32_attribute(card_ref,attr);
            printf("Bad %u ",val_uint32);
    }
    attr = dag_component_get_attribute_uuid(duck,kUint32AttributeDUCKSinglePulsesMissing );
    if (attr != kAttributeInvalid)
    {
          val_uint32 = (uint32_t)dag_config_get_uint32_attribute(card_ref,attr);
          printf("Singles Missed %d ",val_uint32);
    }
    attr = dag_component_get_attribute_uuid(duck,kUint32AttributeDUCKLongestPulseMissing );
    if (attr != kAttributeInvalid)
    {
          val_uint32 = (uint32_t)dag_config_get_uint32_attribute(card_ref,attr);
          printf("Longest Sequence Missed %d ",val_uint32);
    }
    /*Reading duck time info structure*/
    attr = dag_component_get_attribute_uuid(duck,kStructAttributeDUCKTimeInfo);
    if (attr != kAttributeInvalid)
    {
            union
            {
                duck_time_info_t* ti;
                void* ptr;
            } time_info;
            
            dag_config_get_struct_attribute(card_ref, attr, &time_info.ptr);
            
            assert(time_info.ti);
            printf("\nstart   %s", ctime(&(time_info.ti->mStart)));
            printf("Host    %s", ctime(&(time_info.ti->mEnd)));
            if (time_info.ti->dagTime)
            {
                printf("Dag     %s",ctime(&(time_info.ti->dagTime)));
            }
            else
                    printf("Dag     No Active Input - Free Running \n");
    }

    attr = dag_component_get_attribute_uuid(duck,kUint64AttributeDUCKTSC);
    if (attr != kAttributeInvalid)
    {
           val_uint64 = (uint64_t)dag_config_get_uint64_attribute(card_ref,attr);
           if (0!= val_uint64)
           {
#if defined(__FreeBSD__) || defined(__linux__) || defined (__NetBSD__) || (defined(__SVR4) && defined(__sun)) || (defined(__APPLE__) && defined(__ppc__))
               printf("TSC\t%"PRIu64"\n", val_uint64);
#elif defined(_WIN32)
               printf("TSC\t%I64u\n", val_uint64);
#endif
            }
    }
    return;
}


    
    	
