#include "dagutil.h"
#include "dag_config.h"
#include "dag_component.h"
#include "dag_platform.h"
#include "dag_romutil.h"
#include "dagclarg.h"
#include "dagapi.h"


void duckread(dag_card_ref_t card_ref,dag_component_t duck);

/*Application Globals*/
char dagname_buf[DAGNAME_BUFSIZE];
char dagname[DAGNAME_BUFSIZE];

/* Commandline argument codes. */
typedef struct configtab {
              char    *key;           /* the command */
              int     mlen;           /* minimum match length */
              int     inst;           /* instruction to be executed */
} configtab_t;

enum
{
   INST_DEFAULT,
   INST_NONE,
   INST_RS422IN,
   INST_HOSTIN,
   INST_OVERIN,
   INST_AUXIN,
   INST_RS422OUT,
   INST_LOOP,
   INST_HOSTOUT,
   INST_OVEROUT,
   INST_SET,
   INST_RESET,
   INST_SYNC,
   INST_MASTER
};
static configtab_t configtab[] = {
{   "default",  7,  INST_DEFAULT    },
{   "none",     4,  INST_NONE       },
{   "rs422in",  6,  INST_RS422IN    },
{   "hostin",   5,  INST_HOSTIN     },
{   "overin",   5,  INST_OVERIN     },
{   "auxin",    4,  INST_AUXIN      },
{   "rs422out", 6,  INST_RS422OUT   },
{   "loop",     4,  INST_LOOP       },
{   "hostout",  5,  INST_HOSTOUT    },
{   "overout",  5,  INST_OVEROUT    },
{   "set",      3,  INST_SET        },
{   "reset",    5,  INST_RESET      },
{   "sync",     4,  INST_SYNC       },
{   "master",   6,  INST_MASTER     },
{   NULL,       0,  0               },
};
enum
{
     CLA_HELP,
     CLA_VERBOSE,
     CLA_VERSION,
     CLA_CLRSTATS,
     CLA_SYNC,
     CLA_TIMEOUT,
     CLA_THRESHOLD,
     CLA_DEVICE
};


