//Jianzhong Fang @ Endace ! Aug 2007
//packet layout//

#define ETH_ADDR_SZ     6
#define ETH_PACK_SZ    14
#define SNAP_LEN     1518

/*14B Ethernet header*/
struct pack_ethernet {
  unsigned char  eth_da[ETH_ADDR_SZ];
  unsigned char  eth_sa[ETH_ADDR_SZ];
  unsigned short eth_type;           //IP, APR, RARP, ICMP, IGMP, UDP, TCP, ...
};

/*20B IP layer header*/
struct pack_ipnet {
  unsigned char  ip_vhl;             //1B version<<4 | header length>>2
  unsigned char  ip_tos;             //1B type of service
  unsigned short ip_len;             //2B total length
  unsigned short ip_id;              //2B identification
#define IP_RF 0x8000            /* reserved fragment flag */
#define IP_DF 0x4000            /* dont fragment flag */
#define IP_MF 0x2000            /* more fragments flag */
#define IP_OFFMASK 0x1fff       /* mask for fragmenting bits */
  unsigned short ip_off;             //2B fragment offset field
  unsigned char  ip_ttl;             //1B time to live
  unsigned char  ip_p;               //1B protocol
  unsigned short ip_sum;             //2B checksum
  struct in_addr ip_src;             //4B source addr
  struct in_addr ip_dst;             //4B destination addr
};

#define IP_HSZ(ip)  (((ip->ip_vhl)&0x0f)<<2)
#define IP_VER(ip)  (((ip->ip_vhl)>>4) & 0x0f)

/*20B TCP layer header*/
struct pack_tcpnet {
  unsigned short tcp_sport;          //2B source port
  unsigned short tcp_dport;          //2B destination port
  unsigned int   tcp_seq;            //4B sequence number
  unsigned int   tcp_ack;            //4B acknowledge number
  unsigned char  tcp_off4x;          //1BH TCP header number
#define TH_FIN  0x01
#define TH_SYN  0x02
#define TH_RST  0x04
#define TH_PUSH 0x08
#define TH_ACK  0x10
#define TH_URG  0x20
#define TH_ECE  0x40
#define TH_CWR  0x80
  unsigned char  tcp_flag;           //1B:: C E U A P R S F
  unsigned short tcp_win;            //2B
  unsigned short tcp_sum;            //2B
  unsigned short tcp_uptr;           //2B urgent pointer
};

#define TCP_HSZ(tcp)  ((((tcp->tcp_off4x)>>4)&0x0f)<<2)

void print_eth_hd(void *);
void print_ip_hd(void *);
void print_tcp_hd(void *);

unsigned short CHKSUMIP(struct pack_ipnet *ip);
