 /*
 *  * Copyright (c) 2007 Endace Technology Ltd, Hamilton, New Zealand.
 ** All rights reserved.
 **
 ** This source code is proprietary to Endace Technology Limited and no part
 ** of it may be redistributed, published or disclosed except as outlined in
 ** the written contract supplied with this product.
 **
 ** 
 **/

/*headers */
#include "dagapi.h"
#include "dag_config_api.h"
#include "dag_platform.h"
#include "dag_romutil.h"
#include "dagsarapi.h"
#include "dagema.h"
#include "dag37t_api.h"

#include <string.h>



uint32_t vpi = 28;
uint32_t vci= 64;
uint32_t connection_num = 16;
sar_mode_t sar_mode = sar_aal5;
net_mode_t net_mode = 0;
char *dag_name = "/dev/dag0";
static bool reset_xscale = false;

int get_from_string( char *in_string )
{
    char *int_string = NULL ;
    char *result = NULL;
    result = strtok ( in_string,"=");
    while ( NULL != result )  
    {
        int_string = result;
        result= strtok(NULL, "=" );
    }
    if (  int_string )
        return atoi( int_string);
    else 
        return  -1;
         
}


int main ( int argc, char **argv )
{
    int dagfd;
    int res;
    sar_mode_t mode = sar_aal0;

    /* process input arguments */
    if ( argc > 1 )
    {
        int index = 1;
        for (;index < argc; index++ )
        {
            if ( strstr(argv[index],"connection=" ) )
            {
                connection_num = get_from_string(argv[index]);
            }
            else if (strstr(argv[index],"vpi="))
            {
                vpi = get_from_string(argv[index]);
            }
            else if (strstr(argv[index],"vci="))
            {
                vci = get_from_string(argv[index]);
            }
            else if (strstr(argv[index],"sarmode="))
            {
                sar_mode = (sar_mode_t) get_from_string(argv[index]);
            }

            else if (strstr(argv[index],"netmode="))
            {
                net_mode = (net_mode_t) get_from_string(argv[index]);
            }

            else if ( !strcmp( argv[index] ,"dag=dag1" ) )
            {
                strcpy(dag_name, "/dev/dag1");
            }
            else if ( ! strcmp(argv[index], "--help"))
            {
                printf("Usage %s [Options]\n",argv[0]);
                printf("Options:\n  dag=<dag0>\t\t device dag0 or dag1\n reset \t\t reset and starts the X-scale \nconnection=<16>\t\t connection to configure . deflt 16 \n vpi=<28>\t\tVPI to configure\n vci=<64>\t\t VCI to confiure \n sarmode=<0>\t\t reassembly type to use 0=ATM 1=AAL2 2=AAL5 \n netmode=<0>\t\t 0=nni 1=uni\n");
                return 1;
            }
            else if ( !strcmp ( argv[index], "reset" ))
            {
                reset_xscale = true;
            }
            else 
            {
                printf("Invalid option %s. Try removing spaces or try --help\n",argv[index]);
                return 1;
            }

        }
    }
    else
    {
            printf ("Use %s --help \n", argv[0]);
            return 1;
    }



    printf("Device %s connection %d VPI %d VCI %d sarmode %d netmode %d\n",dag_name, connection_num,vpi,vci, sar_mode, net_mode);
    if ( (dagfd = dag_open(dag_name) ) < 0 )
    {
        printf ( "Opening the card failed . No card ??\n");
        return 1;
    }
    /* Set the mux */
    if (dag_set_mux(dagfd, DA_DATA_TO_LINE, DA_DATA_TO_IOP, DA_DATA_TO_HOST))
    {
        printf("dag_set_mux failed\n");
        return 1;
    }
    if ( reset_xscale )
    {
            printf("Resetting the processor.....\n");
            /* reset the processor */
            if ( dagema_reset_processor(dagfd, 0) < 0 )
            {
                printf("Failed to reset XScale (error code %d)\n", dagema_get_last_error());
                return 1; 
            }
    }

    printf( "Opening the connection....\n");
    /* open the connection with the procecssor */
    if ( (res = dagema_open_conn(dagfd)) < 0 )
    {
        printf("Failed to connect to board (error code %d)\n", dagema_get_last_error());
        return 1;
    }
    /*  deactivate the existing connection */
    if (0 == dagsar_vci_deactivate(dagfd, DAG37T_INTERFACE, connection_num, vpi, vci))
    {
        printf("VCI deactivation complete\n");
    }
    else
    {
        printf("VCI deactivation failed\n");
        return 1;
    }

    if (0 == dagsar_channel_set_net_mode(dagfd, DAG37T_INTERFACE, connection_num, net_mode))
    {
        printf("net mode set\n");
    }
    else
    {
        printf("set net mode failed\n");
        return 1;
    }
    /* set the SAR mode */
    if (0 == dagsar_vci_set_sar_mode(dagfd, DAG37T_INTERFACE, connection_num,vpi, vci, sar_mode))
    {    
        printf("sar mode set\n");
    }
    else
    {
        printf("set sar mode failed\n");
        return 1;
    }    

    /* To verify the SAR mode */
    mode = dagsar_vci_get_sar_mode(dagfd, DAG37T_INTERFACE,  connection_num, vpi, vci);
    if ( mode == sar_mode )
    {
        printf ("SAR mode set correclty \n");
    }
    else
    {
        printf("SAR mode not set correctly \n");
    }

    if (0 == dagsar_vci_activate(dagfd, DAG37T_INTERFACE,  connection_num, vpi, vci))
    {
        printf("activation complete\n");
    }
    else
    {
        printf("activation failed\n");
        return 1;
    }

    dagema_close_conn(dagfd, 0);
    dag_close (dagfd);

    return 0;
}

