/****************************************************************************
 * DAG Driver for Solaris
 * Copyright Endace Technology Ltd. 2005
 * Abel Navarro <abel@endace.com>
 * $Id: dagdrv.h 10272 2008-11-14 04:24:08Z jomi $
 * (best viewed with tab size 4)
 ****************************************************************************/
 
#ifndef DAGDRV_H
#define DAGDRV_H

/****************************************************************************
 * Includes
 ****************************************************************************/
#include <sys/types.h>
#include <sys/ddi.h>
#include <sys/sunddi.h>

#include <daginf.h>
#include "dagduck.h"

/****************************************************************************
 * Constants
 ****************************************************************************/
#define DAG_MAX_BOARDS	8
#define DAG_STREAM_MAX  256

/* dag device nodes */
#define DAG_MINOR		0
#define DAGMEM_MINOR	16
#define DAGIOM_MINOR	32
#define DAGARM_MINOR	48

typedef enum dag_register {
	ToHM0	= 	0x00,
	ToHM1	= 	0x04,
	ToHM2	= 	0x08,
	ToHM3	= 	0x0c,

	ToAM0	= 	0x40,
	ToAM1	= 	0x44,
	ToAM2	= 	0x48,
	ToAM3	= 	0x4c,

	ToHDB	= 	0x80,
	Ctrl	= 	0x88,
	IntEn	= 	0x8c,
} dag_register_t;

 
 /****************************************************************************
 * Data structures definitions
 ****************************************************************************/

/* saved pci configuration registers */
typedef struct dag_pciconf {
	uint32_t base0;            /* 0x10 - 32 bits                            */
	uint32_t base1;            /* 0x14 - 32 bits                            */
	uint32_t base2;            /* 0x18 - 32 bits                            */
	uint16_t command;          /* 0x04 - 16 bits                            */
	uint8_t  latency_timer;    /* 0x0d - 8 bits                             */
	uint8_t  interrupt_line;   /* 0x3c - 8 bits                             */
} dag_pciconf_t;
 
/*
 * This data structure keeps track for each individual instance (or unit) of
 * the DAG driver. We will have one of these structures for each card present
 * in the system. This only driver will handle all of them.
 */
typedef struct dag_softstate {
	int instance;						/* instance number not used at the moment (and position in array)  */
	dev_info_t * dip;        /* info about a driver instance  */
	
	/*handle for pci configuration space all accesses through here*/
	ddi_acc_handle_t    pci_conf_handle; 

	kmutex_t instance_mutex;                 /* per card mutex                       */

	//memory hole DMA and memory specific information
	ddi_dma_handle_t memhole_dma_handle;	/* handle for the memory hole region    */
	int memhole_dma_bound;		/* flag for bundled dma and memory */
	ddi_acc_handle_t    memhole_acc_handle; /* data handle for memhole allocation  */
	caddr_t memhole_addr;				/* memory hole kernel virtual address          */
	caddr_t memhole_paddr;				/* physical address          */
	size_t memhole_size;             /* memory hole real length (alignment)  */

	//may be we do not need to store this information 
	//other drivers do not do it 
	ddi_dma_cookie_t cookie;        /* cookie with physical memhole addr    */
	uint_t cookie_count;            /* number of cookies for memhole (1)    */
	
	kmutex_t intr_mutex;       /* per card mutex                       */
	ddi_iblock_cookie_t intr_cookie; /* cookie for handling interrupts       */
	
	
	
	//caddr_t iom;					/* mmaped iom space */
	ddi_acc_handle_t  drb_regs_handle;	/* handle for kernel drb registers (iom) mapping */
	caddr_t drb_regs;					/* kernel address of the drb mapped(iom) space */
	int drb_regs_size;					/* the size which was repoprted by the BAR and mapped to te Kernel */
	
	ddi_umem_cookie_t umem_cookie;  /* cookie to allow mmaping the mem hole */
	devmap_cookie_t devmap_cookie;  /* cookie to handle mmap                */
	
	dag_pciconf_t pciconf;          /* pci configuration registers          */
	daginf_t info;                  /* cached info about the device         */
	pid_t lock[DAG_STREAM_MAX];     /* stream locks based on process id     */
	dag_duck_t * duck;              /* timing facility structure            */
} dag_softstate_t;

#endif
