/*
 * Copyright (c) 2008 Endace Technology Ltd, Hamilton, New Zealand.
 * All rights reserved.
 *
 * This source code is proprietary to Endace Technology Limited and no part
 * of it may be redistributed, published or disclosed except as outlined in
 * the written contract supplied with this product.
 *
 * Author: Vladimir Minkov
 */

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,0)
// include <linux/cdev.h>
#else
// include <linux/devfs_fs_kernel.h>
#endif

#define VDAG_MAX_BOARDS 32
#define DAGMINOR_MAX 16
#define DAG_STREAM_MAX 64 // 256 

/* Note not to limit the number of cards and sterams
	design was made to use the major of the driver for diffrent functiuons
	and the minor is used for the cards 
	in this case we have  a lot of cards 
	The functions are limited to 4 so only 4 major codes will be used at driver level registration 
*/

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,0)
#define VDAGUNIT(X)	(iminor(X))
#define VDAGMAJOR(X)	(imajor(X))
#else
#define	VDAGUNIT(X)	(MINOR(X->i_rdev))
#define	VDAGMINOR(X)	(MAJOR(X->i_rdev))
#endif

/* This data structure keeps track for each individual stream of the vdag */
typedef struct vdag_lockstate {
	pid_t pid;			/* pid of the process/thread */
	pid_t tgid;			/* thread group Id */
	struct file* locked_file;	/* to remember through which fd the stream are locked */
}vdag_lockstate_t;

/*
 * This data structure keeps track for each individual instance (or unit) of
 * the DAG driver. We will have one of these structures for each card present
 * in the system. This only driver will handle all of them.
 */
typedef struct vdag_softstate {
	int unit ; 
	//struct char_dev * device;        /* info about a driver instance  */
	uint16_t device_id;		/* device id for simulate */
	uint8_t	brd_rev;		/* board revision for simulate */
	
	struct semaphore lock_sem;

	// instance_mutex;                 /* per card mutex                       */

	//memory buffer DMA and memory specific information
	struct page **page_list;/* list of pages for remapping */
	int order;		/* Page allocation order */
	uint32_t membuf_size; /* memory buffer real length (alignment)  */
	
        vdag_lockstate_t	card_lock;
        vdag_lockstate_t	mode_lock[DAG_LOCK_MODE_MAX];
	vdag_lockstate_t	stream_lock[DAG_STREAM_MAX][DAG_LOCK_MODE_MAX];    /* stream lock structs that each entry have read and write state */
	uint32_t stream_stat[DAG_STREAM_MAX]; /* means that normal side was started by the driver in absense of the reverse mode client */
	//char * user_iom;					/* mmaped iom space emulated at boot up or open */
	void * drb_regs;					/* kernel address of the drb mapped(iom) space */
	int drb_regs_size;					/* the size which was reported by the BAR and mapped to the Kernel */
	
	
//	daginf_t info;                  /* cached info about the device        used under Solaris */
	
	//not needed due it will be used by the master card 
	//dag_duck_t * duck;              /* timing facility structure            */
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,0)
//	struct cdev     cdev_dag, cdev_mem, cdev_iom, cdev_arm;
# else
//	devfs_handle_t	devfs_dag, devfs_mem, devfs_iom, devfs_arm;
# endif

} vdag_softstate_t;
