#ifndef _DAGDEBUG_H_
#define _DAGDEBUG_H_

/*
 *	DAG_ERROR	- a message is always printed at KERN_ERROR priority, this is need for error reporting 
 *	DAG_INFO	- a message is always printed at KERN_INFO priority, this is need for giving information to end user 
 *	DAG_VERB	- a message is printed at KERN_INFO priority, when DEBUG is defined or when verbose flag is set 
 *	DAG_DEBUG	- a message is printed at KERN_DEBUG priority when DEBUG is defined, this is need for debugging usually turned off
 */
#define DAG_ERROR(fmt, ...)						\
	do {								\
		printk(KERN_ERR	"%s: " fmt, __func__ , ##__VA_ARGS__);	\
	} while(0)

#define DAG_INFO(fmt, ...)						\
	do {								\
		printk(KERN_INFO fmt, ##__VA_ARGS__);			\
	} while(0)

#ifdef DEBUG
#define DAG_VERB(fmt, ...)						\
	do {								\
		printk(KERN_INFO"%s: " fmt, __func__, ##__VA_ARGS__);	\
	} while(0)

#define DAG_DEBUG(fmt, ...)						\
	do {								\
		printk(KERN_DEBUG"%s: " fmt, __func__ , ##__VA_ARGS__);	\
	} while(0)
#else
#define DAG_VERB(fmt, ...)						\
	do {								\
	    if (verbose)						\
		printk(KERN_INFO"%s: " fmt, __func__, ##__VA_ARGS__);	\
	} while(0)

#define DAG_DEBUG(fmt, ...)
#endif

#endif /* _DAGDEBUG_H_ */
