#ifndef DAGCOMPAT_H
#define DAGCOMPAT_H
/* The purpose of this file is to take care of Linux version 
 * compatibility in order to make original code more light */
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,33)
#include <generated/autoconf.h>
#elif LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,18)
#include <linux/autoconf.h>
#else
#include <linux/config.h>
#endif

/* Must not be based on kernel ALIGN call as older kernels do not bother
 * about typization */
#define DAG_ALIGN(x,a)	__DAG_ALIGN_MASK(x,(typeof(x))(a)-1)
#define __DAG_ALIGN_MASK(x,mask)	(((x)+(mask))&~(mask))

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,0)
#include <linux/moduleparam.h>

#define DAG_EXPORT_SYMBOL			EXPORT_SYMBOL
#define DAG_MODULE_PARAM			module_param
#define DAG_MODULE_PARAM_STRING		module_param_string
#define dag_pci_find_dev			pci_get_device

#else /* 2.4 families */

#define DAG_EXPORT_SYMBOL(a)
#define DAG_MODULE_PARAM(a, b, c)			MODULE_PARM(a, "i")
#define DAG_MODULE_PARAM_STRING(a, b, c, d)	MODULE_PARM(a, "1-127s")
#define dag_pci_find_dev					pci_find_device

#endif /* LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,0) */

#ifndef __GFP_NOWARN
#define __GFP_NOWARN 0
#endif

/* Kernel versions prior to 2.6.12 do not export node_online_map symbol. 
It prohibits proper NUMA support in drivers for these kernels */
#if defined(CONFIG_NUMA) && (LINUX_VERSION_CODE > KERNEL_VERSION(2,6,12))
#define dag_alloc_pages alloc_pages_node
#define dag_correct_node(nid) (node_online(nid) ? nid : numa_node_id())
#else
#define dag_alloc_pages(a, b, c) alloc_pages(b, c)
#define dag_correct_node(nid) (0)
#endif

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,23)
#define dag_kmem_cache_create kmem_cache_create
#else
#define dag_kmem_cache_create(a, b, c, d, e) kmem_cache_create(a, b, c, d, e, NULL)
#endif

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,15)
#define dag_kmem_cache kmem_cache
#else
#define dag_kmem_cache kmem_cache_s
#endif

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,29)
#define dag_create_hugetlb_file(name, size, creat) hugetlb_file_setup(name, size, VM_NORESERVE, creat)
#elif LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,22)
#define dag_create_hugetlb_file(name, size, creat) hugetlb_file_setup(name, size, creat)
#else
#define dag_create_hugetlb_file(name, size, creat) hugetlb_zero_setup(size, creat)
#endif

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,6)
#define dag_page_to_nid(p) page_to_nid(p)
#elif LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,0)
#define dag_page_to_nid(p) page_nodenum(p);
#endif

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,6,0)
#define msec_to_jiffies(ms) (((ms * HZ)/1000) > 0 ? (ms * HZ)/1000 : 1)

#define msleep(ms)	\
	do {							\
		schedule_timeout(msec_to_jiffies(ms));		\
		set_current_state(TASK_UNINTERRUPTIBLE);	\
	} while(0)

#endif

/* PCI related definitions */
#ifndef PCI_EXP_DEVCTL 
#define PCI_EXP_DEVCTL		8 /* PCI-E Device Control */
#endif
#define PCI_EXP_LNKCAP		12 /* PCI-E Link Capabilities */
#define PCI_EXP_LNKCAP_MLW	0x000003f0 /* Maximum Link Width */

#define PCI_EXP_LNKCTL		16 /* PCI-E Link Control */
#define PCI_EXP_LNKCTL_LD	0x0010  /* Link Disable */
#define PCI_EXP_LNKCTL_RL	0x0020  /* Retrain Link */
#define PCI_EXP_LNKCTL_ES	0x0080  /* Extended Synch */

#define PCI_EXP_LNKSTA		18  /* PCI-E Link Status */
#define PCI_EXP_LNKSTA_NLW	0x03f0 /* Nogotiated Link Width */


#endif /* DAGCOMPAT_H */
