#ifndef DAGDRV_H
#define DAGDRV_H

/* DAG tree headers. */
#include "dagnew.h"

#define DAG_REG_BASE    0x900
#define CAPS_BASE       0x98
#define CAPS_MAGIC      0xa6000000
#define CAPS_MAGIC_MASK 0xff000000

#define DAG_REG_ADDR_START 0xffa5
#define DAG_REG_ADDR_END   0xffff

typedef struct pciconfig {
	unsigned	ba0;	/* base address 0 */
	unsigned	ba1;	/* base address 1 */
	unsigned	ba2;	/* base address 2 */
	unsigned	com;	/* command */
	unsigned char	lin;	/* interrupt line */
	unsigned char	lat;	/* latency timer */
} pciconfig_t;

struct dag_duck;

typedef struct dag_lock {
	pid_t	pid;	/* pid of the process/thread */
	pid_t	pgid;  /* process group ID. */
} dag_lock_t;

typedef struct dag_softc {
	int			unit;		/* which card/device */
	int			guest;		/* Guest OS mode flag */
	device_t		device;		/* as opposed to dev_t */
	struct resource		*iomres;	/* IO memory resource  BAR0 */
	struct resource		*irqres;	/* interrupt resource */
	struct resource		*dmares;	/* Gueest OS DMA resource BAR1*/
#if __FreeBSD_version < 500000
	dev_t			dagdev;		/* user entry points */
	dev_t			dagmemdev;	/* user entry points */
	dev_t			dagiomdev;	/* user entry points */
	dev_t			dagarmdev;	/* user entry points */
	dev_t			dagramdev;	/* user entry points */
#else
	struct cdev		*dagdev;	/* user entry points */
	struct cdev		*dagmemdev;	/* user entry points */
	struct cdev		*dagiomdev;	/* user entry points */
	struct cdev		*dagarmdev;	/* user entry points */
	struct cdev		*dagramdev;	/* user entry points */
#endif
	void			*intrhand;	/* interrupt handler */
	void			*buf;		/* the large buffer */
	unsigned		bus_addr;	/* Bus address */
	unsigned		bufsize;	/* its size in bytes */
	unsigned		iomsize;	/* IO memory size */
	unsigned		monseq;		/* dagmon sequence */
	pciconfig_t		pciconfig;	/* PCI configurations */
	dag_lock_t		lock[DAG_STREAM_MAX]; /* stream lock structs */
	struct dag_duck         *duck;          /* duck runtime/stats */
} dag_softc_t;

int dag_pciconfig_restore(dag_softc_t *sc);


#endif /* DAGDRV_H */
