/*
 * This is modeled after kernel malloc/free in <sys/malloc.h>.
 */
# ifndef _DAGMEM_H_

# include <sys/malloc.h>

# define	DAGMEM_DEFAULT_SIZE	(32*1024*1024)
# define	DAGMEM_DEFAULT_NDAGS	16
# define	DAGMEM_DEFAULT_MINPHYS	(0)
# define	DAGMEM_DEFAULT_MAXPHYS	(BUS_SPACE_MAXADDR_32BIT)
# define	DAGMEM_DEFAULT_ALIGN	(1024*1024)
# define	DAGMEM_DEFAULT_BOUNDARY	(0)

void	dagmem_free __P((void *addr, struct malloc_type *type));
void	*dagmem_malloc
		__P((unsigned long size, struct malloc_type *type, int flags));

# endif /* _DAGMEM_H_ */
