/*
 * Copyright (c) 1999
 *
 * $Id: dagdebug.h 2 2003-10-15 20:39:35Z sfd $
 */
#ifndef _DAGDEBUG_H_
#define _DAGDEBUG_H_
/*
 * Debugging printouts are defined in 5 different stages:
 *	DA	- message is always printed
 *	DU	- message is always printed to user terminal
 *	DD	- message is printed when DAGDEBUG defined
 *	DV	- message is printed when DAGVERBOSE defined
 *	DX	- message is never printed
 */
# define	DA(MSG) dagdebug MSG
# define	DU(MSG) uprintf MSG

# ifdef	DAGDEBUG
# define	DD(MSG)	dagdebug MSG
# else
# define	DD(MSG)
# endif /* DAGDEBUG */

# ifdef	DAGVERBOSE
# define	DV(MSG)	dagdebug MSG
# else
# define	DV(MSG)
# endif /* DAGVERBOSE */

# define	DX(MSG)

static void dagdebug(char *fmt, ...);	/* local within every C file */

#endif /* _DAGDEBUG_H_ */
