/**********************************************************************
*
* Copyright (c) 2004-2005 Endace Technology Ltd, Hamilton, New Zealand.
* All rights reserved.
*
* This source code is proprietary to Endace Technology Limited and no part
* of it may be redistributed, published or disclosed except as outlined in
* the written contract supplied with this product.
*
* $Id: dag37tapi-example.c 2638 2005-11-29 23:33:56Z jasons $
*
**********************************************************************/

/**********************************************************************
* FILE:		dag37tapi-example.c
* DESCRIPTION:	DAG 3.7T Programming Interface example
*
* HISTORY:
*   LDM 02/7/04 - Initial version
**********************************************************************/

/* DAG headers. */
#include "dagapi.h"
#include "dag_platform.h"
#include "dag37t_api.h"

/* C Standard Library headers. */
#include <stdio.h>
#include <string.h> 
#include <stdlib.h>


#define DAG_DEFAULT_NAME "dag0"


int
main(int argc, char* argv[])
{
    int iDagFd;
    int iChannel;
    int iHyper;
    int iSub;
    int iRetVal;
    char *pcDagName = DAG_DEFAULT_NAME;
    
    printf("trying to open...");
  	if((iDagFd = dag_open(pcDagName)) < 0)
    {
		fprintf(stderr, "dag_open failed: %s\n", strerror(errno));
    }
    printf("done!\n");
    
    /* since state of the board is unknown, delete all possible channels */
    iRetVal = dag_delete_board_channels(iDagFd);
    if (iRetVal == 0)
    {
        printf("Deleted all channels on %s\n", pcDagName);
    }
    else
    {
        printf("Failed to delete all channels on %s\n", pcDagName);
    }
    
    dag_channel_verbosity(0);
    
    
    /* open a channel on line 0, timeslot 1 */
    iChannel = dag_add_channel(iDagFd,          /* dag */ 
                               DAG_DIR_RECEIVE, /* direction */
                               CT_CHAN,         /* simple channel */
                               0,               /* line */
                               1,               /* timeslot */
                               0);              /* use the hardware mapper */
    if (iChannel >= 0)
    {
        printf("Channel number %d is line 0, timeslot 1\n", iChannel);
    }
    else
    {
        printf("Failed creating channel on line 0, timeslot 1\n");
    }
    
    
    
    
    /* open a subchannel on line 4, timeslot 5, bits 0-1 */        
    iSub = dag_add_channel(iDagFd,              /* dag */ 
                           DAG_DIR_RECEIVE,     /* direction */
                           CT_SUB,              /* subchannel */
                           4,                   /* line */
                           0x00050003,          /* timeslot 5, bits 0-1 */
                           0);                  /* use the hardware mapper */
    if (iSub >= 0)
    {
        printf("Channel number %d is line 4, timeslot 5, bitmask 0x03\n", iChannel);
    }
    else
    {
        printf("Failed creating channel on line 4, timeslot 5, bitmask 0x03\n");
    }
    
    
    
    
    /* open a subchannel on line 5, timeslots 1,2,3,16 */        
    iHyper = dag_add_channel(iDagFd,            /* dag */ 
                             DAG_DIR_RECEIVE,   /* direction */
                             CT_HYPER,          /* subchannel */
                             5,                 /* line */
                             0x0001000E,        /* timeslots 1,2,3,16 */
                             0);                /* use the hardware mapper */
    if (iHyper >= 0)
    {
        printf("Channel number %d is line 5, timeslots 1,2,3,16\n", iChannel);
    }
    else
    {
        printf("Failed creating channel on line 5, timeslots 1,2,3,16\n");
    }
    
    

    /* delete channels */
    iRetVal = dag_delete_channel(iDagFd, iChannel);
    if (iRetVal)
    {
        printf("Failed deleting channel %d\n", iChannel);
    }

    iRetVal = dag_delete_channel(iDagFd, iSub);
    if (iRetVal)
    {
        printf("Failed deleting channel %d\n", iSub);
    }

    iRetVal = dag_delete_channel(iDagFd, iHyper);
    if (iRetVal)
    {
        printf("Failed deleting channel %d\n", iHyper);
    }


    return EXIT_SUCCESS;
}
