/*
 * Copyright (c) 2004 Endace Technology Ltd, Hamilton, New Zealand.
 * All rights reserved.
 *
 * This source code is proprietary to Endace Technology Limited and no part
 * of it may be redistributed, published or disclosed except as outlined in
 * the written contract supplied with this product.
 *
 * $Id: erf.h 401 2004-07-20 00:07:27Z abel $
 */
 
#ifndef _ERFH
#define _ERFH

#define ERF_LENGTH     16
#define ERF_ETH_LENGTH 18
#define ERF_POS_LENGTH 20

// This is actually for ethernet only records
typedef struct {
	unsigned long long timestamp;	// timestamp
	unsigned char type;
	unsigned char flags;
	unsigned short int rlen;
	unsigned short int lctr;
	unsigned short int wlen;
	unsigned char * payload;
} erf_t;

typedef struct {
	unsigned long long timestamp;	// timestamp
	unsigned char type;
	unsigned char flags;
	unsigned short int rlen;
	unsigned short int lctr;
	unsigned short int wlen;

 	unsigned char offset;
	unsigned char pad;
	unsigned char * payload;
} erf_eth_t;

typedef struct {
	unsigned long long timestamp;	// timestamp
	unsigned char type;
	unsigned char flags;
	unsigned short int rlen;
	unsigned short int lctr;
	unsigned short int wlen;

 	unsigned char address;		// cHDLC 0x0F (unicast), 0x8F (multicast)
	unsigned char control;		// zero, not checked
	unsigned short int protocol;	// 16-bit ethernet like protocol
	unsigned char * payload;
} erf_pos_t;


#endif

