/*
 * Copyright (c) 2004 Endace Technology Ltd, Hamilton, New Zealand.
 * All rights reserved.
 *
 * This source code is proprietary to Endace Technology Limited and no part
 * of it may be redistributed, published or disclosed except as outlined in
 * the written contract supplied with this product.
 *
 * $Id: dagrandom.h 401 2004-07-20 00:07:27Z abel $
 */
 
#ifndef NULL
#define NULL (void*)0
#endif
 
#ifndef _DAGRANDOMH
#define _DAGRANDOMH

#define _CONSTANT 		1
#define _UNIFORM  		2
#define _POISSON  		3
#define _NORMAL   		4
#define _PATTERN_ROUND  5
#define _PATTERN_BOUNCE 6

typedef struct _distribution_t {
	unsigned char type;
	unsigned int x;
	unsigned int y;
	unsigned int z;
	unsigned int next;	// next value
	int direction;		// bounce direction
	struct _distribution_t * distr;
	// counters
} distribution_t;

unsigned int getDistrNumber (distribution_t * distr);
distribution_t * distrNew (unsigned char type, unsigned int x, unsigned int y,
	unsigned int z, distribution_t * nested_distr);
void distrFree (distribution_t * distr);	
int distr_normal (distribution_t * distr);
int distr_uniform (distribution_t * distr);
int distr_poisson (distribution_t * distr);
int distr_pattern_round (distribution_t * distr);
int distr_pattern_bounce (distribution_t * distr);
unsigned int randomNibble (void);
void randomInit (unsigned long seed);

#endif
