/*
 * Copyright (c) 2004 Endace Technology Ltd, Hamilton, New Zealand.
 * All rights reserved.
 *
 * This source code is proprietary to Endace Technology Limited and no part
 * of it may be redistributed, published or disclosed except as outlined in
 * the written contract supplied with this product.
 *
 * $Id: daggen.h 9865 2008-09-01 08:16:23Z vladimir $
 */

#ifndef _DAGGENH
#define _DAGGENH

#define OUTPUT_FORMAT_ERF	1
#define OUTPUT_FORMAT_PCAP	2

#define LINK_ETHERNET		1
#define LINK_PPP		9
#define LINK_CHDLC		104
#define LINK_AAL5		100	// RFC 1483
#define LINK_ATM		123	// ATMSUN

#define SNAP_ROUND_DOWN		0
#define SNAP_ROUND_UP		1

typedef struct {
	char output_file[256];
	char config_file[256];
	char traffic_group[256];
	char verbose;
	int interface_num;			// Interface number (0-3)
	int rx_error;                   // Rx error (linl layer error)
	int fcs_size;			// Size of FCS (Frame Check Sequence)
	unsigned long random_seed;
	unsigned int snaplength;	// Actually how many bytes to write
	char snaplength_round;		// Round up or down in the 64-bit aligment
	unsigned char output_format;
	unsigned char link_type;	// equal to the first packet link type in
					// the packets list. Default ethernet
} options_t;

//
// Function declarations
//

#ifndef YYPARSE_PARAM
#ifdef __GNUC__ 
//	int yyparse (void);
#elif _WIN32
//	int yyparse (void);
#endif
#endif


void daggenInitOptions (void);

#endif
