/*
 * Copyright (c) 2004-2005 Endace Technology Ltd, Hamilton, New Zealand.
 * All rights reserved.
 *
 * This source code is proprietary to Endace Technology Limited and no part
 * of it may be redistributed, published or disclosed except as outlined in
 * the written contract supplied with this product.
 *
 * $Id: daggen.c 9865 2008-09-01 08:16:23Z vladimir $
 */

/* Project headers. */
#include "lex.h"
#include "gram.h"
#include "list.h"
#include "packet.h"
#include "toerf.h"
#include "daggen.h"
#include "cmdline.h"

/* C Standard Library headers. */
#include <string.h>
#include <time.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

extern 	int yyparse (void);

int errors = 0;
list_t *list;
list_t *packet_list;
list_t * group_list;
list_t *counter_list;
packet_t *packet;
options_t daggen_options;



// Function used to report errors
void
Error(char *format, ...)
{
	va_list args;
	
	errors++;
	printf ("Line %d: ", lineno);
	va_start(args, format);
	vfprintf(stdout, format, args);
	va_end(args);
	printf("\n");
}


// Show an error count
void
ErrorSummary(void)
{
	if (daggen_options.verbose || errors > 0)
		printf ("%d syntax error(s) were found.\n", errors);
}


// Function called by the parser when an error occurs while parsing
// (parse error or stack overflow)
void
yyerror(char *msg)
{
	Error (msg);
}


// This function is called by the lexer when the end-of-file
// is reached; you can reset yyin (the input FILE*) and return 0
// if you want to process another file; otherwise just return 1.
int yywrap(void)
{
	return 1;
}


void
daggenInitOptions(void)
{
	strcpy (daggen_options.output_file, "output.dag");
	strcpy (daggen_options.config_file, "config.dag");
	memset (daggen_options.traffic_group, 0, 256);
	daggen_options.verbose = 0;
	daggen_options.interface_num = 0;
	daggen_options.rx_error = -1;
	daggen_options.snaplength = 0xffffffff;
	daggen_options.snaplength_round = SNAP_ROUND_DOWN;
	daggen_options.fcs_size = -1;
	daggen_options.random_seed = (unsigned long)time(0);
	daggen_options.output_format = OUTPUT_FORMAT_ERF;
	daggen_options.link_type = LINK_ETHERNET;
}



// The main program: just report all tokens found
int
main(int argc, const char *argv[])
{
	// Inits
	list = listNew();
	packet_list = listNew();
	counter_list = listNew();
	
	daggenInitOptions();
	cmdlineParse(argc, (char**) argv, &daggen_options);
	
	yyin = fopen (daggen_options.config_file, "r");
	if (yyin == NULL)
	{
		printf ("Error: Cannot open config file '%s'\n", daggen_options.config_file);
		return EXIT_FAILURE;
	}
	// call the parser
	yyparse ();
	
	// Parse again command line to override config file options
	cmdlineParse2(argc, (char**) argv, &daggen_options);
	
	// Parsing error summary
	ErrorSummary ();
	
	if (0 == errors)
	{
		// Inform on random seed
		if (daggen_options.verbose)
		{
			printf ("Using random seed: %d\n", (int) daggen_options.random_seed);
		}
		randomInit(daggen_options.random_seed);
		
		
		// Write to disk
		toerf();

		return EXIT_SUCCESS;
	}

	return EXIT_FAILURE;
}
