/*
 * Copyright (c) 2002-2006 Endace Technology Ltd, Hamilton, New Zealand.
 * All rights reserved.
 *
 * This source code is proprietary to Endace Technology Limited and no part
 * of it may be redistributed, published or disclosed except as outlined in
 * the written contract supplied with this product.
 *
 * $Id: nullio.c 3871 2006-03-28 22:14:56Z koryn $
 *
 * Implements and I/O device that simply discards packets and never produces
 * them. This device may be useful in testing throughput or when attempting
 * to gather statistics.
 */

/* dagconvert headers. */
#include "inputs.h"
#include "outputs.h"
#include "utils.h"


/* Stub function does nothing. */
void
set_null_output(char *out)
{
	/* Do nothing. */
}


/* Stub function does nothing. */
void
close_null_output(void)
{
	/* Do nothing. */
}


/* Discard ERF header and payload. */
int
write_null_record(dag_record_t * header, void *payload)
{
	/* Do nothing. */
	return 1;
}


/* Stub function does nothing. */
void
set_null_input(char *in)
{
	/* Do nothing. */
}


/* Stub function does nothing. */
void
close_null_input(void)
{
	/* Do nothing. */
}


/* Stub function does nothing. */
dag_record_t *
get_next_null_header(void)
{
	/* Do nothing. */
	return NULL;
}


/* Stub function does nothing. */
void *
get_null_payload(void)
{
	/* Do nothing. */
	return NULL;
}
