/*
 * Copyright (c) 2005 Endace Technology Ltd, Hamilton, New Zealand.
 * All rights reserved.
 *
 * This source code is proprietary to Endace Technology Limited and no part
 * of it may be redistributed, published or disclosed except as outlined in
 * the written contract supplied with this product.
 *
 */

#ifndef TOKEN_PROCESSING_H
#define TOKEN_PROCESSING_H

#include "dag_config.h"

typedef struct
{
	dag_card_t card_type;
	dag_component_code_t component_code;
	int token;
} token_component_map_t;


void dag71s_process_token_routine(dag_card_ref_t card_ref, int token, const char* text, int lval, int port_select);
//void dag50s_process_token_routine(dag_card_ref_t card_ref, int token, const char* text, int lval, int port_select);
//void dag45ge_process_token_routine(dag_card_ref_t card_ref, int token, const char* text, int lval, int port_select);
void dag62se_process_token_routine(dag_card_ref_t card_ref, int token, const char* text, int lval, int port_select);
void dag70ge_process_token_routine(dag_card_ref_t card_ref, int token, const char* text, int lval, int port_select);
void dag37d_process_token_routine(dag_card_ref_t card_ref, int token, const char* text, int lval, int port_select);
//void dag82x_process_token_routine(dag_card_ref_t card_ref, int token, const char* text, int lval, int port_select);
//void dag45z_process_token_routine(dag_card_ref_t card_ref, int token, const char* text, int lval, int port_select);
//void dag82z_process_token_routine(dag_card_ref_t card_ref, int token, const char* text, int lval, int port_select);
void dagx_process_token_routine(dag_card_ref_t card_ref, int token, const char* text, int lval, int port_select);
void token_proc_init();
void token_proc_add_token(token_component_map_t* tc_map);
void token_proc_dispose();
void token_proc_set_default_on_reset(uint8_t val);
#endif

