#ifndef PROCESS_CMDLINE_H
#define PROCESS_CMDLINE_H

#include "dagclarg.h"
#include "dag_config.h"
enum
{
    FUNC_NONE           = 0x00,
    FUNC_FIRST          = 0x01,
    FUNC_DO_CONFIG      = 0x01,
    FUNC_PRINT_CONFIG   = 0x02,
    FUNC_DEFAULT        = FUNC_PRINT_CONFIG,
    FUNC_PRINT_INFO     = 0x04,
    FUNC_LAST           = 0x08
};

enum
{
    INFO_NONE          = 0x00,
    INFO_FIRST         = 0x01,
    INFO_STATS         = 0x01,
    INFO_EXT_STATS     = 0x02,
    INFO_EXT_HI_STATS  = 0x04,
    INFO_EXT_LO_STATS  = 0x08,
    INFO_COUNTERS      = 0x10,
    INFO_TEMPERATURE   = 0x20,
    INFO_TX_STATISTICS = 0x40,
    INFO_TREE	       = 0x80,
    INFO_UNIV_COUNTERS = 0x100,
    INFO_VOLTAGE       = 0x200,
    INFO_LAST          = 0x400
};
typedef struct dagconfigure_options_t dagconfigure_options_t;

const char* get_dagname(void);
void dagconfigure_add_cmdline_options(dagconfigure_options_t* options);
int process_cmdline_options(dagconfigure_options_t* options, int argc, const char** const argv);
const char* options_get_filename(const dagconfigure_options_t* options);
const char* options_get_connection_config_filename(const dagconfigure_options_t* options);
int options_get_repeat_interval(dagconfigure_options_t* options);
const char** options_get_configure_string(const dagconfigure_options_t* options);
dagconfigure_options_t* dagconfigure_options_init(int argc, const char** const argv);
void dagconfigure_options_dispose(dagconfigure_options_t* options);
int options_get_configure_string_count(const dagconfigure_options_t* options);
int options_get_verbose(const dagconfigure_options_t* options);
int options_get_port_select(const dagconfigure_options_t* options);
int options_get_verbosity_level(const dagconfigure_options_t* options);
int options_get_func(const dagconfigure_options_t* options);
int options_get_info(const dagconfigure_options_t* options);

#endif

