#ifndef DAG_CAT_INCLUDES_H
#define DAG_CAT_INCLUDES_H

#include "dag_platform.h"
/** 
	 * dagcat  rule structure 
	 * this structure will be returned after each rule scanned 
	 * 
	 */
typedef struct dagcat_config_rule_s* dagcat_config_rule_p;
typedef struct dagcat_config_rule_s {
#if 0    
/* hash value */
    struct  { 
        uint8_t data;
        uint8_t mask;
    } hash_value;
    /* color value */
    struct  { 
        uint16_t data;
        uint16_t  mask;
    } color_value;
    /* iface */
    struct  { 
        uint8_t data;
        uint8_t mask; 
    } iface_value ;
    /* destination stream */
    struct  { 
        uint8_t data;
        uint8_t mask; 
    } stream_value ;
#endif
/* hash value */
    uint32_t hash_from;
    uint32_t hash_to;
    /* color value */
    uint32_t color_from;
    uint32_t  color_to;
    /* iface */
    uint32_t iface_from;
    uint32_t iface_to; 
    /* stream_value is bit encoded. nth bit for the nth rx stream */
    uint64_t stream_value;

    uint8_t is_color_inverted;
    uint8_t is_iface_inverted;
    uint8_t is_hash_inverted;
    /* pointer to the next rule */
    dagcat_config_rule_p next;
} dagcat_config_rule_t;

typedef struct dagcat_capabilities_s {
    uint32_t cat_max_color;
    uint32_t cat_max_hash;
    uint32_t cat_max_iface;
    uint32_t cat_max_stream; /* number of output bits*/
    uint8_t  is_binary_encoded;
}dagcat_capabilities_t;

/** common scanners results for the protocol */
#define T_ERROR -1		/**> Error while the scanner recognizes the rule common */
#define T_ERROR_PARAMETER -2 	/**> Error while the scanner recognises the parameters  */
#define T_ERROR_CONVERT -3 	/**> Error while the scanner convert the parameter  */

#define T_RULE_CONTINUE 2	/**> Recognized a multi line rule the result is partial and has to continue on the new line */
#define T_RULE_DONE 1		/**> the rule has been recognised and the filter varibale is finished */

/* variable to be used in parser */
extern dagcat_config_rule_t dagcat_config_rule;

/* function proto types */
int dagcat_get_current_line_number();
int dagcat_scanner_set_stdout(FILE *scanner_out);

#endif //DAG_CAT_INCLUDES_H
