/*
 * Copyright (c) 2002-2007 Endace Technology Ltd, Hamilton, New Zealand.
 * All rights reserved.
 *
 * This source code is proprietary to Endace Technology Limited and no part
 * of it may be redistributed, published or disclosed except as outlined in
 * the written contract supplied with this product.
 *
 * $Id: h20s_tests.h 15597 2012-03-28 22:21:32Z jomi.gregory $
 */

#ifndef H20S_TESTS_H
#define H20S_TESTS_H

#include "dagbits_plugin.h"

/* Entry points for this plugin */

/*  Initialize the plugin. 
 *  Supports: -c testcase, -t test
 */
int h20s_tests_init(char *params[], int param_cnt, global_params_t *global_params, test_printf f);

/* Run the selected test and test case on the supplied record */
int h20s_tests_run(char *rec, int len, char* lastpkt, struct_protocol_t prot, uint64_t rec_cnt);

/* Print the per-record error messge */
int h20s_tests_err_msg(char *buf, int size);

/* Print the per-test error messge */
int h20s_tests_final_msg(char *buf, int size);

/* Clean up after the capture has finished */
int h20s_tests_cleanup();

#endif
