/*
 * Copyright (c) 2005 Endace Technology Ltd, Hamilton, New Zealand.
 * All rights reserved.
 *
 * This source code is proprietary to Endace Technology Limited and no part
 * of it may be redistributed, published or disclosed except as outlined in
 * the written contract supplied with this product.
 *
 * $Id: qa2225_framer_component.h 15929 2012-08-19 23:34:19Z karthik.sharma $
 */

#ifndef QA2225_COMPONENT_H
#define QA2225_COMPONENT_H


ComponentPtr
qa2225_get_new_port(DagCardPtr card, uint32_t index);

dag_err_t 
load_amcc_framer_firmware(ComponentPtr component,char *filename,line_rate_t line_rate);

uint8_t ten_gigabits_firmware_loaded();

#define QT_MODE_REGISTER                   0xc301
#define QT_PMA_VENDOR_SPECIFIC_REGISTER_1  0xc001
#define QT_WIS_STATUS_REGISTER_3           0x0021
#define QT_PMA_PMD_STATUS_REGISTER_2       0x0008
#define QT_PMA_PMD_STATUS_REGISTER_1       0x0001
#define QT_PMA_PMD_CONTROL_REGISTER_2      0x0007
#define QT_XGXS_VENDOR_SPECIFIC_REGISTER_1 0xC000
#define QT_PMA_PMD_CONTROL_REGISTER_1      0x0000
#define QT_PCS_STATUS_REGISTER_1           0x0001
#define QT2225_FRX_VCOSEL                  0xf037
#define QT2225_FTX_VCOFREQ_SEL             0xf052
#endif
