/*
 * Copyright (c) 2005 Endace Technology Ltd, Hamilton, New Zealand.
 * All rights reserved.
 *
 * This source code is proprietary to Endace Technology Limited and no part
 * of it may be redistributed, published or disclosed except as outlined in
 * the written contract supplied with this product.
 *
 *
 * This component is used by infiniband cards.
 *
 * $Id: framer_component.c 11366 2009-06-15 03:29:42Z karthik $
 */

#include "dagutil.h"
#include "../include/attribute.h"
#include "../include/util/set.h"
#include "../include/card.h"
#include "../include/cards/card_initialization.h"
#include "../include/component.h"
#include "../include/util/utility.h"
#include "../include/cards/common_dagx_constants.h"
#include "../include/util/enum_string_table.h"
#include "../include/components/counter_component.h"
#include "../include/components/counters_interface_component.h"
#include "../include/cards/dag71s_impl.h"
#include "../include/attribute_factory.h"
#include "../include/create_attribute.h"
#include "../include/components/cat_component.h"
#include "../include/dag_attribute_codes.h"
#include "../include/attribute_types.h" 

static void framer_dispose(ComponentPtr component);
static void framer_reset(ComponentPtr component);
static void framer_default(ComponentPtr component);
static int framer_post_initialize(ComponentPtr component);

AttributePtr framer_pll_detect_attribute(GenericReadWritePtr grw,const uint32_t *bit_masks,uint32_t len);
static void*pll_detect_get_value(AttributePtr attribute);

AttributePtr framer_gtp_reset_attribute(GenericReadWritePtr grw,const uint32_t *bit_masks,uint32_t len);
static void* gtp_reset_get_value(AttributePtr attribute);

/*This is only a temperory implementation till the latch and clear / Clear on Read version of this attribute is implemented by the FW*/
static void*rx_paket_error_latch_get_value(AttributePtr attribute);

typedef struct
{
    uint32_t mIndex;
} framer_state_t;

typedef enum
{
	diagnostic_register_0                              = 0x00,
	diagnostic_register_1                              = 0x04,
	reset_register                                     = 0x08,
	polarity_powerdown_register                        = 0x0C,
	driver_register                                    = 0x10,
	packet_diagnostic_control_register                 = 0x14,
	packet_diagnostic_status_register                  = 0x18,
	encoder_status_register                            = 0x1C,
	channel_bonding_and_byte_alignment_status_register = 0x20,
	rx_byte_counter                                    = 0x24,
	rx_packet_counter				   = 0x28				
}infiniband_front_end_register_offset; 
	
/* Infiniband framer attribute definition Array */
Attribute_t infiniband_front_end_attr[]=
{
#ifdef ENDACE_LABS /*Diagnostic Register 0 Start*/	
    {
        /* Name */                 "loopback_0",
        /* Attribute Code */       kUint32AttributeLoopBackZero,
        /* Attribute Type */       kAttributeUint32,
        /* Description */          "Lane Zero LoopBack.",
        /* Config-Status */        kDagAttrConfig,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               diagnostic_register_0,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT0| BIT1 | BIT2,
        /* Default Value */        0,
        /* SetValue */             attribute_uint32_set_value,
	/* GetValue */             attribute_uint32_get_value,
	/* SetToString */          attribute_uint32_to_string,
	/* SetFromString */        attribute_uint32_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
    },
    {
        /* Name */                 "loopback_1",
        /* Attribute Code */       kUint32AttributeLoopBackOne,
        /* Attribute Type */       kAttributeUint32,
        /* Description */          "Lane One LoopBack.",
        /* Config-Status */        kDagAttrConfig,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               diagnostic_register_0,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT3| BIT4 | BIT5,
        /* Default Value */        0,
        /* SetValue */             attribute_uint32_set_value,
	/* GetValue */             attribute_uint32_get_value,
	/* SetToString */          attribute_uint32_to_string,
	/* SetFromString */        attribute_uint32_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
    },
    {
        /* Name */                 "loopback_2",
        /* Attribute Code */       kUint32AttributeLoopBackTwo,
        /* Attribute Type */       kAttributeUint32,
        /* Description */          "Lane Two LoopBack.",
        /* Config-Status */        kDagAttrConfig,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               diagnostic_register_0,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT6| BIT7 | BIT8,
        /* Default Value */        0,
        /* SetValue */             attribute_uint32_set_value,
	/* GetValue */             attribute_uint32_get_value,
	/* SetToString */          attribute_uint32_to_string,
	/* SetFromString */        attribute_uint32_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "loopback_3",
        /* Attribute Code */       kUint32AttributeLoopBackThree,
        /* Attribute Type */       kAttributeUint32,
        /* Description */          "Lane Three LoopBack.",
        /* Config-Status */        kDagAttrConfig,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               diagnostic_register_0,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT9| BIT10 | BIT11,
        /* Default Value */        0,
        /* SetValue */             attribute_uint32_set_value,
	/* GetValue */             attribute_uint32_get_value,
	/* SetToString */          attribute_uint32_to_string,
	/* SetFromString */        attribute_uint32_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "lane_0_rx_prbs_checker",
        /* Attribute Code */       kUint32AttributeLaneZeroRxPrbsChecker,
        /* Attribute Type */       kAttributeUint32,
        /* Description */          "Lane Zero Rx PRBS Checker.",
        /* Config-Status */        kDagAttrConfig,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               diagnostic_register_0,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT12 | BIT13,
        /* Default Value */        0,
        /* SetValue */             attribute_uint32_set_value,
	/* GetValue */             attribute_uint32_get_value,
	/* SetToString */          attribute_uint32_to_string,
	/* SetFromString */        attribute_uint32_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "lane_1_rx_prbs_checker",
        /* Attribute Code */       kUint32AttributeLaneOneRxPrbsChecker,
        /* Attribute Type */       kAttributeUint32,
        /* Description */          "Lane One Rx PRBS Checker.",
        /* Config-Status */        kDagAttrConfig,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               diagnostic_register_0,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT14 | BIT15,
        /* Default Value */        0,
        /* SetValue */             attribute_uint32_set_value,
	/* GetValue */             attribute_uint32_get_value,
	/* SetToString */          attribute_uint32_to_string,
	/* SetFromString */        attribute_uint32_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "lane_2_rx_prbs_checker",
        /* Attribute Code */       kUint32AttributeLaneTwoRxPrbsChecker,
        /* Attribute Type */       kAttributeUint32,
        /* Description */          "Lane Two Rx PRBS Checker.",
        /* Config-Status */        kDagAttrConfig,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               diagnostic_register_0,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT16 | BIT17,
        /* Default Value */        0,
        /* SetValue */             attribute_uint32_set_value,
	/* GetValue */             attribute_uint32_get_value,
	/* SetToString */          attribute_uint32_to_string,
	/* SetFromString */        attribute_uint32_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "lane_3_rx_prbs_checker",
        /* Attribute Code */       kUint32AttributeLaneThreeRxPrbsChecker,
        /* Attribute Type */       kAttributeUint32,
        /* Description */          "Lane Three Rx PRBS Checker.",
        /* Config-Status */        kDagAttrConfig,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               diagnostic_register_0,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT18 | BIT19,
        /* Default Value */        0,
        /* SetValue */             attribute_uint32_set_value,
	/* GetValue */             attribute_uint32_get_value,
	/* SetToString */          attribute_uint32_to_string,
	/* SetFromString */        attribute_uint32_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "lane_0_tx_prbs_generation_control",
        /* Attribute Code */       kUint32AttributeLaneZeroTxPrbsGenerationControl,
        /* Attribute Type */       kAttributeUint32,
        /* Description */          "Lane Zero Tx PRBS Generation Control.",
        /* Config-Status */        kDagAttrConfig,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               diagnostic_register_0,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT20 | BIT21,
        /* Default Value */        0,
        /* SetValue */             attribute_uint32_set_value,
	/* GetValue */             attribute_uint32_get_value,
	/* SetToString */          attribute_uint32_to_string,
	/* SetFromString */        attribute_uint32_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "lane_1_tx_prbs_generation_control",
        /* Attribute Code */       kUint32AttributeLaneOneTxPrbsGenerationControl,
        /* Attribute Type */       kAttributeUint32,
        /* Description */          "Lane One Tx PRBS Generation Control.",
        /* Config-Status */        kDagAttrConfig,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               diagnostic_register_0,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT22 | BIT23,
        /* Default Value */        0,
        /* SetValue */             attribute_uint32_set_value,
	/* GetValue */             attribute_uint32_get_value,
	/* SetToString */          attribute_uint32_to_string,
	/* SetFromString */        attribute_uint32_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "lane_2_tx_prbs_generation_control",
        /* Attribute Code */       kUint32AttributeLaneTwoTxPrbsGenerationControl,
        /* Attribute Type */       kAttributeUint32,
        /* Description */          "Lane Two Tx PRBS Generation Control.",
        /* Config-Status */        kDagAttrConfig,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               diagnostic_register_0,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT24 | BIT25,
        /* Default Value */        0,
        /* SetValue */             attribute_uint32_set_value,
	/* GetValue */             attribute_uint32_get_value,
	/* SetToString */          attribute_uint32_to_string,
	/* SetFromString */        attribute_uint32_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "lane_3_tx_prbs_generation_control",
        /* Attribute Code */       kUint32AttributeLaneThreeTxPrbsGenerationControl,
        /* Attribute Type */       kAttributeUint32,
        /* Description */          "Lane Three Tx PRBS Generation Control.",
        /* Config-Status */        kDagAttrConfig,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               diagnostic_register_0,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT26 | BIT27,
        /* Default Value */        0,
        /* SetValue */             attribute_uint32_set_value,
	/* GetValue */             attribute_uint32_get_value,
	/* SetToString */          attribute_uint32_to_string,
	/* SetFromString */        attribute_uint32_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "lane_0_prbs_error_counter_reset",
        /* Attribute Code */       kBooleanAttributeLaneZeroPrbsErrorCounterReset,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Lane Zero Prbs Error Counter Reset.",
        /* Config-Status */        kDagAttrConfig,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               diagnostic_register_0,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT28,
        /* Default Value */        0,
        /* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "lane_1_prbs_error_counter_reset",
        /* Attribute Code */       kBooleanAttributeLaneOnePrbsErrorCounterReset,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Lane Zero Prbs Error Counter Reset.",
        /* Config-Status */        kDagAttrConfig,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               diagnostic_register_0,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT29,
        /* Default Value */        0,
        /* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "lane_2_prbs_error_counter_reset",
        /* Attribute Code */       kBooleanAttributeLaneTwoPrbsErrorCounterReset,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Lane Zero Prbs Error Counter Reset.",
        /* Config-Status */        kDagAttrConfig,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               diagnostic_register_0,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT30,
        /* Default Value */        0,
        /* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "lane_3_prbs_error_counter_reset",
        /* Attribute Code */       kBooleanAttributeLaneThreePrbsErrorCounterReset,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Lane Zero Prbs Error Counter Reset.",
        /* Config-Status */        kDagAttrConfig,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               diagnostic_register_0,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT31,
        /* Default Value */        0,
        /* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
#endif /*Diagnostic_Register_0_End*/
    /*Diagnostic Register 1 Read Only - Exposed to the user*/
   {
        /* Name */                 "lane_0_prbs_error",
        /* Attribute Code */       kBooleanAttributeLaneZeroPrbsError,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Lane Zero Prbs Error.",
        /* Config-Status */        kDagAttrStatus,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               diagnostic_register_1,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT0,
        /* Default Value */        0,
	/* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "lane_1_prbs_error",
        /* Attribute Code */       kBooleanAttributeLaneOnePrbsError,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Lane One Prbs Error.",
        /* Config-Status */        kDagAttrStatus,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               diagnostic_register_1,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT1,
        /* Default Value */        0,
	/* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "lane_2_prbs_error",
        /* Attribute Code */       kBooleanAttributeLaneTwoPrbsError,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Lane Two Prbs Error.",
        /* Config-Status */        kDagAttrStatus,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               diagnostic_register_1,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT2,
        /* Default Value */        0,
	/* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "lane_3_prbs_error",
        /* Attribute Code */       kBooleanAttributeLaneThreePrbsError,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Lane Three Prbs Error.",
        /* Config-Status */        kDagAttrStatus,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               diagnostic_register_1,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT3,
        /* Default Value */        0,
	/* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "pll_detect_zero",
        /* Attribute Code */       kBooleanAttributePllDetectZero,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Phase Locked Loop Detect Zero.",
        /* Config-Status */        kDagAttrStatus,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               diagnostic_register_1,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT4,
        /* Default Value */        0,
	/* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "pll_detect_one",
        /* Attribute Code */       kBooleanAttributePllDetectOne,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Phase Locked Loop Detect One.",
        /* Config-Status */        kDagAttrStatus,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               diagnostic_register_1,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT5,
        /* Default Value */        0,
	/* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "gtp_reset_done_zero",
        /* Attribute Code */       kBooleanAttributeGTPResetDoneZero,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "GTP Reset Finished For Lane Zero.",
        /* Config-Status */        kDagAttrStatus,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               diagnostic_register_1,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT6,
        /* Default Value */        0,
	/* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "gtp_reset_done_one",
        /* Attribute Code */       kBooleanAttributeGTPResetDoneOne,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "GTP Reset Finished For Lane One.",
        /* Config-Status */        kDagAttrStatus,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               diagnostic_register_1,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT7,
        /* Default Value */        0,
	/* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "gtp_reset_done_two",
        /* Attribute Code */       kBooleanAttributeGTPResetDoneTwo,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "GTP Reset Finished For Lane Two.",
        /* Config-Status */        kDagAttrStatus,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               diagnostic_register_1,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT8,
        /* Default Value */        0,
	/* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "gtp_reset_done_three",
        /* Attribute Code */       kBooleanAttributeGTPResetDoneThree,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "GTP Reset Finished For Lane Three.",
        /* Config-Status */        kDagAttrStatus,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               diagnostic_register_1,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT9,
        /* Default Value */        0,
	/* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "lane_zero_rx_buffer_status",
        /* Attribute Code */       kUint32AttributeRxBufferStatZero,
        /* Attribute Type */       kAttributeUint32,
        /* Description */          "Rx Buffer Status for Lane Zero.",
        /* Config-Status */        kDagAttrStatus,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               diagnostic_register_1,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT10 | BIT11 | BIT12,
        /* Default Value */        0,
	/* SetValue */             attribute_uint32_set_value,
	/* GetValue */             attribute_uint32_get_value,
	/* SetToString */          attribute_uint32_to_string,
	/* SetFromString */        attribute_uint32_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "lane_one_rx_buffer_status",
        /* Attribute Code */       kUint32AttributeRxBufferStatOne,
        /* Attribute Type */       kAttributeUint32,
        /* Description */          "Rx Buffer Status for Lane One.",
        /* Config-Status */        kDagAttrStatus,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               diagnostic_register_1,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT13 | BIT14 | BIT15,
        /* Default Value */        0,
	/* SetValue */             attribute_uint32_set_value,
	/* GetValue */             attribute_uint32_get_value,
	/* SetToString */          attribute_uint32_to_string,
	/* SetFromString */        attribute_uint32_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "lane_two_rx_buffer_status",
        /* Attribute Code */       kUint32AttributeRxBufferStatTwo,
        /* Attribute Type */       kAttributeUint32,
        /* Description */          "Rx Buffer Status for Lane Two.",
        /* Config-Status */        kDagAttrStatus,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               diagnostic_register_1,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT16 | BIT17 | BIT18,
        /* Default Value */        0,
	/* SetValue */             attribute_uint32_set_value,
	/* GetValue */             attribute_uint32_get_value,
	/* SetToString */          attribute_uint32_to_string,
	/* SetFromString */        attribute_uint32_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "lane_three_rx_buffer_status",
        /* Attribute Code */       kUint32AttributeRxBufferStatThree,
        /* Attribute Type */       kAttributeUint32,
        /* Description */          "Rx Buffer Status for Lane Three.",
        /* Config-Status */        kDagAttrStatus,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               diagnostic_register_1,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT19 | BIT20 | BIT21,
        /* Default Value */        0,
	/* SetValue */             attribute_uint32_set_value,
	/* GetValue */             attribute_uint32_get_value,
	/* SetToString */          attribute_uint32_to_string,
	/* SetFromString */        attribute_uint32_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "lane_zero_rx_byte_align",
        /* Attribute Code */       kBooleanAttributeRxByteAlignZero,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Rx Byte Align for Lane Zero.",
        /* Config-Status */        kDagAttrStatus,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               diagnostic_register_1,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT22,
        /* Default Value */        0,
	/* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "lane_one_rx_byte_align",
        /* Attribute Code */       kBooleanAttributeRxByteAlignOne,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Rx Byte Align for Lane One.",
        /* Config-Status */        kDagAttrStatus,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               diagnostic_register_1,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT23,
        /* Default Value */        0,
	/* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "lane_two_rx_byte_align",
        /* Attribute Code */       kBooleanAttributeRxByteAlignTwo,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Rx Byte Align for Lane Two.",
        /* Config-Status */        kDagAttrStatus,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               diagnostic_register_1,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT24,
        /* Default Value */        0,
	/* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "lane_three_rx_byte_align",
        /* Attribute Code */       kBooleanAttributeRxByteAlignThree,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Rx Byte Align for Lane Three.",
        /* Config-Status */        kDagAttrStatus,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               diagnostic_register_1,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT25,
        /* Default Value */        0,
	/* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "lane_zero_rx_channel_align",
        /* Attribute Code */       kBooleanAttributeRxChannelAlignZero,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Rx Channel Align for Lane Zero.",
        /* Config-Status */        kDagAttrStatus,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               diagnostic_register_1,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT26,
        /* Default Value */        0,
	/* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "lane_one_rx_channel_align",
        /* Attribute Code */       kBooleanAttributeRxChannelAlignOne,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Rx Channel Align for Lane One.",
        /* Config-Status */        kDagAttrStatus,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               diagnostic_register_1,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT27,
        /* Default Value */        0,
	/* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "lane_two_rx_channel_align",
        /* Attribute Code */       kBooleanAttributeRxChannelAlignTwo,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Rx Channel Align for Lane Two.",
        /* Config-Status */        kDagAttrStatus,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               diagnostic_register_1,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT28,
        /* Default Value */        0,
	/* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "lane_three_rx_channel_align",
        /* Attribute Code */       kBooleanAttributeRxChannelAlignThree,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Rx Channel Align for Lane Three.",
        /* Config-Status */        kDagAttrStatus,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               diagnostic_register_1,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT29,
        /* Default Value */        0,
	/* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "rx_byte_align",
        /* Attribute Code */       kBooleanAttributeRxByteAlign,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Rx Byte Align for all Four Lanes.",
        /* Config-Status */        kDagAttrStatus,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               diagnostic_register_1,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT30,
        /* Default Value */        0,
	/* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "rx_channel_align",
        /* Attribute Code */       kBooleanAttributeRxChannelAlign,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Channel Bonding for all four lanes..",
        /* Config-Status */        kDagAttrStatus,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               diagnostic_register_1,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT31,
        /* Default Value */        0,
	/* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   /*Reset Register R/W*/
   {
        /* Name */                 "gtp_reset",
        /* Attribute Code */       kUint32AttributeGtpReset,
        /* Attribute Type */       kAttributeUint32,
        /* Description */          "GTP Reset for all four lanes.",
        /* Config-Status */        kDagAttrConfig,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               reset_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT0 | BIT1,
        /* Default Value */        0,
        /* SetValue */             attribute_uint32_set_value,
	/* GetValue */             attribute_uint32_get_value,
	/* SetToString */          attribute_uint32_to_string,
	/* SetFromString */        attribute_uint32_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "lane_0_cdr_reset",
        /* Attribute Code */       kBooleanAttributeCdrZeroReset,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "CDR Lane Zero reset.",
        /* Config-Status */        kDagAttrConfig,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               reset_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT2,
        /* Default Value */        0,
        /* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "lane_1_cdr_reset",
        /* Attribute Code */       kBooleanAttributeCdrOneReset,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "CDR Lane One reset.",
        /* Config-Status */        kDagAttrConfig,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               reset_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT3,
        /* Default Value */        0,
        /* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "lane_2_cdr_reset",
        /* Attribute Code */       kBooleanAttributeCdrTwoReset,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "CDR Lane Two reset.",
        /* Config-Status */        kDagAttrConfig,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               reset_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT4,
        /* Default Value */        0,
        /* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "lane_3_cdr_reset",
        /* Attribute Code */       kBooleanAttributeCdrThreeReset,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "CDR Lane Three reset.",
        /* Config-Status */        kDagAttrConfig,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               reset_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT5,
        /* Default Value */        0,
        /* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "lane_0_rx_elastic_buffer_reset",
        /* Attribute Code */       kBooleanAttributeLaneZeroRxBufferReset,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Lane 0 Recieve Elastic Buffer Reset.",
        /* Config-Status */        kDagAttrConfig,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               reset_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT6,
        /* Default Value */        0,
        /* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "lane_1_rx_elastic_buffer_reset",
        /* Attribute Code */       kBooleanAttributeLaneOneRxBufferReset,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Lane 1 Recieve Elastic Buffer Reset.",
        /* Config-Status */        kDagAttrConfig,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               reset_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT7,
        /* Default Value */        0,
        /* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "lane_2_rx_elastic_buffer_reset",
        /* Attribute Code */       kBooleanAttributeLaneTwoRxBufferReset,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Lane 2 Recieve Elastic Buffer Reset.",
        /* Config-Status */        kDagAttrConfig,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               reset_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT8,
        /* Default Value */        0,
        /* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "lane_3_rx_elastic_buffer_reset",
        /* Attribute Code */       kBooleanAttributeLaneThreeRxBufferReset,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Lane 3 Recieve Elastic Buffer Reset.",
        /* Config-Status */        kDagAttrConfig,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               reset_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT9,
        /* Default Value */        0,
        /* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
#ifdef ENDACE_LABS /*Rx / Tx Polarity & PowerDown Register*/
   {
        /* Name */                 "lane_0_rx_polarity_port",
        /* Attribute Code */       kBooleanAttributeLaneZeroRxPolarityPort,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Lane 0 Recieve Polarity Port.",
        /* Config-Status */        kDagAttrConfig,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               polarity_powerdown_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT0,
        /* Default Value */        0,
        /* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "lane_1_rx_polarity_port",
        /* Attribute Code */       kBooleanAttributeLaneOneRxPolarityPort,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Lane 1 Recieve Polarity Port.",
        /* Config-Status */        kDagAttrConfig,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               polarity_powerdown_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT1,
        /* Default Value */        0,
        /* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "lane_2_rx_polarity_port",
        /* Attribute Code */       kBooleanAttributeLaneTwoRxPolarityPort,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Lane 2 Recieve Polarity Port.",
        /* Config-Status */        kDagAttrConfig,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               polarity_powerdown_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT2,
        /* Default Value */        0,
        /* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "lane_3_rx_polarity_port",
        /* Attribute Code */       kBooleanAttributeLaneThreeRxPolarityPort,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Lane 3 Recieve Polarity Port.",
        /* Config-Status */        kDagAttrConfig,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               polarity_powerdown_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT3,
        /* Default Value */        0,
        /* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "lane_0_tx_polarity_port",
        /* Attribute Code */       kBooleanAttributeLaneZeroTxPolarityPort,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Lane 0 Transmit Polarity Port.",
        /* Config-Status */        kDagAttrConfig,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               polarity_powerdown_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT4,
        /* Default Value */        0,
        /* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "lane_1_tx_polarity_port",
        /* Attribute Code */       kBooleanAttributeLaneOneTxPolarityPort,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Lane 1 Transmit Polarity Port.",
        /* Config-Status */        kDagAttrConfig,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               polarity_powerdown_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT5,
        /* Default Value */        0,
        /* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "lane_2_tx_polarity_port",
        /* Attribute Code */       kBooleanAttributeLaneTwoTxPolarityPort,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Lane 2 Transmit Polarity Port.",
        /* Config-Status */        kDagAttrConfig,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               polarity_powerdown_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT6,
        /* Default Value */        0,
        /* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "lane_3_tx_polarity_port",
        /* Attribute Code */       kBooleanAttributeLaneThreeTxPolarityPort,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Lane 3 Transmit Polarity Port.",
        /* Config-Status */        kDagAttrConfig,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               polarity_powerdown_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT7,
        /* Default Value */        0,
        /* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "lane_0_rx_power_down",
        /* Attribute Code */       kUint32AttributeLaneZeroRxPowerDown,
        /* Attribute Type */       kAttributeUint32,
        /* Description */          "Lane 0 Recieve Power Down.",
        /* Config-Status */        kDagAttrConfig,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               polarity_powerdown_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT8 | BIT9,
        /* Default Value */        0,
        /* SetValue */             attribute_uint32_set_value,
	/* GetValue */             attribute_uint32_get_value,
	/* SetToString */          attribute_uint32_to_string,
	/* SetFromString */        attribute_uint32_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "lane_1_rx_power_down",
        /* Attribute Code */       kUint32AttributeLaneOneRxPowerDown,
        /* Attribute Type */       kAttributeUint32,
        /* Description */          "Lane 1 Recieve Power Down.",
        /* Config-Status */        kDagAttrConfig,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               polarity_powerdown_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT10 | BIT11,
        /* Default Value */        0,
        /* SetValue */             attribute_uint32_set_value,
	/* GetValue */             attribute_uint32_get_value,
	/* SetToString */          attribute_uint32_to_string,
	/* SetFromString */        attribute_uint32_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "lane_2_rx_power_down",
        /* Attribute Code */       kUint32AttributeLaneTwoRxPowerDown,
        /* Attribute Type */       kAttributeUint32,
        /* Description */          "Lane 2 Recieve Power Down.",
        /* Config-Status */        kDagAttrConfig,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               polarity_powerdown_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT12 | BIT13,
        /* Default Value */        0,
        /* SetValue */             attribute_uint32_set_value,
	/* GetValue */             attribute_uint32_get_value,
	/* SetToString */          attribute_uint32_to_string,
	/* SetFromString */        attribute_uint32_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "lane_3_rx_power_down",
        /* Attribute Code */       kUint32AttributeLaneThreeRxPowerDown,
        /* Attribute Type */       kAttributeUint32,
        /* Description */          "Lane 3 Recieve Power Down.",
        /* Config-Status */        kDagAttrConfig,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               polarity_powerdown_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT14 | BIT15,
        /* Default Value */        0,
        /* SetValue */             attribute_uint32_set_value,
	/* GetValue */             attribute_uint32_get_value,
	/* SetToString */          attribute_uint32_to_string,
	/* SetFromString */        attribute_uint32_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "lane_0_tx_power_down",
        /* Attribute Code */       kUint32AttributeLaneZeroTxPowerDown,
        /* Attribute Type */       kAttributeUint32,
        /* Description */          "Lane 0 Transmit Power Down.",
        /* Config-Status */        kDagAttrConfig,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               polarity_powerdown_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT16 | BIT17,
        /* Default Value */        0,
        /* SetValue */             attribute_uint32_set_value,
	/* GetValue */             attribute_uint32_get_value,
	/* SetToString */          attribute_uint32_to_string,
	/* SetFromString */        attribute_uint32_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "lane_1_tx_power_down",
        /* Attribute Code */       kUint32AttributeLaneOneTxPowerDown,
        /* Attribute Type */       kAttributeUint32,
        /* Description */          "Lane 1 Transmit Power Down.",
        /* Config-Status */        kDagAttrConfig,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               polarity_powerdown_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT18 | BIT19,
        /* Default Value */        0,
        /* SetValue */             attribute_uint32_set_value,
	/* GetValue */             attribute_uint32_get_value,
	/* SetToString */          attribute_uint32_to_string,
	/* SetFromString */        attribute_uint32_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "lane_2_tx_power_down",
        /* Attribute Code */       kUint32AttributeLaneTwoTxPowerDown,
        /* Attribute Type */       kAttributeUint32,
        /* Description */          "Lane 2 Transmit Power Down.",
        /* Config-Status */        kDagAttrConfig,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               polarity_powerdown_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT20 | BIT21,
        /* Default Value */        0,
        /* SetValue */             attribute_uint32_set_value,
	/* GetValue */             attribute_uint32_get_value,
	/* SetToString */          attribute_uint32_to_string,
	/* SetFromString */        attribute_uint32_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "lane_3_tx_power_down",
        /* Attribute Code */       kUint32AttributeLaneThreeTxPowerDown,
        /* Attribute Type */       kAttributeUint32,
        /* Description */          "Lane 3 Transmit Power Down.",
        /* Config-Status */        kDagAttrConfig,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               polarity_powerdown_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT22 | BIT23,
        /* Default Value */        0,
        /* SetValue */             attribute_uint32_set_value,
	/* GetValue */             attribute_uint32_get_value,
	/* SetToString */          attribute_uint32_to_string,
	/* SetFromString */        attribute_uint32_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   }, /*Tx Driver Register*/
   {
        /* Name */                 "lane_0_tx_diff_output_swing",
        /* Attribute Code */       kUint32AttributeLaneZeroTxDiffOutputSwing,
        /* Attribute Type */       kAttributeUint32,
        /* Description */          "Lane 0 Transmit Differential Output Swing.",
        /* Config-Status */        kDagAttrConfig,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               driver_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT0 | BIT1 | BIT2,
        /* Default Value */        0,
        /* SetValue */             attribute_uint32_set_value,
	/* GetValue */             attribute_uint32_get_value,
	/* SetToString */          attribute_uint32_to_string,
	/* SetFromString */        attribute_uint32_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "lane_1_tx_diff_output_swing",
        /* Attribute Code */       kUint32AttributeLaneOneTxDiffOutputSwing,
        /* Attribute Type */       kAttributeUint32,
        /* Description */          "Lane 1 Transmit Differential Output Swing.",
        /* Config-Status */        kDagAttrConfig,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               driver_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT3 | BIT4 | BIT5,
        /* Default Value */        0,
        /* SetValue */             attribute_uint32_set_value,
	/* GetValue */             attribute_uint32_get_value,
	/* SetToString */          attribute_uint32_to_string,
	/* SetFromString */        attribute_uint32_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "lane_2_tx_diff_output_swing",
        /* Attribute Code */       kUint32AttributeLaneTwoTxDiffOutputSwing,
        /* Attribute Type */       kAttributeUint32,
        /* Description */          "Lane 2 Transmit Differential Output Swing.",
        /* Config-Status */        kDagAttrConfig,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               driver_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT6 | BIT7 | BIT8,
        /* Default Value */        0,
        /* SetValue */             attribute_uint32_set_value,
	/* GetValue */             attribute_uint32_get_value,
	/* SetToString */          attribute_uint32_to_string,
	/* SetFromString */        attribute_uint32_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "lane_3_tx_diff_output_swing",
        /* Attribute Code */       kUint32AttributeLaneThreeTxDiffOutputSwing,
        /* Attribute Type */       kAttributeUint32,
        /* Description */          "Lane 3 Transmit Differential Output Swing.",
        /* Config-Status */        kDagAttrConfig,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               driver_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT9 | BIT10 | BIT11,
        /* Default Value */        0,
        /* SetValue */             attribute_uint32_set_value,
	/* GetValue */             attribute_uint32_get_value,
	/* SetToString */          attribute_uint32_to_string,
	/* SetFromString */        attribute_uint32_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "lane_0_tx_inhibit_data_tx",
        /* Attribute Code */       kBooleanAttributeLaneZeroInhibitDataTx,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Lane 0 Transmit Inhibit Data Tx.",
        /* Config-Status */        kDagAttrConfig,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               driver_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT12,
        /* Default Value */        0,
        /* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "lane_1_tx_inhibit_data_tx",
        /* Attribute Code */       kBooleanAttributeLaneOneInhibitDataTx,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Lane 1 Transmit Inhibit Data Tx.",
        /* Config-Status */        kDagAttrConfig,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               driver_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT13,
        /* Default Value */        0,
        /* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "lane_2_tx_inhibit_data_tx",
        /* Attribute Code */       kBooleanAttributeLaneTwoInhibitDataTx,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Lane 2 Transmit Inhibit Data Tx.",
        /* Config-Status */        kDagAttrConfig,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               driver_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT14,
        /* Default Value */        0,
        /* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "lane_3_tx_inhibit_data_tx",
        /* Attribute Code */       kBooleanAttributeLaneThreeInhibitDataTx,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Lane 3 Transmit Inhibit Data Tx.",
        /* Config-Status */        kDagAttrConfig,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               driver_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT15,
        /* Default Value */        0,
        /* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "lane_0_tx_drive_strength",
        /* Attribute Code */       kUint32AttributeLaneZeroTxDriveStrength,
        /* Attribute Type */       kAttributeUint32,
        /* Description */          "Lane 0 Transmit Drive Strength.",
        /* Config-Status */        kDagAttrConfig,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               driver_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT16 | BIT17 | BIT18,
        /* Default Value */        0,
        /* SetValue */             attribute_uint32_set_value,
	/* GetValue */             attribute_uint32_get_value,
	/* SetToString */          attribute_uint32_to_string,
	/* SetFromString */        attribute_uint32_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "lane_1_tx_drive_strength",
        /* Attribute Code */       kUint32AttributeLaneOneTxDriveStrength,
        /* Attribute Type */       kAttributeUint32,
        /* Description */          "Lane 1 Transmit Drive Strength.",
        /* Config-Status */        kDagAttrConfig,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               driver_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT19 | BIT20 | BIT21,
        /* Default Value */        0,
        /* SetValue */             attribute_uint32_set_value,
	/* GetValue */             attribute_uint32_get_value,
	/* SetToString */          attribute_uint32_to_string,
	/* SetFromString */        attribute_uint32_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "lane_2_tx_drive_strength",
        /* Attribute Code */       kUint32AttributeLaneTwoTxDriveStrength,
        /* Attribute Type */       kAttributeUint32,
        /* Description */          "Lane 2 Transmit Drive Strength.",
        /* Config-Status */        kDagAttrConfig,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               driver_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT22 | BIT23 | BIT24,
        /* Default Value */        0,
        /* SetValue */             attribute_uint32_set_value,
	/* GetValue */             attribute_uint32_get_value,
	/* SetToString */          attribute_uint32_to_string,
	/* SetFromString */        attribute_uint32_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "lane_3_tx_drive_strength",
        /* Attribute Code */       kUint32AttributeLaneThreeTxDriveStrength,
        /* Attribute Type */       kAttributeUint32,
        /* Description */          "Lane 3 Transmit Drive Strength.",
        /* Config-Status */        kDagAttrConfig,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               driver_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT25 | BIT26 | BIT27,
        /* Default Value */        0,
        /* SetValue */             attribute_uint32_set_value,
	/* GetValue */             attribute_uint32_get_value,
	/* SetToString */          attribute_uint32_to_string,
	/* SetFromString */        attribute_uint32_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
#endif /*Tx Driver Register_End*/
   /*IB A Packet Diagnostic Control Register Begin*/ 
   {
        /* Name */                 "tx_packet_type",
        /* Attribute Code */       kUint32AttributeTxPacketType,
        /* Attribute Type */       kAttributeUint32,
        /* Description */          "Transmit Packet Type.",
        /* Config-Status */        kDagAttrConfig,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               packet_diagnostic_control_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT0 | BIT1,
        /* Default Value */        0,
        /* SetValue */             attribute_uint32_set_value,
	/* GetValue */             attribute_uint32_get_value,
	/* SetToString */          attribute_uint32_to_string,
	/* SetFromString */        attribute_uint32_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "tx_icrc_error",
        /* Attribute Code */       kBooleanAttributeTxICRCError,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Transmit ICRC Error.",
        /* Config-Status */        kDagAttrConfig,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               packet_diagnostic_control_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT2,
        /* Default Value */        0,
        /* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "tx_vcrc_error",
        /* Attribute Code */       kBooleanAttributeTxVCRCError,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Transmit VCRC Error.",
        /* Config-Status */        kDagAttrConfig,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               packet_diagnostic_control_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT3,
        /* Default Value */        0,
        /* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "rx_eq_lane_0",
        /* Attribute Code */       kBooleanAttributeRxEqLaneZero,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Recieve Eq Lane 0.",
        /* Config-Status */        kDagAttrConfig,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               packet_diagnostic_control_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT4,
        /* Default Value */        0,
        /* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "rx_eq_lane_1",
        /* Attribute Code */       kBooleanAttributeRxEqLaneOne,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Recieve Eq Lane 1.",
        /* Config-Status */        kDagAttrConfig,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               packet_diagnostic_control_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT5,
        /* Default Value */        0,
        /* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "rx_eq_lane_2",
        /* Attribute Code */       kBooleanAttributeRxEqLaneTwo,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Recieve Eq Lane 2.",
        /* Config-Status */        kDagAttrConfig,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               packet_diagnostic_control_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT6,
        /* Default Value */        0,
        /* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "rx_eq_lane_3",
        /* Attribute Code */       kBooleanAttributeRxEqLaneThree,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Recieve Eq Lane 3.",
        /* Config-Status */        kDagAttrConfig,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               packet_diagnostic_control_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT7,
        /* Default Value */        0,
        /* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "rx_eq_mix_0",
        /* Attribute Code */       kUint32AttributeRxEqMixZero,
        /* Attribute Type */       kAttributeUint32,
        /* Description */          "Recieve Eq Mix 0.",
        /* Config-Status */        kDagAttrConfig,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               packet_diagnostic_control_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT8 | BIT9,
        /* Default Value */        0,
        /* SetValue */             attribute_uint32_set_value,
	/* GetValue */             attribute_uint32_get_value,
	/* SetToString */          attribute_uint32_to_string,
	/* SetFromString */        attribute_uint32_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "rx_eq_mix_1",
        /* Attribute Code */       kUint32AttributeRxEqMixOne,
        /* Attribute Type */       kAttributeUint32,
        /* Description */          "Recieve Eq Mix 1.",
        /* Config-Status */        kDagAttrConfig,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               packet_diagnostic_control_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT10 | BIT11,
        /* Default Value */        0,
        /* SetValue */             attribute_uint32_set_value,
	/* GetValue */             attribute_uint32_get_value,
	/* SetToString */          attribute_uint32_to_string,
	/* SetFromString */        attribute_uint32_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "rx_eq_mix_2",
        /* Attribute Code */       kUint32AttributeRxEqMixTwo,
        /* Attribute Type */       kAttributeUint32,
        /* Description */          "Recieve Eq Mix 2.",
        /* Config-Status */        kDagAttrConfig,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               packet_diagnostic_control_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT12 | BIT13,
        /* Default Value */        0,
        /* SetValue */             attribute_uint32_set_value,
	/* GetValue */             attribute_uint32_get_value,
	/* SetToString */          attribute_uint32_to_string,
	/* SetFromString */        attribute_uint32_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "rx_eq_mix_3",
        /* Attribute Code */       kUint32AttributeRxEqMixThree,
        /* Attribute Type */       kAttributeUint32,
        /* Description */          "Recieve Eq Mix 3.",
        /* Config-Status */        kDagAttrConfig,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               packet_diagnostic_control_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT14 | BIT15,
        /* Default Value */        0,
        /* SetValue */             attribute_uint32_set_value,
	/* GetValue */             attribute_uint32_get_value,
	/* SetToString */          attribute_uint32_to_string,
	/* SetFromString */        attribute_uint32_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "rx_pkt_error_clear",
        /* Attribute Code */       kBooleanAttributePktErrClear,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Pkt Error Clear.",
        /* Config-Status */        kDagAttrConfig,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               packet_diagnostic_control_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT31,
        /* Default Value */        0,
        /* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   }, /*Packet Diagnostic Control Register_End*/
   { /*Packet Diagnostic Status Register Begin*/
        /* Name */                 "rx_packet_type",
        /* Attribute Code */       kUint32AttributeRxPacketType,
        /* Attribute Type */       kAttributeUint32,
        /* Description */          "Recieve Packet Type.",
        /* Config-Status */        kDagAttrStatus,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               packet_diagnostic_status_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT0 | BIT1,
        /* Default Value */        0,
        /* SetValue */             attribute_uint32_set_value,
	/* GetValue */             attribute_uint32_get_value,
	/* SetToString */          attribute_uint32_to_string,
	/* SetFromString */        attribute_uint32_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "rx_packet_length",
        /* Attribute Code */       kUint32AttributeRxPacketLength,
        /* Attribute Type */       kAttributeUint32,
        /* Description */          "Recieve Packet Length.",
        /* Config-Status */        kDagAttrStatus,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               packet_diagnostic_status_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT2 | BIT3 | BIT4 | BIT5 | BIT6 | BIT7 | BIT8 | BIT9 | BIT10 | BIT11 | BIT12,
        /* Default Value */        0,
        /* SetValue */             attribute_uint32_set_value,
	/* GetValue */             attribute_uint32_get_value,
	/* SetToString */          attribute_uint32_to_string,
	/* SetFromString */        attribute_uint32_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "rx_icrc_valid",
        /* Attribute Code */       kBooleanAttributeRxICRCValid,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Recieve ICRC Valid.",
        /* Config-Status */        kDagAttrStatus,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               packet_diagnostic_status_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT13,
        /* Default Value */        0,
        /* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "rx_vcrc_valid",
        /* Attribute Code */       kBooleanAttributeRxVCRCValid,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Recieve VCRC Valid.",
        /* Config-Status */        kDagAttrStatus,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               packet_diagnostic_status_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT14,
        /* Default Value */        0,
        /* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "rx_packet_error_count",
        /* Attribute Code */       kUint32AttributeRxPktErrCount,
        /* Attribute Type */       kAttributeUint32,
        /* Description */          "Rx Packet Error Counter.",
        /* Config-Status */        kDagAttrStatus,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               packet_diagnostic_status_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT20 | BIT21 | BIT22 | BIT23 | BIT24 | BIT25,
        /* Default Value */        0,
        /* SetValue */             attribute_uint32_set_value,
	/* GetValue */             attribute_uint32_get_value,
	/* SetToString */          attribute_uint32_to_string,
	/* SetFromString */        attribute_uint32_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "rx_link_up",
        /* Attribute Code */       kBooleanAttributeRxLinkUp,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Rx Link Up.",
        /* Config-Status */        kDagAttrStatus,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               packet_diagnostic_status_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT30,
        /* Default Value */        0,
        /* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "rx_packet_error_latch",
        /* Attribute Code */       kBooleanAttributeRxFrameError,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Rx Packet Error Latch.",
        /* Config-Status */        kDagAttrStatus,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               packet_diagnostic_status_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT31,
        /* Default Value */        0,
        /* SetValue */             attribute_boolean_set_value,
		/* GetValue */             rx_paket_error_latch_get_value, /*Temporary implementation till 	latch and clear is ready from firmware*/
		/* SetToString */          attribute_boolean_to_string,
		/* SetFromString */        attribute_boolean_from_string,
		/* Dispose */              attribute_dispose,
		/* PostInit */             attribute_post_initialize,
   }, /*Packet_Diagnostic_Status_Register_End*/
   /*Encoder Status Register */
#ifdef ENDACE_LABS	
   {
        /* Name */                 "rx_char_comma_lane_zero",
        /* Attribute Code */       kBooleanAttributeRxCharCommaZero,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Asserts if Rx character in Lane 0 is 8B/10B comma.",
        /* Config-Status */        kDagAttrStatus,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               encoder_status_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT0,
        /* Default Value */        0,
        /* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "rx_char_comma_lane_one",
        /* Attribute Code */       kBooleanAttributeRxCharCommaOne,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Asserts if Rx character in Lane 1 is 8B/10B comma.",
        /* Config-Status */        kDagAttrStatus,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               encoder_status_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT1,
        /* Default Value */        0,
        /* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "rx_char_comma_lane_two",
        /* Attribute Code */       kBooleanAttributeRxCharCommaTwo,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Asserts if Rx character in Lane 2 is 8B/10B comma.",
        /* Config-Status */        kDagAttrStatus,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               encoder_status_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT2,
        /* Default Value */        0,
        /* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "rx_char_comma_lane_three",
        /* Attribute Code */       kBooleanAttributeRxCharCommaThree,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Asserts if Rx character in Lane 3 is 8B/10B comma.",
        /* Config-Status */        kDagAttrStatus,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               encoder_status_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT3,
        /* Default Value */        0,
        /* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "rx_char_k_lane_zero",
        /* Attribute Code */       kBooleanAttributeRxCharKZero,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Asserts if Rx character in Lane 0 is 8B/10B K.",
        /* Config-Status */        kDagAttrStatus,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               encoder_status_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT4,
        /* Default Value */        0,
        /* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "rx_char_k_lane_one",
        /* Attribute Code */       kBooleanAttributeRxCharKOne,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Asserts if Rx character in Lane 1 is 8B/10B K.",
        /* Config-Status */        kDagAttrStatus,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               encoder_status_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT5,
        /* Default Value */        0,
        /* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "rx_char_k_lane_two",
        /* Attribute Code */       kBooleanAttributeRxCharKTwo,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Asserts if Rx character in Lane 2 is 8B/10B K.",
        /* Config-Status */        kDagAttrStatus,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               encoder_status_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT6,
        /* Default Value */        0,
        /* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "rx_char_k_lane_three",
        /* Attribute Code */       kBooleanAttributeRxCharKThree,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Asserts if Rx character in Lane 3 is 8B/10B K.",
        /* Config-Status */        kDagAttrStatus,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               encoder_status_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT7,
        /* Default Value */        0,
        /* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "rx_disparity_error_zero",
        /* Attribute Code */       kBooleanAttributeRxDisparityErrorZero,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Asserts if Rx data in Lane 0 has a disparity error.",
        /* Config-Status */        kDagAttrStatus,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               encoder_status_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT8,
        /* Default Value */        0,
        /* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "rx_disparity_error_one",
        /* Attribute Code */       kBooleanAttributeRxDisparityErrorOne,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Asserts if Rx data in Lane 1 has a disparity error.",
        /* Config-Status */        kDagAttrStatus,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               encoder_status_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT9,
        /* Default Value */        0,
        /* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "rx_disparity_error_two",
        /* Attribute Code */       kBooleanAttributeRxDisparityErrorTwo,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Asserts if Rx data in Lane 2 has a disparity error.",
        /* Config-Status */        kDagAttrStatus,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               encoder_status_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT10,
        /* Default Value */        0,
        /* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "rx_disparity_error_three",
        /* Attribute Code */       kBooleanAttributeRxDisparityErrorThree,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Asserts if Rx data in Lane 3 has a disparity error.",
        /* Config-Status */        kDagAttrStatus,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               encoder_status_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT11,
        /* Default Value */        0,
        /* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "rx_not_in_table_error_zero",
        /* Attribute Code */       kBooleanAttributeRxNotInTableErrorZero,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Asserts if Rx data in Lane 0 is the result of illegal 8B/10B code.",
        /* Config-Status */        kDagAttrStatus,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               encoder_status_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT12,
        /* Default Value */        0,
        /* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "rx_not_in_table_error_one",
        /* Attribute Code */       kBooleanAttributeRxNotInTableErrorOne,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Asserts if Rx data in Lane 1 is the result of illegal 8B/10B code.",
        /* Config-Status */        kDagAttrStatus,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               encoder_status_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT13,
        /* Default Value */        0,
        /* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "rx_not_in_table_error_two",
        /* Attribute Code */       kBooleanAttributeRxNotInTableErrorTwo,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Asserts if Rx data in Lane 2 is the result of illegal 8B/10B code.",
        /* Config-Status */        kDagAttrStatus,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               encoder_status_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT14,
        /* Default Value */        0,
        /* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "rx_not_in_table_error_three",
        /* Attribute Code */       kBooleanAttributeRxNotInTableErrorThree,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Asserts if Rx data in Lane 3 is the result of illegal 8B/10B code.",
        /* Config-Status */        kDagAttrStatus,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               encoder_status_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT15,
        /* Default Value */        0,
        /* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "rx_running_disparity_zero",
        /* Attribute Code */       kBooleanAttributeRxRunningDisparityZero,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Asserts if Rx data in Lane 0 is the result of illegal 8B/10B code.",
        /* Config-Status */        kDagAttrStatus,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               encoder_status_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT16,
        /* Default Value */        0,
        /* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "rx_running_disparity_one",
        /* Attribute Code */       kBooleanAttributeRxRunningDisparityOne,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Asserts if Rx data in Lane 1 is the result of illegal 8B/10B code.",
        /* Config-Status */        kDagAttrStatus,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               encoder_status_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT17,
        /* Default Value */        0,
        /* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "rx_running_disparity_two",
        /* Attribute Code */       kBooleanAttributeRxRunningDisparityTwo,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Asserts if Rx data in Lane 2 is the result of illegal 8B/10B code.",
        /* Config-Status */        kDagAttrStatus,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               encoder_status_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT18,
        /* Default Value */        0,
        /* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "rx_running_disparity_three",
        /* Attribute Code */       kBooleanAttributeRxRunningDisparityThree,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Asserts if Rx data in Lane 3 is the result of illegal 8B/10B code.",
        /* Config-Status */        kDagAttrStatus,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               encoder_status_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT19,
        /* Default Value */        0,
        /* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },/*8B/10B Encoder Status Register_ End*/
   /*Channel Bonding and Byte Alignment Status Register*/
   {
        /* Name */                 "rx_channel_bonding_sequence_zero",
        /* Attribute Code */       kBooleanAttributeRxChannelBondingSeq0,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Asserted when Lane 0 Rx Data contains the start of Channel Bonding Sequence.",
        /* Config-Status */        kDagAttrStatus,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               channel_bonding_and_byte_alignment_status_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT0,
        /* Default Value */        0,
        /* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "rx_channel_bonding_sequence_one",
        /* Attribute Code */       kBooleanAttributeRxChannelBondingSeq1,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Asserted when Lane 1 Rx Data contains the start of Channel Bonding Sequence.",
        /* Config-Status */        kDagAttrStatus,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               channel_bonding_and_byte_alignment_status_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT1,
        /* Default Value */        0,
        /* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "rx_channel_bonding_sequence_two",
        /* Attribute Code */       kBooleanAttributeRxChannelBondingSeq2,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Asserted when Lane 2 Rx Data contains the start of Channel Bonding Sequence.",
        /* Config-Status */        kDagAttrStatus,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               channel_bonding_and_byte_alignment_status_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT2,
        /* Default Value */        0,
        /* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "rx_channel_bonding_sequence_three",
        /* Attribute Code */       kBooleanAttributeRxChannelBondingSeq3,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Asserted when Lane 3 Rx Data contains the start of Channel Bonding Sequence.",
        /* Config-Status */        kDagAttrStatus,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               channel_bonding_and_byte_alignment_status_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT3,
        /* Default Value */        0,
        /* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "rx_clock_correction_count_zero",
        /* Attribute Code */       kUint32AttributeRxClockCorrectionCount0,
        /* Attribute Type */       kAttributeUint32,
        /* Description */          "Reports Clock Correction Status of Elastic Buffer Lanes 0.",
        /* Config-Status */        kDagAttrStatus,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               channel_bonding_and_byte_alignment_status_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT4 | BIT5 | BIT6,
        /* Default Value */        0,
        /* SetValue */             attribute_uint32_set_value,
	/* GetValue */             attribute_uint32_get_value,
	/* SetToString */          attribute_uint32_to_string,
	/* SetFromString */        attribute_uint32_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "rx_clock_correction_count_one",
        /* Attribute Code */       kUint32AttributeRxClockCorrectionCount1,
        /* Attribute Type */       kAttributeUint32,
        /* Description */          "Reports Clock Correction Status of Elastic Buffer Lanes 1.",
        /* Config-Status */        kDagAttrStatus,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               channel_bonding_and_byte_alignment_status_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT7 | BIT8 | BIT9,
        /* Default Value */        0,
        /* SetValue */             attribute_uint32_set_value,
	/* GetValue */             attribute_uint32_get_value,
	/* SetToString */          attribute_uint32_to_string,
	/* SetFromString */        attribute_uint32_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "rx_clock_correction_count_two",
        /* Attribute Code */       kUint32AttributeRxClockCorrectionCount2,
        /* Attribute Type */       kAttributeUint32,
        /* Description */          "Reports Clock Correction Status of Elastic Buffer Lanes 2.",
        /* Config-Status */        kDagAttrStatus,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               channel_bonding_and_byte_alignment_status_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT10 | BIT11 | BIT12,
        /* Default Value */        0,
        /* SetValue */             attribute_uint32_set_value,
	/* GetValue */             attribute_uint32_get_value,
	/* SetToString */          attribute_uint32_to_string,
	/* SetFromString */        attribute_uint32_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "rx_clock_correction_count_three",
        /* Attribute Code */       kUint32AttributeRxClockCorrectionCount3,
        /* Attribute Type */       kAttributeUint32,
        /* Description */          "Reports Clock Correction Status of Elastic Buffer Lanes 3.",
        /* Config-Status */        kDagAttrStatus,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               channel_bonding_and_byte_alignment_status_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT13 | BIT14 | BIT15,
        /* Default Value */        0,
        /* SetValue */             attribute_uint32_set_value,
	/* GetValue */             attribute_uint32_get_value,
	/* SetToString */          attribute_uint32_to_string,
	/* SetFromString */        attribute_uint32_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "rx_byte_align_realign_zero",
        /* Attribute Code */       kBooleanAttributeRxByteRealign0,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Asserted if the byte alignment of Lane 0 has changed due to comma detection.",
        /* Config-Status */        kDagAttrStatus,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               channel_bonding_and_byte_alignment_status_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT16,
        /* Default Value */        0,
        /* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "rx_byte_align_realign_one",
        /* Attribute Code */       kBooleanAttributeRxByteRealign1,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Asserted if the byte alignment of Lane 1 has changed due to comma detection.",
        /* Config-Status */        kDagAttrStatus,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               channel_bonding_and_byte_alignment_status_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT17,
        /* Default Value */        0,
        /* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "rx_byte_align_realign_two",
        /* Attribute Code */       kBooleanAttributeRxByteRealign2,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Asserted if the byte alignment of Lane 2 has changed due to comma detection.",
        /* Config-Status */        kDagAttrStatus,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               channel_bonding_and_byte_alignment_status_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT18,
        /* Default Value */        0,
        /* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "rx_byte_align_realign_three",
        /* Attribute Code */       kBooleanAttributeRxByteRealign3,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Asserted if the byte alignment of Lane 3 has changed due to comma detection.",
        /* Config-Status */        kDagAttrStatus,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               channel_bonding_and_byte_alignment_status_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT19,
        /* Default Value */        0,
        /* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "rx_comma_detect_zero",
        /* Attribute Code */       kBooleanAttributeRxCommaDetect0,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Asserted Comma Alignment Block Lane 0 Detects a comma.",
        /* Config-Status */        kDagAttrStatus,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               channel_bonding_and_byte_alignment_status_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT20,
        /* Default Value */        0,
        /* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "rx_comma_detect_one",
        /* Attribute Code */       kBooleanAttributeRxCommaDetect1,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Asserted Comma Alignment Block Lane 1 Detects a comma.",
        /* Config-Status */        kDagAttrStatus,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               channel_bonding_and_byte_alignment_status_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT21,
        /* Default Value */        0,
        /* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "rx_comma_detect_two",
        /* Attribute Code */       kBooleanAttributeRxCommaDetect2,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Asserted Comma Alignment Block Lane 2 Detects a comma.",
        /* Config-Status */        kDagAttrStatus,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               channel_bonding_and_byte_alignment_status_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT22,
        /* Default Value */        0,
        /* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "rx_comma_detect_three",
        /* Attribute Code */       kBooleanAttributeRxCommaDetect3,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Asserted Comma Alignment Block Lane 3 Detects a comma.",
        /* Config-Status */        kDagAttrStatus,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               channel_bonding_and_byte_alignment_status_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT23,
        /* Default Value */        0,
        /* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "rx_realign_zero",
        /* Attribute Code */       kBooleanAttributeRxRealign0,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Indicates a change in alignment between Transciver Lane 0 and Master.",
        /* Config-Status */        kDagAttrStatus,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               channel_bonding_and_byte_alignment_status_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT24,
        /* Default Value */        0,
        /* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "rx_realign_one",
        /* Attribute Code */       kBooleanAttributeRxRealign1,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Indicates a change in alignment between Transciver Lane 1 and Master.",
        /* Config-Status */        kDagAttrStatus,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               channel_bonding_and_byte_alignment_status_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT25,
        /* Default Value */        0,
        /* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "rx_realign_two",
        /* Attribute Code */       kBooleanAttributeRxRealign2,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Indicates a change in alignment between Transciver Lane 2 and Master.",
        /* Config-Status */        kDagAttrStatus,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               channel_bonding_and_byte_alignment_status_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT26,
        /* Default Value */        0,
        /* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   {
        /* Name */                 "rx_realign_three",
        /* Attribute Code */       kBooleanAttributeRxRealign3,
        /* Attribute Type */       kAttributeBoolean,
        /* Description */          "Indicates a change in alignment between Transciver Lane 3 and Master.",
        /* Config-Status */        kDagAttrStatus,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               channel_bonding_and_byte_alignment_status_register,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 BIT27,
        /* Default Value */        0,
        /* SetValue */             attribute_boolean_set_value,
	/* GetValue */             attribute_boolean_get_value,
	/* SetToString */          attribute_boolean_to_string,
	/* SetFromString */        attribute_boolean_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
#endif
   /*Rx Byte Counter*/  
   {
        /* Name */                 "rx_byte_count",
        /* Attribute Code */       kUint32AttributeRxByteCount,
        /* Attribute Type */       kAttributeUint32,
        /* Description */          "Recieved Byte Counter .(Wraps Around).",
        /* Config-Status */        kDagAttrStatus,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               rx_byte_counter,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 0xFFFFFFFF,
        /* Default Value */        0,
        /* SetValue */             attribute_uint32_set_value,
	/* GetValue */             attribute_uint32_get_value,
	/* SetToString */          attribute_uint32_to_string,
	/* SetFromString */        attribute_uint32_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   /*Rx Packet Counter*/
   {
        /* Name */                 "rx_packet_count",
        /* Attribute Code */       kUint32AttributeRxPacketCount,
        /* Attribute Type */       kAttributeUint32,
        /* Description */          "Recieved Packet Counter .(Wraps Around).",
        /* Config-Status */        kDagAttrStatus,
        /* Index in register */    0,
        /* Register Address */     DAG_REG_INFI_FRAMER,
        /* Offset */               rx_packet_counter,
        /* Size/length */          1,
        /* Read */                 grw_iom_read,
        /* Write */                grw_iom_write,
        /* Mask */                 0xFFFFFFFF,
        /* Default Value */        0,
        /* SetValue */             attribute_uint32_set_value,
	/* GetValue */             attribute_uint32_get_value,
	/* SetToString */          attribute_uint32_to_string,
	/* SetFromString */        attribute_uint32_from_string,
	/* Dispose */              attribute_dispose,
	/* PostInit */             attribute_post_initialize,
   },
   /*New attributes. To Disable Receiving of Link Packets.*/
   {
		/* Name */                 "disable_link_packets",
		/* Attribute Code */       kBooleanAttributeDisableLinkPackets,
		/* Attribute Type */       kAttributeBoolean,
		/* Description */          "Disable Receiving of Link Packets..",
		/* Config-Status */        kDagAttrConfig,
		/* Index in register */    0,
		/* Register Address */     DAG_REG_INFI_FRAMER,
		/* Offset */               reset_register,
		/* Size/length */          1,
		/* Read */                 grw_iom_read,
		/* Write */                grw_iom_write,
		/* Mask */                 BIT28,
		/* Default Value */        1,
		/* SetValue */             attribute_boolean_set_value,
		/* GetValue */             attribute_boolean_get_value,
		/* SetToString */          attribute_boolean_to_string,
		/* SetFromString */        attribute_boolean_from_string,
		/* Dispose */              attribute_dispose,
		/* PostInit */             attribute_post_initialize,
   },
   /*To disable / enable the receiving of Data Packets.*/	
   {
		/* Name */                 "disable_data_packets",
		/* Attribute Code */       kBooleanAttributeDisableDataPackets,
		/* Attribute Type */       kAttributeBoolean,
		/* Description */          "Disable Receiving of Data Packets..",
		/* Config-Status */        kDagAttrConfig,
		/* Index in register */    0,
		/* Register Address */     DAG_REG_INFI_FRAMER,
		/* Offset */               reset_register,
		/* Size/length */          1,
		/* Read */                 grw_iom_read,
		/* Write */                grw_iom_write,
		/* Mask */                 BIT29,
		/* Default Value */        0,
		/* SetValue */             attribute_boolean_set_value,
		/* GetValue */             attribute_boolean_get_value,
		/* SetToString */          attribute_boolean_to_string,
		/* SetFromString */        attribute_boolean_from_string,
		/* Dispose */              attribute_dispose,
		/* PostInit */             attribute_post_initialize,
   },

};
#define NB_ELEM (sizeof(infiniband_front_end_attr) / sizeof(Attribute_t))
ComponentPtr
framer_get_new_component(DagCardPtr card, uint32_t index)
{
    ComponentPtr result = component_init(kComponentInfiniBandFramer, card);
    framer_state_t* state = NULL;
    if (NULL != result)
    {
       component_set_dispose_routine(result, framer_dispose);
       component_set_post_initialize_routine(result, framer_post_initialize);
       component_set_reset_routine(result, framer_reset);
       component_set_default_routine(result, framer_default);
       component_set_name(result, "Framer");
       component_set_description(result, "The Framer.");
       state = (framer_state_t*)malloc(sizeof(framer_state_t));
       state->mIndex = index;
       component_set_private_state(result, state);
       return result;
    }   
    return NULL;
}   
void framer_dispose(ComponentPtr component)
{

}
void framer_reset(ComponentPtr component)
{
	 /*GTP reset. May need to reset other attributes.*/
	 /*GTP Zero Resets the Lane 0 and 1*/
	 /*GTP One Resets the Lane 2 and 3*/
	 AttributePtr attribute = NULL;
	 uint32_t value = 0;
	 DagCardPtr card = component_get_card(component);
	 attribute = component_get_attribute(component,kUint32AttributeGtpReset);
         if(attribute == NULL)
         {
                card_set_last_error(card,kDagErrNoSuchAttribute);
		return;
         }
         value = 3;
         attribute_uint32_set_value(attribute,&value,1);
	 /*Clear the gtp reset*/
	 value = 0;
	 attribute_uint32_set_value(attribute,&value,1);	

}
void framer_default(ComponentPtr component)
{
	/*Added when default called to be called framer reset */
	framer_reset(component);
}
int framer_post_initialize(ComponentPtr component)
{
    if (1 == valid_component(component))
    {
        
	DagCardPtr card = NULL;
	framer_state_t* framer_state = NULL;		
	AttributePtr attr = NULL;
	GenericReadWritePtr grw = NULL;	
	uintptr_t offset = 0;
	uintptr_t base_reg = 0;
	uint32_t mask = 0;
	uintptr_t address = 0;

	/* Get card reference */
	card = component_get_card(component);
        /*Get counter state structure */
	framer_state = component_get_private_state(component);
        /* Add attribute of counter */ 
        read_attr_array(component,infiniband_front_end_attr, NB_ELEM, framer_state->mIndex);
	/*These calculations are for the combined Phase Locked Loop Detect Attribute.*/
	base_reg = card_get_register_address(card,DAG_REG_INFI_FRAMER,framer_state->mIndex);
	offset = diagnostic_register_1;
	address = ((uintptr_t)card_get_iom_address(card) + base_reg + offset);
	mask = BIT4|BIT5;
	grw = grw_init(card,address,grw_iom_read,grw_iom_write);
	attr = framer_pll_detect_attribute(grw,&mask,1);
	component_add_attribute(component,attr);
	/*GTP Reset Done attribute for all the four lanes (0 - 3)*/
	address = ((uintptr_t)card_get_iom_address(card) + base_reg + offset);
	mask = BIT6 | BIT7 | BIT8 | BIT9;
	grw = grw_init(card,address,grw_iom_read,grw_iom_write);
	attr = 	framer_gtp_reset_attribute(grw,&mask,1);
	component_add_attribute(component,attr);
	
	return 1;
     }
    return kDagErrInvalidParameter;
}
/*This is a combined attribute for the PLL Detect of Tile 0 and Tile 1*/
AttributePtr
framer_pll_detect_attribute(GenericReadWritePtr grw,const uint32_t *bit_masks,uint32_t len)
{
	AttributePtr result = NULL;
	result = attribute_init(kBooleanAttributePLLDetect);
	attribute_set_name(result,"pll detect");
	attribute_set_description(result,"The Phase Locked Loop Detected For Tile 0 and Tile 1.");
	attribute_set_generic_read_write_object(result,grw);
	attribute_set_config_status(result,kDagAttrStatus);
	attribute_set_valuetype(result,kAttributeBoolean);
	attribute_set_getvalue_routine(result,pll_detect_get_value);
	attribute_set_setvalue_routine(result,attribute_boolean_set_value); /*not to be used status attribute*/
	attribute_set_to_string_routine(result,attribute_boolean_to_string);
	attribute_set_from_string_routine(result,attribute_boolean_from_string);
	attribute_set_masks(result,bit_masks,len);
	return result;
}
static void*
pll_detect_get_value(AttributePtr attribute)
{
	GenericReadWritePtr grw = NULL;
	uint32_t value = 0;	
	bool return_value = 0;
	if(1 == valid_attribute(attribute))
	{
		grw = attribute_get_generic_read_write_object(attribute);
		assert(grw);
		/*reading the two bits*/
		value = grw_read(grw);
		if(((value&0x30) >> 4) == 0x3)
		{
			/*Both the Phase Locked Loops are detected.*/
			return_value = 1;	
		}
		else
		{
			return_value = 0;	
		}
		attribute_set_value_array(attribute,(void*)&return_value,sizeof(return_value));
		return (void *)attribute_get_value_array(attribute);
	}
	return NULL;
}
/*This is the combined attribute for GTP Reset for all the four lanes.*/
AttributePtr
framer_gtp_reset_attribute(GenericReadWritePtr grw,const uint32_t *bit_masks,uint32_t len)
{
	AttributePtr result = NULL;
	result = attribute_init(kBooleanAttributeGTPResetDone);
	attribute_set_name(result,"GTP Reset Status");
	attribute_set_description(result,"The GTP Reset for all the four lanes.");
	attribute_set_generic_read_write_object(result,grw);
	attribute_set_config_status(result,kDagAttrStatus);
	attribute_set_valuetype(result,kAttributeBoolean);
	attribute_set_getvalue_routine(result,gtp_reset_get_value);
	attribute_set_setvalue_routine(result,attribute_boolean_set_value); /*not to be used status attribute*/
	attribute_set_to_string_routine(result,attribute_boolean_to_string);
	attribute_set_from_string_routine(result,attribute_boolean_from_string);
	attribute_set_masks(result,bit_masks,len);
	return result;
}
static void*
gtp_reset_get_value(AttributePtr attribute)
{
	GenericReadWritePtr grw = NULL;
	uint32_t value = 0;
	bool return_value = 0;
	if( 1 == valid_attribute(attribute))
	{
		grw = attribute_get_generic_read_write_object(attribute);
		assert(grw);
		value = grw_read(grw);
		if(((value&0x1E0) >> 5) == 0xf)
		{
			return_value = 1;
		}
		else
		{
			return_value = 0;
		}
		attribute_set_value_array(attribute,(void*)&return_value,sizeof(return_value));
		return (void *)attribute_get_value_array(attribute);
	}
	return NULL;
}
/* This is only a temporary implementation till the 
 * latch and clear version or Clear on Read Version
 * of the attribute is implemented by the firmware.
 * */
static void*
rx_paket_error_latch_get_value(AttributePtr attribute)
{
	ComponentPtr component = NULL;
	AttributePtr clear_attribute = NULL;
	bool value = false;
	bool clear = true;
	if(1 == valid_attribute(attribute))
	{
		component = attribute_get_component(attribute);
		/*get clear attribute*/
		clear_attribute = component_get_attribute(component,kBooleanAttributePktErrClear);	
	
		/*read the value of the attribute*/	
		
		value = *(bool*)attribute_boolean_get_value(attribute);
		
		/*clear the attribute.by writing to the appropriate register.*/
		attribute_boolean_set_value(clear_attribute,&clear,1);

		/*Return the read value of the attribute.*/
		attribute_set_value_array(attribute,&value,sizeof(value));
		return (void*)attribute_get_value_array(attribute);
	}
	return NULL;
}

                                                      
