/*
 * Copyright (c) 2004-2009 Endace Technology Ltd, Hamilton, New Zealand.
 * All rights reserved.
 *
 * This source code is proprietary to Endace Technology Limited and no part
 * of it may be redistributed, published or disclosed except as outlined in
 * the written contract supplied with this product.
 *
 * $Id: vdagapi.h 13302 2010-10-07 03:51:40Z alexey.korolev $
 */

#ifndef VDAGAPI_H
#define VDAGAPI_H

#include "dagapi.h"

/**
 * @brief               Set device id for VDAG driver
 *
 * @param[in] vdagfd A file descriptor for a VDAG device
 * @param[in] dev_id    A device id set to VDAG driver
 * @param[in] brd_rev	A board revision set to VDAG driver
 *
 * @return              0 on success, otherwise -1 with erron set 
 *                      as appropriately.
 */
int vdag_set_device_info(int vdagfd, uint16_t dev_id, uint8_t brd_rev);

/**
 * @brief               Insert a virtual firmware module into 
 *                      VDAG driver
 *
 * @param[in] vdagfd A file descriptor for a VDAG device
 * @param[in] reg_module A module to be inserted to DRB space
 * @param[in] addr	An address of module to be inserted to DRB space
 * @param[in] ver	A version of module to be inserted to DRB space
 *
 * @return              0 on success, otherwise -1 with erron set
 *                      as appropriately
 *
*/ 
int vdag_insert_module(int vdagfd, uint32_t reg_module, uint32_t addr, uint32_t ver);

/**
 * @brief               Remove a virtual firmware module from 
 *                      VDAG driver
 *
 * @param[in] vdagfd A file descriptor for VDAG device
 * @param[in] reg_module A module to be inserted to DRB space
 * @param[in] addr	An address of module to be inserted to DRB space
 *
 * @return              0 on success, otherwise -1 with erron set
 *                      as appropriately
 *
 */
int vdag_remove_module(int vdagfd, uint32_t reg_module, uint32_t addr);

/**
 * @brief               Set the number of receive and transmit stream in
 * 			PBM version 3
 *                      
 *
 * @param[in] vdagfd A file descriptor for VDAG device
 * @param[in] rx_stream_num The number of rx stream
 * @param[in] tx_stream_num The number of tx stream
 * 
 * @return              0 on success, otherwise -1 with erron set
 *                      as appropriately
 *
 */
int vdag_set_stream_count(int vdagfd, uint8_t rx_stream_num, uint8_t tx_stream_num);

int vdag_lock_all_stream(int vdagfd);

int vdag_unlock_all_stream(int vdagfd);

int vdag_alloc_memory(int vdagfd, uint32_t size, int32_t node);

#endif

