/*
 * Copyright (c) 2004-2005 Endace Technology Ltd, Hamilton, New Zealand.
 * All rights reserved.
 *
 * This source code is proprietary to Endace Technology Limited and no part
 * of it may be redistributed, published or disclosed except as outlined in
 * the written contract supplied with this product.
 *
 * $Id: parse_tree_node.h 1541 2005-06-02 22:19:38Z koryn $
 */

#ifndef PARSE_TREE_NODE_H
#define PARSE_TREE_NODE_H

/* Endace headers. */
#include "dagutil.h"


#if defined (_WIN32)
#include "wintypedefs.h"
#include "filtertypedefs.h"
#endif


typedef struct PtNode_ PtNode_;
typedef PtNode_* PtNodePtr; /* Type-safe opaque type. */

#ifndef IPPROTO_IGRP
#define IPPROTO_IGRP 9
#endif /* IPPROTO_IGRP */

typedef enum
{
	PTN_INVALID = 0,
	PTN_AND,
	kFirstNodeType = PTN_AND,
	PTN_ANDNOT,
	PTN_OR,
	PTN_NOT,
	PTN_EQUALS,
	PTN_NOT_EQUALS,
	PTN_TCP_FLAGS,
	PTN_HOST,
	PTN_PROTOCOL,
	PTN_IP,
	PTN_PORT,
	kLastNodeType = PTN_PORT

} node_t;


typedef enum
{
	QUAL_INVALID = 0,
	kFirstQualifier = QUAL_INVALID,
	QUAL_SRC,
	QUAL_DST,
	QUAL_BOTH,
	kLastQualifier = QUAL_BOTH

} qualifiers_t;


typedef enum
{
	TCP_FLAG_OP_INVALID = 0,
	kFirstTcpFlagOp = TCP_FLAG_OP_INVALID,
	TCP_FLAG_OP_EQUALS,
	TCP_FLAG_OP_NOT_EQUALS,
	kLastTcpFlagOp = TCP_FLAG_OP_NOT_EQUALS

} tcp_flag_op_t;


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


/* Construction/destruction. */
PtNodePtr ptn_init(node_t type);
void ptn_dispose(PtNodePtr node);

/* Accessors and mutators. */
node_t ptn_get_type(PtNodePtr node);
PtNodePtr ptn_get_parent(PtNodePtr node);
void ptn_set_parent(PtNodePtr node, PtNodePtr parent);
PtNodePtr ptn_get_next_child(PtNodePtr node, PtNodePtr prev_child);
PtNodePtr ptn_get_sibling(PtNodePtr node);
void ptn_add_child(PtNodePtr node, PtNodePtr child);
void ptn_add_sibling(PtNodePtr node, PtNodePtr sibling);
uint8_t ptn_get_protocol(PtNodePtr node);
void ptn_set_protocol(PtNodePtr node, uint8_t protocol);
uint16_t ptn_get_port(PtNodePtr node);
void ptn_set_port(PtNodePtr node, uint16_t port);  /* port should be provided in network byte order. */
in_addr_t ptn_get_host(PtNodePtr node);
uint32_t ptn_get_netmask(PtNodePtr node);
void ptn_set_host(PtNodePtr node, in_addr_t host, uint32_t netmask);  /* host and netmask should be provided in network byte order. */
qualifiers_t ptn_get_qualifiers(PtNodePtr node);
void ptn_set_qualifiers(PtNodePtr node, qualifiers_t qualifiers);
uint8_t ptn_get_tcp_flags_value(PtNodePtr node);
uint8_t ptn_get_tcp_flags_mask(PtNodePtr node);
void ptn_set_tcp_flags(PtNodePtr node, uint8_t flags, tcp_flag_op_t flag_op, uint8_t comparand);
uint32_t ptn_count_children(PtNodePtr node);

void ptn_display(PtNodePtr node, FILE* outfile);
void ptn_display_recursive(PtNodePtr node, FILE* outfile);


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* PARSE_TREE_NODE_H */
