/*
 * Copyright (c) 2004-2005 Endace Technology Ltd, Hamilton, New Zealand.
 * All rights reserved.
 *
 * This source code is proprietary to Endace Technology Limited and no part
 * of it may be redistributed, published or disclosed except as outlined in
 * the written contract supplied with this product.
 *
 * $Id: rule_lib.c 1934 2005-08-08 21:12:33Z koryn $
 */

/* File header. */
#include "rule_lib.h"

/* Endace headers. */
#include "dagutil.h"


/* CVS header. */
static const char * const kRuleLibCvsHeader __attribute__ ((unused)) = "$Id: rule_lib.c 1934 2005-08-08 21:12:33Z koryn $";


static variable_t* uPortVariables = NULL;
static variable_t* uAddressVariables = NULL;


variable_t*
get_address_variable(const char* name)
{
	variable_t* current = uAddressVariables;

	while (current)
	{
		if (strcmp(current->name, name) == 0)
		{
			return current;
		}

		current = current->next;
	}

	return NULL;
}


void
add_address_variable(const char* name, list_node_t* addresses)
{
	variable_t* new_var = (variable_t*) malloc(sizeof(variable_t));

	if (new_var)
	{
		memset(new_var, 0, sizeof(variable_t));
		new_var->name = name;
		new_var->addr_list = addresses;

		new_var->next = uAddressVariables;
		uAddressVariables = new_var;
	}
}


variable_t*
get_port_variable(const char* name)
{
	variable_t* current = uPortVariables;

	while (current)
	{
		if (strcmp(current->name, name) == 0)
		{
			return current;
		}

		current = current->next;
	}

	return NULL;
}


void
add_port_variable(const char* name, ipf_port_t* port_spec)
{
	variable_t* new_var = (variable_t*) malloc(sizeof(variable_t));

	if (new_var)
	{
		memset(new_var, 0, sizeof(variable_t));
		new_var->name = name;
		memcpy(&new_var->ports, port_spec, sizeof(ipf_port_t));
		
		new_var->next = uPortVariables;
		uPortVariables = new_var;
	}
}
