/*
 * Copyright (c) 2004-2007 Endace Technology Ltd, Hamilton, New Zealand.
 * All rights reserved.
 *
 * This source code is proprietary to Endace Technology Limited and no part
 * of it may be redistributed, published or disclosed except as outlined in
 * the written contract supplied with this product.
 *
 * $Id: dagpf_tcpdump.h 6998 2007-06-18 04:22:11Z vladimir $
 */


#ifndef DAGPF_TCPDUMP_H
#define DAGPF_TCPDUMP_H

#include <stdio.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define DAGPF_TCPDUMP_OBFUSCATE   0x01 /**< obfuscate addresses/ports in rules */
#define DAGPF_TCPDUMP_REJECT_ICMP 0x02 /**< reject ICMP packets by default */
#define DAGPF_TCPDUMP_REJECT_IGRP 0x04 /**< reject IGRP packets by default */
#define DAGPF_TCPDUMP_REJECT_IP   0x08 /**< reject IP packets by default */
#define DAGPF_TCPDUMP_REJECT_TCP  0x10 /**< reject TCP packets by default */
#define DAGPF_TCPDUMP_REJECT_UDP  0x20 /**< reject UDP packets by default */

/**
 * Convert Tcpdump rules
 *
 * Read rules from 'infile' given in Tcpdump-like format and convert
 * them into Endace rules. Only a subset of the formats is supported,
 * for actual grammar see 'Coprocessor IP Filter manual'. Obfuscate
 * addresses/port numbers and create accept/reject rules for the
 * supported protocols if required by the flags.
 *
 * This function is non-reentrant.
 *
 * \param infile   file containing Tcpdump rules 
 * \param outfile  file for resulting Endace rules 
 * \param flags    rule obfuscation and protocol rejection flags
 *
 * \return non-zero in case of errors, zero otherwise
 */
int dagpf_tcpdump_to_endace(FILE* infile, FILE* outfile, uint32_t flags);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* DAGPF_TCPDUMP_H */
