/*
 * Copyright (c) 2007 Endace Technology Ltd, Hamilton, New Zealand.
 * All rights reserved.
 *
 * This source code is proprietary to Endace Technology Limited and no part
 * of it may be redistributed, published or disclosed except as outlined in
 * the written contract supplied with this product.
 * DESCRITION:
 * This example demonstrates how to open a dag device in a system(OS) independent manner
 * The translation unit is used to translate the dag name and the stream number to the proper device name
 * the device name may vary from OS to OS and that is why we need a translation or OS independent function
 *
 * $Id: simpleopen.c 11447 2009-06-29 00:28:46Z dlim $
 */	
	
	
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>
#include <errno.h>

#include "dagapi.h"
#include "dagutil.h"

int main (void)
{

        char dagname_buf[500];
        char dagname[] ="dag0";
        int dagstream = 0;	
	int dagfd;

	/* Translate the dag name to a OS specific device name
	 * Because dag_open requires the device name to be proper device name for the OS 
	 * we do that translation with the folloing function
	*/
	if (-1 == dag_parse_name(dagname_buf, dagname, DAGNAME_BUFSIZE,
&dagstream))
	{
		dagutil_panic("dag_parse_name(%s): %s\n", dagname_buf,
					strerror(errno));
	}
	
	/*
	 * this function opens the device for access 
	*/
	
	dagfd = dag_open(dagname);
	/* prints to the stdout the current opend fd */
	printf("dagfd : %d\n",dagfd);
	/* cleses the dag card */
	dag_close(dagfd);
	
	return 0;
}
