/*
 * Copyright (c) 1999
 *
 * $Id: dagdebug.h 3662 2006-03-20 22:56:57Z koryn $
 */
#ifndef DAGDEBUG_H
#define DAGDEBUG_H
/*
 * Debugging printouts are defined in 5 different stages:
 *	DA - message is always printed
 *	DU - message is always printed to user terminal
 *	DD - message is printed when DAGDEBUG defined
 *	DV - message is printed when DAGVERBOSE defined
 *	DN - message is never printed
 */
#define DA(MSG) dagdebug MSG
#define DU(MSG) uprintf MSG

#ifdef  DAGDEBUG
#define DD(MSG) dagdebug MSG
#else
#define DD(MSG)
#endif /* DAGDEBUG */

#ifdef  DAGVERBOSE
#define DV(MSG) dagdebug MSG
#else
#define DV(MSG)
#endif /* DAGVERBOSE */

#define DN(MSG)

static void dagdebug(char *fmt, ...); /* local within every C file */

#endif /* DAGDEBUG_H */
