#ifndef __iwl_trans_idi_h__
#define __iwl_trans_idi_h__

#include "shared.h"
#include "iwl-trans.h"
#include "idi_rx.h"
#include "idi_tx.h"

#define IWL_IDI_SG_LIST_END BIT(0)
#define IWL_IDI_SG_LIST_INT BIT(1)
#define IWL_IDI_SG_LIST_END_INT (IWL_IDI_SG_LIST_INT | IWL_IDI_SG_LIST_END)

/* define mask for irq's */
#ifndef IWL_IDI_LLS_INT
#define IWL_IDI_LLS_INT 0X1
#define IWL_IDI_HW_ERR_INT 0X2
#define IWL_IDI_SW_ERR_INT 0X4
#define IWL_IDI_FH_TX_INT 0X8
#endif

#ifndef CPTCFG_IWLWIFI_IDI_OVER_PCI
struct iwl_idi_platdata {
	struct clk * wifi_clk;
	struct clk * rtc_clk;
	struct reset_control * core_rst;
	struct reset_control * pmu_rst;
};
#endif

struct iwl_trans_idi {
	struct iwl_drv *drv;
	struct iwl_trans *trans;
	struct iwl_idi_trans_rx trans_rx;
	struct iwl_idi_trans_tx trans_tx;

#ifdef CPTCFG_IWLWIFI_IDI_OVER_PCI
	struct iwl_trans *trans_pcie;
#else
	struct idi_peripheral_device *pdev;
	void __iomem *al_hw_base;
	/* protect hw registers */
	spinlock_t reg_lock;
#endif

	/* pending irqs */
	atomic_t irq_data;
};

#define IWL_TRANS_GET_IDI_TRANS(_iwl_trans) \
	((struct iwl_trans_idi *)\
		((IWL_TRANS_GET_SLV_TRANS(_iwl_trans))->bus_specific))

#define IWL_TRANS_GET_IDI_TRANS_RX(_iwl_trans) \
	((struct iwl_idi_trans_rx *)\
		&((IWL_TRANS_GET_IDI_TRANS(_iwl_trans))->trans_rx))

#define IWL_TRANS_GET_IDI_TRANS_TX(_iwl_trans) \
	((struct iwl_idi_trans_tx *)\
		&((IWL_TRANS_GET_IDI_TRANS(_iwl_trans))->trans_tx))

#define IWL_TRANS_SLV_GET_IDI_TRANS(_slv_trans)\
	((struct iwl_trans_idi *)((_slv_trans)->bus_specific))

#define IWL_TRANS_SLV_GET_IDI_TRANS_RX(_slv_trans)\
	((struct iwl_idi_trans_rx *)\
		&((IWL_TRANS_SLV_GET_IDI_TRANS(_slv_trans))->trans_rx))

#define IWL_TRANS_SLV_GET_IDI_TRANS_TX(_slv_trans)\
	((struct iwl_idi_trans_tx *)\
		&((IWL_TRANS_SLV_GET_IDI_TRANS(_slv_trans))->trans_tx))

#define IWL_TRANS_RX_GET_TRANS(_iwl_trans_rx) \
	((struct iwl_trans *)((struct iwl_trans_idi *)\
				(_iwl_trans_rx)->trans_idi)->trans)

#define IWL_TRANS_TX_GET_TRANS(_iwl_trans_tx) \
	((struct iwl_trans *)((struct iwl_trans_idi *)\
				(_iwl_trans_tx)->trans_idi)->trans)

/* Rx handlers */
int iwl_idi_rx_init(struct iwl_trans *trans);
void iwl_idi_rx_stop(struct iwl_trans *trans);
void iwl_idi_rx_free(struct iwl_trans *trans);

/* Tx handlers */
int iwl_idi_tx_init(struct iwl_trans *trans);
void iwl_idi_tx_stop(struct iwl_trans *trans);
void iwl_idi_tx_free(struct iwl_trans *trans);
int iwl_idi_tx_data_send(struct iwl_trans *trans, struct sk_buff *skb,
			 struct iwl_device_cmd *dev_cmd, int txq_id);
void iwl_idi_tx_cancel_cmd(struct iwl_trans *trans, int cmd_idx);

#endif

