#ifndef __iwl_trans_rx_idi_h__
#define __iwl_trans_rx_idi_h__

#include <linux/module.h>
#include <linux/kthread.h>
#include <linux/kernel.h>
#include <linux/types.h>
#include <linux/init.h>
#include <linux/wait.h>
#include <linux/proc_fs.h>
#include <linux/interrupt.h>
#include <linux/dma-mapping.h>

#include <linux/atomic.h>
#include <linux/kfifo.h>

#include "idi_utils.h"

#ifdef CPTCFG_IWLWIFI_IDI_OVER_PCI
#include "iwl-emulation.h"
#else
#include <linux/idi/idi_interface.h>
#endif

#define SG_LIST_MAX_SIZE 16	/* number of logical descriptors (4 entries) */
#define SG_LIST_DMA_DESC_NUM 4	/* number of desc in one logical desc */
#define SG_LIST_NUM 15		/* default number of SG LLs */

/* the size of the signature data for the sync (kick0) phase, in bytes */
#define IWL_IDI_RX_SIG_SIZE 4

#define IWL_IDI_RX_BG_POOL_SIZE 512
#define IWL_IDI_RX_BG_POOL_TRSHLD 400
#define IWL_IDI_RX_READY_PAGES_MAX_NUM 256

/**
* the state machine of the Rx
*/
enum iwl_trans_idi_rx_state {
	IWL_IDI_RX_STOPPED,	/* idi rx transport is stopped */
	IWL_IDI_RX_KICK0,	/* kick0 */
	IWL_IDI_RX_DATA,	/* waiting for real rx data */
	IWL_IDI_RX_NO_SG_LIST	/* all sg lists are waiting/in dma */
};

#define IWL_IDI_RX_SM_MISC_KICK0_IS_ON 0
#define IWL_IDI_RX_SM_MISC_DMA_ARMED 1

struct iwl_idi_rx_sm {
	enum iwl_trans_idi_rx_state state;
	unsigned long misc;
};

/**
* struct iwl_idi_trans_rx_stats - statistics for tuning the module
* @used_sg_lists: the number of sg lists ever used
* @sg_list_filled: the maximum number of entries used for each sg list
*/
struct iwl_idi_trans_rx_stats {
	u8 used_sg_lists;
	u16 sg_list_filled[SG_LIST_NUM];
};

struct iwl_idi_sg_list_holder {
	struct iwl_idi_dma_ptr sg_list;
	struct iwl_rx_mem_buffer *addr_map[SG_LIST_MAX_SIZE];
	struct list_head list;
};

/*
TODO: consider using first 4 bytes of each page as the pointer to the page
TODO: instead of using mem_buf_pool and addr_map.
*/

/**
 * struct iwl_idi_trans_rx
 * @trans_idi:pointer to the general IDI transport
 * @free_sg_lists: SG LLs that are ready to use
 * @used_sg_lists: SG LLs that with received pages
 * @rxb_pool: pool of RXBs with allocated pages
 * @armed_sg_list: pointer to SG LL currently in DMA
 * @sg_list_kick0: the SG list for reading signature
 * @sm:the state machine of rx transport
 * @page_fifo:fifo that holds pages allocated in a background worker
 * @ready_pages_fifo: received pages to be processed
 * @page_proc_wrk: worker for passing received pages up
 * @page_refill_wrk:worker which allocates pages in the background
 * @wq: workqueue for rx transport sole use
 */
struct iwl_idi_trans_rx {
	struct iwl_trans_idi *trans_idi;
	struct list_head free_sg_lists;
	struct list_head used_sg_lists;
	struct kmem_cache *rxb_pool;
	struct iwl_idi_sg_list_holder *armed_sg_list;
	struct iwl_idi_dma_ptr sg_list_kick0;
#ifndef CPTCFG_IWLWIFI_IDI_OVER_PCI
	struct idi_transaction *transaction;
#endif
	struct iwl_idi_rx_sm sm;
	struct kfifo page_fifo;
	struct kfifo ready_pages_fifo;
	struct work_struct page_proc_wrk;
	struct work_struct page_refill_wrk;
	struct workqueue_struct *wq;

#ifdef CPTCFG_IWLWIFI_DEBUGFS
	struct iwl_idi_trans_rx_stats stats;
#endif
};

#ifndef CPTCFG_IWLWIFI_IDI_OVER_PCI
int iwl_idi_rx_set_channel_config(struct idi_peripheral_device *);
#endif

#endif
