/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.domimpl.HTMLTableCellElementImpl;
import org.lobobrowser.html.renderer.FrameContext;
import org.lobobrowser.html.renderer.RBlock;
import org.lobobrowser.html.renderer.RenderableContainer;
import org.lobobrowser.html.renderer.TableMatrix;
import org.lobobrowser.html.renderer.VirtualCell;

class RTableCell
extends RBlock {
    private final HTMLTableCellElementImpl cellElement;
    private VirtualCell topLeftVirtualCell;
    private int cellPadding;
    private int colSpan = -1;
    private int rowSpan = -1;

    public RTableCell(HTMLTableCellElementImpl element, UserAgentContext pcontext, HtmlRendererContext rcontext, FrameContext frameContext, RenderableContainer tableAsContainer) {
        super(element, 0, pcontext, rcontext, frameContext, tableAsContainer);
        this.cellElement = element;
    }

    public void setCellPadding(int value) {
        this.cellPadding = value;
    }

    protected int getDeclaredHeight(int availHeight) {
        return -1;
    }

    protected int getDeclaredWidth(int availWidth) {
        return -1;
    }

    public void finalize() throws Throwable {
        super.finalize();
    }

    public void setTopLeftVirtualCell(VirtualCell vc2) {
        this.topLeftVirtualCell = vc2;
    }

    public VirtualCell getTopLeftVirtualCell() {
        return this.topLeftVirtualCell;
    }

    public int getVirtualColumn() {
        VirtualCell vc2 = this.topLeftVirtualCell;
        return vc2 == null ? 0 : vc2.getColumn();
    }

    public int getVirtualRow() {
        VirtualCell vc2 = this.topLeftVirtualCell;
        return vc2 == null ? 0 : vc2.getRow();
    }

    public int getColSpan() {
        int cs2 = this.colSpan;
        if (cs2 == -1) {
            cs2 = this.cellElement.getColSpan();
            if (cs2 < 1) {
                cs2 = 1;
            }
            this.colSpan = cs2;
        }
        return cs2;
    }

    public int getRowSpan() {
        int rs2 = this.rowSpan;
        if (rs2 == -1) {
            rs2 = this.cellElement.getRowSpan();
            if (rs2 < 1) {
                rs2 = 1;
            }
            this.rowSpan = rs2;
        }
        return rs2;
    }

    public String getHeightText() {
        return this.cellElement.getHeight();
    }

    public String getWidthText() {
        return this.cellElement.getWidth();
    }

    public void setCellBounds(TableMatrix.SizeInfo[] colSizes, TableMatrix.SizeInfo[] rowSizes, int hasBorder, int cellSpacingX, int cellSpacingY) {
        int height;
        int rowSpan;
        int width;
        int vcol = this.getVirtualColumn();
        int vrow = this.getVirtualRow();
        TableMatrix.SizeInfo colSize = colSizes[vcol];
        TableMatrix.SizeInfo rowSize = rowSizes[vrow];
        int x10 = colSize.offset;
        int y10 = rowSize.offset;
        int colSpan = this.getColSpan();
        if (colSpan > 1) {
            width = 0;
            for (int i10 = 0; i10 < colSpan; ++i10) {
                int vc2 = vcol + i10;
                width += colSizes[vc2].actualSize;
                if (i10 + 1 >= colSpan) continue;
                width += cellSpacingX + hasBorder * 2;
            }
        } else {
            width = colSizes[vcol].actualSize;
        }
        if ((rowSpan = this.getRowSpan()) > 1) {
            height = 0;
            for (int i11 = 0; i11 < rowSpan; ++i11) {
                int vr2 = vrow + i11;
                height += rowSizes[vr2].actualSize;
                if (i11 + 1 >= rowSpan) continue;
                height += cellSpacingY + hasBorder * 2;
            }
        } else {
            height = rowSizes[vrow].actualSize;
        }
        this.setBounds(x10, y10, width, height);
    }
}

