/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import org.lobobrowser.html.domimpl.HTMLBaseInputElement;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.domimpl.ImageEvent;
import org.lobobrowser.html.domimpl.ImageListener;
import org.lobobrowser.html.renderer.BaseInputControl;
import org.lobobrowser.html.renderer.RenderableSpot;
import org.lobobrowser.html.style.HtmlValues;
import org.lobobrowser.util.gui.WrapperLayout;

class InputImageControl
extends BaseInputControl
implements ImageListener {
    private boolean mouseBeingPressed;
    private int valign = 5;
    private Dimension preferredSize;
    private int declaredWidth;
    private int declaredHeight;
    private Image image;

    public InputImageControl(HTMLBaseInputElement modelNode) {
        super(modelNode);
        this.setLayout(WrapperLayout.getInstance());
        modelNode.addImageListener(this);
    }

    public void reset(int availWidth, int availHeight) {
        super.reset(availWidth, availHeight);
        HTMLElementImpl element = this.controlElement;
        int dw2 = HtmlValues.getOldSyntaxPixelSize(element.getAttribute("width"), availWidth, -1);
        int dh2 = HtmlValues.getOldSyntaxPixelSize(element.getAttribute("height"), availHeight, -1);
        this.declaredWidth = dw2;
        this.declaredHeight = dh2;
        this.preferredSize = this.createPreferredSize(dw2, dh2);
        String alignText = element.getAttribute("align");
        int valign = alignText == null ? 5 : ("middle".equals(alignText = alignText.toLowerCase().trim()) ? 1 : ("absmiddle".equals(alignText) ? 3 : ("top".equals(alignText) ? 0 : ("bottom".equals(alignText) ? 2 : ("baseline".equals(alignText) ? 5 : ("absbottom".equals(alignText) ? 4 : 5))))));
        this.valign = valign;
    }

    public int getVAlign() {
        return this.valign;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintComponent(Graphics g10) {
        Color over;
        super.paintComponent(g10);
        Dimension size = this.getSize();
        Insets insets = this.getInsets();
        InputImageControl inputImageControl = this;
        synchronized (inputImageControl) {
        }
        Image image = this.image;
        if (image != null) {
            g10.drawImage(image, insets.left, insets.top, size.width - insets.left - insets.right, size.height - insets.top - insets.bottom, this);
        }
        if (this.mouseBeingPressed && (over = new Color(255, 100, 100, 64)) != null) {
            Color oldColor = g10.getColor();
            try {
                g10.setColor(over);
                g10.fillRect(0, 0, size.width, size.height);
            }
            finally {
                g10.setColor(oldColor);
            }
        }
    }

    public Dimension getPreferredSize() {
        Dimension ps2 = this.preferredSize;
        return ps2 == null ? new Dimension(0, 0) : ps2;
    }

    public Dimension createPreferredSize(int dw2, int dh2) {
        Image img = this.image;
        if (dw2 == -1) {
            int n10 = dw2 = img == null ? -1 : img.getWidth(this);
            if (dw2 == -1) {
                dw2 = 0;
            }
        }
        if (dh2 == -1) {
            int n11 = dh2 = img == null ? -1 : img.getHeight(this);
            if (dh2 == -1) {
                dh2 = 0;
            }
        }
        return new Dimension(dw2, dh2);
    }

    private final boolean checkPreferredSizeChange() {
        Dimension newPs = this.createPreferredSize(this.declaredWidth, this.declaredHeight);
        Dimension ps2 = this.preferredSize;
        if (ps2 == null) {
            return true;
        }
        if (ps2.width != newPs.width || ps2.height != newPs.height) {
            this.preferredSize = newPs;
            return true;
        }
        return false;
    }

    public boolean imageUpdate(Image img, int infoflags, int x10, int y10, int w10, int h10) {
        if ((infoflags & 0x20) != 0 || (infoflags & 0x10) != 0) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    if (!InputImageControl.this.checkPreferredSizeChange()) {
                        InputImageControl.this.repaint();
                    } else {
                        InputImageControl.this.ruicontrol.preferredSizeInvalidated();
                    }
                }
            });
        }
        return true;
    }

    public void imageUpdate(Image img, int w10, int h10) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                if (!InputImageControl.this.checkPreferredSizeChange()) {
                    InputImageControl.this.repaint();
                } else {
                    InputImageControl.this.ruicontrol.preferredSizeInvalidated();
                }
            }
        });
    }

    public boolean paintSelection(Graphics g10, boolean inSelection, RenderableSpot startPoint, RenderableSpot endPoint) {
        return inSelection;
    }

    public void imageLoaded(ImageEvent event) {
        Image image = event.image;
        try {
            this.image = image;
            int width = image.getWidth(this);
            int height = image.getHeight(this);
            if (width != -1 && height != -1) {
                this.imageUpdate(image, width, height);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void resetInput() {
    }
}

